/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.websocket.ClientEndpointConfiguration;
import javax.net.websocket.Decoder;
import javax.net.websocket.Encoder;
import javax.net.websocket.Endpoint;
import javax.net.websocket.ServerEndpointConfiguration;
import javax.net.websocket.Session;
import javax.net.websocket.annotations.WebSocketEndpoint;
import org.glassfish.tyrus.AnnotatedEndpoint;
import org.glassfish.tyrus.EndpointWrapper;
import org.glassfish.tyrus.WithProperties;
import org.glassfish.tyrus.server.DefaultServerEndpointConfiguration;
import org.glassfish.tyrus.server.ServerConfiguration;
import org.glassfish.tyrus.server.ServerContainer;
import org.glassfish.tyrus.spi.SPIRegisteredEndpoint;
import org.glassfish.tyrus.spi.TyrusServer;

public class TyrusServerContainer
extends WithProperties
implements ServerContainer,
javax.net.websocket.ServerContainer {
    private final TyrusServer server;
    private final String contextPath;
    private final ServerConfiguration configuration;
    private final Set<SPIRegisteredEndpoint> endpoints = new HashSet<SPIRegisteredEndpoint>();

    public TyrusServerContainer(TyrusServer server, String contextPath, final ServerConfiguration configuration) {
        this.server = server;
        this.contextPath = contextPath;
        this.configuration = new ServerConfiguration(){
            private final Set<Class<?>> endpointClasses;
            private final Set<ServerConfiguration.EndpointWithConfiguration> endpointInstances;
            private final long maxSessionIdleTimeout;
            private final long maxBinaryMessageBufferSize;
            private final long maxTextMessageBufferSize;
            private final List<String> extensions;
            {
                this.endpointClasses = Collections.unmodifiableSet(new HashSet(configuration.getEndpointClasses()));
                this.endpointInstances = Collections.unmodifiableSet(new HashSet<ServerConfiguration.EndpointWithConfiguration>(configuration.getEndpointInstances()));
                this.maxSessionIdleTimeout = configuration.getMaxSessionIdleTimeout();
                this.maxBinaryMessageBufferSize = configuration.getMaxBinaryMessageBufferSize();
                this.maxTextMessageBufferSize = configuration.getMaxTextMessageBufferSize();
                this.extensions = Collections.unmodifiableList(new ArrayList<String>(configuration.getExtensions()));
            }

            @Override
            public Set<Class<?>> getEndpointClasses() {
                return this.endpointClasses;
            }

            @Override
            public Set<ServerConfiguration.EndpointWithConfiguration> getEndpointInstances() {
                return this.endpointInstances;
            }

            @Override
            public long getMaxSessionIdleTimeout() {
                return this.maxSessionIdleTimeout;
            }

            @Override
            public long getMaxBinaryMessageBufferSize() {
                return this.maxBinaryMessageBufferSize;
            }

            @Override
            public long getMaxTextMessageBufferSize() {
                return this.maxTextMessageBufferSize;
            }

            @Override
            public List<String> getExtensions() {
                return this.extensions;
            }
        };
    }

    @Override
    public ServerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void start() throws IOException {
        this.server.start();
        HashSet<ServerConfiguration.EndpointWithConfiguration> allEndpoints = new HashSet<ServerConfiguration.EndpointWithConfiguration>(this.configuration.getEndpointInstances());
        for (Class<?> endpointClass : this.configuration.getEndpointClasses()) {
            WebSocketEndpoint wseAnnotation = endpointClass.getAnnotation(WebSocketEndpoint.class);
            if (wseAnnotation == null) {
                Logger.getLogger(this.getClass().getName()).warning("Endpoint class " + endpointClass.getName() + " not " + "annotated with @WebSocketEndpoint annotation, so will be ignored.");
                continue;
            }
            String endpointPath = wseAnnotation.value();
            AnnotatedEndpoint annotatedEndpoint = new AnnotatedEndpoint(endpointClass);
            ArrayList<Encoder> encoders = new ArrayList<Encoder>();
            if (wseAnnotation.encoders() != null) {
                for (Class encoderClass : wseAnnotation.encoders()) {
                    try {
                        encoders.add((Encoder)encoderClass.newInstance());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to instantiate encoder: " + encoderClass.getName(), e);
                    }
                }
            }
            ArrayList<Decoder> decoders = new ArrayList<Decoder>();
            if (wseAnnotation.decoders() != null) {
                for (Class decoderClass : wseAnnotation.decoders()) {
                    try {
                        decoders.add((Decoder)decoderClass.newInstance());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to instantiate decoder: " + decoderClass.getName(), e);
                    }
                }
            }
            DefaultServerEndpointConfiguration config = ((DefaultServerEndpointConfiguration.Builder)((DefaultServerEndpointConfiguration.Builder)((DefaultServerEndpointConfiguration.Builder)((DefaultServerEndpointConfiguration.Builder)new DefaultServerEndpointConfiguration.Builder(endpointPath).encoders(encoders)).decoders(decoders)).protocols(wseAnnotation.subprotocols() == null ? Collections.emptyList() : Arrays.asList(wseAnnotation.subprotocols()))).extensions(this.configuration.getExtensions())).origins(Collections.<String>emptyList()).build();
            allEndpoints.add(new ServerConfiguration.EndpointWithConfiguration(annotatedEndpoint, config));
            Logger.getLogger(this.getClass().getName()).info("Registered a " + endpointClass + " at " + endpointPath);
        }
        for (ServerConfiguration.EndpointWithConfiguration endpoint : allEndpoints) {
            EndpointWrapper ew = new EndpointWrapper(endpoint.getEndpoint(), endpoint.getConfiguration(), this, this.contextPath);
            SPIRegisteredEndpoint ge = this.server.register(ew);
            this.endpoints.add(ge);
        }
    }

    @Override
    public void stop() {
        for (SPIRegisteredEndpoint wsa : this.endpoints) {
            wsa.remove();
            this.server.unregister(wsa);
            Logger.getLogger(this.getClass().getName()).info("Closing down : " + wsa);
        }
        this.server.stop();
    }

    @Override
    public void publishServer(Endpoint endpoint, ServerEndpointConfiguration ilc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectToServer(Endpoint endpoint, ClientEndpointConfiguration olc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Session> getActiveSessions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMaxSessionIdleTimeout() {
        return this.configuration.getMaxSessionIdleTimeout();
    }

    @Override
    public void setMaxSessionIdleTimeout(long timeout) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMaxBinaryMessageBufferSize() {
        return this.configuration.getMaxBinaryMessageBufferSize();
    }

    @Override
    public void setMaxBinaryMessageBufferSize(long max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMaxTextMessageBufferSize() {
        return this.configuration.getMaxTextMessageBufferSize();
    }

    @Override
    public void setMaxTextMessageBufferSize(long max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getInstalledExtensions() {
        return Collections.unmodifiableSet(new HashSet<String>(this.configuration.getExtensions()));
    }
}

