/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.tyrus.ServiceFinder;
import org.glassfish.tyrus.spi.ComponentProvider;

public class ComponentProviderService {
    public static <T> T getInstance(Class<T> c) {
        ServiceFinder<ComponentProvider> finder = ServiceFinder.find(ComponentProvider.class);
        T loaded = null;
        for (ComponentProvider componentProvider : finder) {
            if (!componentProvider.isApplicable(c)) continue;
            try {
                loaded = componentProvider.provideInstance(c);
                break;
            }
            catch (Exception e) {
                Logger.getLogger(ComponentProviderService.class.getName()).log(Level.WARNING, "Component provider " + componentProvider.getClass().getName() + " threw exception when providing instance of class " + c.getName() + ".", e);
            }
        }
        if (loaded == null) {
            try {
                loaded = c.newInstance();
            }
            catch (Exception e) {
                Logger.getLogger(ComponentProviderService.class.getName()).log(Level.SEVERE, "Endpoint class " + c.getName() + " could not be instantiated.", e);
            }
        }
        return loaded;
    }
}

