/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.ClientContainer;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfiguration;
import javax.websocket.RemoteEndpoint;
import javax.websocket.ServerEndpointConfiguration;
import org.glassfish.tyrus.DecoderWrapper;
import org.glassfish.tyrus.NoOpBinaryCoder;
import org.glassfish.tyrus.NoOpTextCoder;
import org.glassfish.tyrus.PrimitiveDecoders;
import org.glassfish.tyrus.ReflectionHelper;
import org.glassfish.tyrus.SessionImpl;
import org.glassfish.tyrus.ToStringEncoder;
import org.glassfish.tyrus.internal.PathPattern;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIHandshakeRequest;

public class EndpointWrapper
extends SPIEndpoint {
    private final ClientContainer container;
    private final String contextPath;
    private final List<DecoderWrapper> decoders = new ArrayList<DecoderWrapper>();
    private final List<Encoder> encoders = new ArrayList<Encoder>();
    private final EndpointConfiguration configuration;
    private final Endpoint endpoint;
    private final Map<RemoteEndpoint, SessionImpl> remoteEndpointToSession = new ConcurrentHashMap<RemoteEndpoint, SessionImpl>();
    private String uri;
    private final Map<String, String> templateValues = new HashMap<String, String>();
    private boolean isSecure;
    private String queryString;

    public EndpointWrapper(Endpoint endpoint, ClientContainer container, String contextPath) {
        this.endpoint = endpoint;
        this.configuration = endpoint.getEndpointConfiguration() == null ? new EndpointConfiguration(){

            @Override
            public List<Encoder> getEncoders() {
                return Collections.emptyList();
            }

            @Override
            public List<Decoder> getDecoders() {
                return Collections.emptyList();
            }
        } : endpoint.getEndpointConfiguration();
        this.container = container;
        this.contextPath = contextPath;
        for (Decoder dec : this.configuration.getDecoders()) {
            if (dec instanceof DecoderWrapper) {
                this.decoders.add((DecoderWrapper)dec);
                continue;
            }
            Class<?> type = this.getDecoderClassType(dec.getClass());
            this.decoders.add(new DecoderWrapper(dec, type, dec.getClass()));
        }
        this.decoders.addAll(PrimitiveDecoders.ALL_WRAPPED);
        this.decoders.add(new DecoderWrapper(NoOpTextCoder.INSTANCE, String.class, NoOpTextCoder.class));
        this.decoders.add(new DecoderWrapper(NoOpBinaryCoder.INSTANCE, ByteBuffer.class, NoOpBinaryCoder.class));
        this.encoders.addAll(this.configuration.getEncoders());
        this.encoders.add(NoOpTextCoder.INSTANCE);
        this.encoders.add(NoOpBinaryCoder.INSTANCE);
        this.encoders.add(ToStringEncoder.INSTANCE);
    }

    @Override
    public boolean checkHandshake(SPIHandshakeRequest hr) {
        if (!(this.configuration instanceof ServerEndpointConfiguration)) {
            return false;
        }
        ServerEndpointConfiguration sec = (ServerEndpointConfiguration)this.configuration;
        this.uri = hr.getRequestUri();
        this.queryString = hr.getQueryString();
        this.isSecure = hr.isSecure();
        PathPattern pathPattern = new PathPattern(this.getEndpointPath(sec.getPath()));
        boolean match = pathPattern.match(this.uri, pathPattern.getTemplate().getTemplateVariables(), this.templateValues);
        return match && sec.checkOrigin(hr.getHeader("Origin"));
    }

    private String getEndpointPath(String relativePath) {
        return (this.contextPath.endsWith("/") ? this.contextPath.substring(0, this.contextPath.length() - 1) : this.contextPath) + "/" + (relativePath.startsWith("/") ? relativePath.substring(1) : relativePath);
    }

    public Object decodeCompleteMessage(Object message, Class<?> type) {
        for (DecoderWrapper dec : this.decoders) {
            try {
                if (dec.getDecoder() instanceof Decoder.Text) {
                    if (type == null || !type.isAssignableFrom(dec.getType()) || !((Decoder.Text)dec.getDecoder()).willDecode((String)message)) continue;
                    return ((Decoder.Text)dec.getDecoder()).decode((String)message);
                }
                if (dec.getDecoder() instanceof Decoder.Binary) {
                    if (type == null || !type.isAssignableFrom(dec.getType()) || !((Decoder.Binary)dec.getDecoder()).willDecode((ByteBuffer)message)) continue;
                    return ((Decoder.Binary)dec.getDecoder()).decode((ByteBuffer)message);
                }
                if (dec.getDecoder() instanceof Decoder.TextStream) {
                    if (type == null || !type.isAssignableFrom(dec.getType())) continue;
                    return ((Decoder.TextStream)dec.getDecoder()).decode(new StringReader((String)message));
                }
                if (!(dec.getDecoder() instanceof Decoder.BinaryStream) || type == null || !type.isAssignableFrom(dec.getType())) continue;
                byte[] array = ((ByteBuffer)message).array();
                return ((Decoder.BinaryStream)dec.getDecoder()).decode(new ByteArrayInputStream(array));
            }
            catch (DecodeException de) {
                de.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private ArrayList<DecoderWrapper> findApplicableDecoders(Object message, boolean isString) {
        ArrayList<DecoderWrapper> result = new ArrayList<DecoderWrapper>();
        for (DecoderWrapper dec : this.decoders) {
            if (isString && Decoder.Text.class.isAssignableFrom(dec.getOriginalClass())) {
                if (!((Decoder.Text)dec.getDecoder()).willDecode((String)message)) continue;
                result.add(dec);
                continue;
            }
            if (!isString && Decoder.Binary.class.isAssignableFrom(dec.getOriginalClass())) {
                if (!((Decoder.Binary)dec.getDecoder()).willDecode((ByteBuffer)message)) continue;
                result.add(dec);
                continue;
            }
            if (isString && Decoder.TextStream.class.isAssignableFrom(dec.getOriginalClass())) {
                result.add(dec);
                continue;
            }
            if (isString || !Decoder.BinaryStream.class.isAssignableFrom(dec.getOriginalClass())) continue;
            result.add(dec);
        }
        return result;
    }

    Object doEncode(Object message) throws EncodeException {
        for (Encoder enc : this.encoders) {
            try {
                Class<?> type;
                if (enc instanceof Encoder.Binary) {
                    type = ReflectionHelper.getClassType(enc.getClass(), Encoder.Binary.class);
                    if (!type.isAssignableFrom(message.getClass())) continue;
                    return ((Encoder.Binary)enc).encode(message);
                }
                if (enc instanceof Encoder.Text) {
                    type = ReflectionHelper.getClassType(enc.getClass(), Encoder.Text.class);
                    if (!type.isAssignableFrom(message.getClass())) continue;
                    return ((Encoder.Text)enc).encode(message);
                }
                if (enc instanceof Encoder.BinaryStream) {
                    type = ReflectionHelper.getClassType(enc.getClass(), Encoder.BinaryStream.class);
                    if (!type.isAssignableFrom(message.getClass())) continue;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ((Encoder.BinaryStream)enc).encode(message, new ByteArrayOutputStream());
                    return baos;
                }
                if (!(enc instanceof Encoder.TextStream) || !(type = ReflectionHelper.getClassType(enc.getClass(), Encoder.TextStream.class)).isAssignableFrom(message.getClass())) continue;
                StringWriter writer = new StringWriter();
                ((Encoder.TextStream)enc).encode(message, writer);
                return writer;
            }
            catch (EncodeException ee) {
                throw ee;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new EncodeException(message, "Unable to encode ");
    }

    @Override
    public List<String> getNegotiatedExtensions(List<String> clientExtensions) {
        if (!(this.configuration instanceof ServerEndpointConfiguration)) {
            return null;
        }
        ServerEndpointConfiguration sec = (ServerEndpointConfiguration)this.configuration;
        return sec.getNegotiatedExtensions(clientExtensions);
    }

    @Override
    public String getNegotiatedProtocol(List<String> clientProtocols) {
        if (!(this.configuration instanceof ServerEndpointConfiguration)) {
            return null;
        }
        ServerEndpointConfiguration sec = (ServerEndpointConfiguration)this.configuration;
        return sec.getNegotiatedSubprotocol(clientProtocols);
    }

    @Override
    public void remove() {
    }

    @Override
    public void onConnect(RemoteEndpoint gs, String subprotocol, List<String> extensions) {
        SessionImpl session = new SessionImpl(this.container, gs, this, subprotocol, extensions, this.isSecure, this.uri == null ? null : URI.create(this.uri), this.queryString, this.templateValues);
        this.remoteEndpointToSession.put(gs, session);
        this.endpoint.onOpen(session);
    }

    @Override
    public void onMessage(RemoteEndpoint gs, ByteBuffer messageBytes) {
        SessionImpl session = this.remoteEndpointToSession.get(gs);
        session.notifyMessageHandlers((Object)messageBytes, this.findApplicableDecoders(messageBytes, false));
    }

    @Override
    public void onMessage(RemoteEndpoint gs, String messageString) {
        SessionImpl session = this.remoteEndpointToSession.get(gs);
        session.notifyMessageHandlers((Object)messageString, this.findApplicableDecoders(messageString, true));
    }

    @Override
    public void onPartialMessage(RemoteEndpoint gs, String partialString, boolean last) {
        SessionImpl session = this.remoteEndpointToSession.get(gs);
        session.notifyMessageHandlers((Object)partialString, last);
    }

    @Override
    public void onPartialMessage(RemoteEndpoint gs, ByteBuffer partialBytes, boolean last) {
        SessionImpl session = this.remoteEndpointToSession.get(gs);
        session.notifyMessageHandlers((Object)partialBytes, last);
    }

    @Override
    public void onPong(RemoteEndpoint gs, ByteBuffer bytes) {
    }

    @Override
    public void onPing(RemoteEndpoint gs, ByteBuffer bytes) {
        SessionImpl session = this.remoteEndpointToSession.get(gs);
        session.getRemote().sendPong(bytes);
    }

    @Override
    public void onClose(RemoteEndpoint gs) {
        SessionImpl session = this.remoteEndpointToSession.get(gs);
        this.endpoint.onClose(new CloseReason(null, "Normal Closure"));
        this.remoteEndpointToSession.remove(gs);
    }

    boolean isActive(SessionImpl session) {
        return this.remoteEndpointToSession.values().contains(session);
    }

    private Class<?> getDecoderClassType(Class<?> decoderClass) {
        if (Decoder.Binary.class.isAssignableFrom(decoderClass)) {
            return ReflectionHelper.getClassType(decoderClass, Decoder.Binary.class);
        }
        if (Decoder.Text.class.isAssignableFrom(decoderClass)) {
            return ReflectionHelper.getClassType(decoderClass, Decoder.Text.class);
        }
        if (Decoder.BinaryStream.class.isAssignableFrom(decoderClass)) {
            return ReflectionHelper.getClassType(decoderClass, Decoder.BinaryStream.class);
        }
        if (Decoder.TextStream.class.isAssignableFrom(decoderClass)) {
            return ReflectionHelper.getClassType(decoderClass, Decoder.TextStream.class);
        }
        return null;
    }
}

