/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.websocket.ClientContainer;
import javax.websocket.CloseReason;
import javax.websocket.Encoder;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import org.glassfish.tyrus.AsyncMessageHandler;
import org.glassfish.tyrus.BasicMessageHandler;
import org.glassfish.tyrus.DecoderWrapper;
import org.glassfish.tyrus.EndpointWrapper;
import org.glassfish.tyrus.ReflectionHelper;
import org.glassfish.tyrus.RemoteEndpointWrapper;

public class SessionImpl
implements Session {
    private final ClientContainer container;
    private final EndpointWrapper endpoint;
    private final RemoteEndpointWrapper remote;
    private final String negotiatedSubprotocol;
    private final List<String> negotiatedExtensions;
    private final boolean isSecure;
    private final URI uri;
    private final String queryString;
    private final Map<String, String> pathParameters;
    private Map<MessageHandler, MessageHandler> messageHandlerToInvokableMessageHandlers = new HashMap<MessageHandler, MessageHandler>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private long timeout;
    private long maximumMessageSize = 8192L;
    private static final Logger LOGGER = Logger.getLogger(SessionImpl.class.getName());
    private long lastConnectionActivity;

    SessionImpl(ClientContainer container, RemoteEndpoint remoteEndpoint, EndpointWrapper endpointWrapper, String subprotocol, List<String> extensions, boolean isSecure, URI uri, String queryString, Map<String, String> pathParameters) {
        this.container = container;
        this.endpoint = endpointWrapper;
        this.negotiatedSubprotocol = subprotocol;
        this.negotiatedExtensions = extensions == null ? Collections.emptyList() : Collections.unmodifiableList(extensions);
        this.isSecure = isSecure;
        this.uri = uri;
        this.queryString = queryString;
        this.pathParameters = Collections.unmodifiableMap(pathParameters);
        this.remote = new RemoteEndpointWrapper(this, remoteEndpoint, endpointWrapper);
    }

    @Override
    public String getProtocolVersion() {
        return "13";
    }

    @Override
    public String getNegotiatedSubprotocol() {
        return this.negotiatedSubprotocol;
    }

    @Override
    public RemoteEndpoint getRemote() {
        return this.remote;
    }

    @Override
    public boolean isActive() {
        return this.endpoint.isActive(this);
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void close() throws IOException {
        this.close(new CloseReason(CloseReason.CloseCodes.NORMAL_CLOSURE, "no reason given"));
    }

    @Override
    public void close(CloseReason closeReason) throws IOException {
        this.remote.close(closeReason);
    }

    public String toString() {
        return "Session(" + this.hashCode() + ", " + this.isActive() + ")";
    }

    @Override
    public void setTimeout(long seconds) {
        this.timeout = seconds;
    }

    @Override
    public void setMaximumMessageSize(long maximumMessageSize) {
        this.maximumMessageSize = maximumMessageSize;
    }

    @Override
    public long getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    @Override
    public List<String> getNegotiatedExtensions() {
        return this.negotiatedExtensions;
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public long getInactiveTime() {
        return (System.currentTimeMillis() - this.lastConnectionActivity) / 1000L;
    }

    @Override
    public ClientContainer getContainer() {
        return this.container;
    }

    @Override
    public void setEncoders(List<Encoder> encoders) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addMessageHandler(MessageHandler listener) {
        this.messageHandlerToInvokableMessageHandlers.put(listener, listener);
    }

    @Override
    public Set<MessageHandler> getMessageHandlers() {
        return Collections.unmodifiableSet(this.messageHandlerToInvokableMessageHandlers.keySet());
    }

    @Override
    public void removeMessageHandler(MessageHandler listener) {
        this.messageHandlerToInvokableMessageHandlers.remove(listener);
    }

    @Override
    public URI getRequestURI() {
        return this.uri;
    }

    @Override
    public Map<String, String[]> getRequestParameterMap() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    void updateLastConnectionActivity() {
        this.lastConnectionActivity = System.currentTimeMillis();
    }

    void notifyMessageHandlers(Object message, List<DecoderWrapper> availableDecoders) {
        this.updateLastConnectionActivity();
        boolean decoded = false;
        if (availableDecoders.isEmpty()) {
            LOGGER.severe("No decoder found");
        }
        for (DecoderWrapper decoder : availableDecoders) {
            for (MessageHandler mh : this.getOrderedMessageHandlers()) {
                Object object;
                Class<?> type;
                if (!(mh instanceof MessageHandler.Basic) || !(type = this.getHandlerType(mh)).isAssignableFrom(decoder.getType()) || (object = this.endpoint.decodeCompleteMessage(message, type)) == null) continue;
                ((MessageHandler.Basic)mh).onMessage(object);
                decoded = true;
                break;
            }
            if (!decoded) continue;
            break;
        }
    }

    void notifyMessageHandlers(Object message, boolean last) {
        boolean handled = false;
        for (MessageHandler handler : this.getInvokableMessageHandlers()) {
            if (!(handler instanceof MessageHandler.Async) || !this.getHandlerType(handler).isAssignableFrom(message.getClass())) continue;
            ((MessageHandler.Async)handler).onMessage(message, last);
            handled = true;
            break;
        }
        if (!handled) {
            LOGGER.severe("Unhandled text message in EndpointWrapper");
        }
    }

    Set<MessageHandler> getInvokableMessageHandlers() {
        HashSet<MessageHandler> s = new HashSet<MessageHandler>();
        for (MessageHandler mh : this.messageHandlerToInvokableMessageHandlers.values()) {
            s.add(mh);
        }
        return s;
    }

    private List<MessageHandler> getOrderedMessageHandlers() {
        Set<MessageHandler> handlers = this.getMessageHandlers();
        ArrayList<MessageHandler> result = new ArrayList<MessageHandler>();
        result.addAll(handlers);
        Collections.sort(result, new MessageHandlerComparator());
        return result;
    }

    private Class<?> getHandlerType(MessageHandler handler) {
        Class root;
        if (handler instanceof AsyncMessageHandler) {
            return ((AsyncMessageHandler)handler).getType();
        }
        if (handler instanceof BasicMessageHandler) {
            return ((BasicMessageHandler)handler).getType();
        }
        if (handler instanceof MessageHandler.Async) {
            root = MessageHandler.Async.class;
        } else if (handler instanceof MessageHandler.Basic) {
            root = MessageHandler.Basic.class;
        } else {
            throw new IllegalArgumentException(handler.getClass().getName());
        }
        Class<?> result = ReflectionHelper.getClassType(handler.getClass(), root);
        return result == null ? Object.class : result;
    }

    private class MessageHandlerComparator
    implements Comparator<MessageHandler> {
        private MessageHandlerComparator() {
        }

        @Override
        public int compare(MessageHandler o1, MessageHandler o2) {
            if (o1 instanceof MessageHandler.Basic) {
                if (o2 instanceof MessageHandler.Basic) {
                    Class type2;
                    Class type1 = SessionImpl.this.getHandlerType(o1);
                    if (type1.isAssignableFrom(type2 = SessionImpl.this.getHandlerType(o2))) {
                        return 1;
                    }
                    if (type2.isAssignableFrom(type1)) {
                        return -1;
                    }
                    return 0;
                }
                return 1;
            }
            if (o2 instanceof MessageHandler.Basic) {
                return 1;
            }
            return 0;
        }
    }
}

