/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.grizzly;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.websocket.EncodeException;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import org.glassfish.grizzly.websockets.WebSocket;

public class GrizzlyRemoteEndpoint
implements RemoteEndpoint {
    private WebSocket socket;
    private static ConcurrentHashMap<WebSocket, GrizzlyRemoteEndpoint> sockets = new ConcurrentHashMap();

    public GrizzlyRemoteEndpoint(WebSocket socket) {
        this.socket = socket;
    }

    public static GrizzlyRemoteEndpoint get(WebSocket socket) {
        GrizzlyRemoteEndpoint s = sockets.get(socket);
        if (s == null) {
            s = new GrizzlyRemoteEndpoint(socket);
            sockets.put(socket, s);
        }
        return s;
    }

    public static void remove(WebSocket socket) {
        sockets.remove(socket);
    }

    @Override
    public void sendString(String text) throws IOException {
        this.socket.send(text);
    }

    @Override
    public void sendBytes(ByteBuffer byteBuffer) throws IOException {
        this.socket.send(byteBuffer.array());
    }

    @Override
    public void sendPartialString(String fragment, boolean isLast) throws IOException {
        this.socket.stream(isLast, fragment);
    }

    @Override
    public void sendPartialBytes(ByteBuffer byteBuffer, boolean b) throws IOException {
        byte[] bytes = byteBuffer.array();
        this.socket.stream(b, bytes, 0, bytes.length);
    }

    @Override
    public OutputStream getSendStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Writer getSendWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sendObject(Object o) throws IOException, EncodeException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sendStringByCompletion(String s, SendHandler sendHandler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<SendResult> sendStringByFuture(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<SendResult> sendBytesByFuture(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sendBytesByCompletion(ByteBuffer byteBuffer, SendHandler sendHandler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<SendResult> sendObjectByFuture(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sendObjectByCompletion(Object o, SendHandler sendHandler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sendPing(ByteBuffer byteBuffer) {
        this.socket.sendPing(byteBuffer.array());
    }

    @Override
    public void sendPong(ByteBuffer byteBuffer) {
        this.socket.sendPong(byteBuffer.array());
    }
}

