/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2013 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.glassfish.tyrus.websockets;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * TODO: Abstract class/builder?
 *
 * @author Pavel Bucek (pavel.bucek at oracle.com)
 */
public class WebSocketRequest {

    private String requestPath;

    private final Map<String, String> headers = new TreeMap<String, String>(new Comparator<String>() {
        @Override
        public int compare(String o1, String o2) {
            return o1.toLowerCase().compareTo(o2.toLowerCase());
        }
    });

    /**
     * @return TODO
     */
    public Map<String, String> getHeaders() {
        return headers;
    }

    /**
     * Returns the header values corresponding to the name.
     *
     * @param name header name.
     * @return {@link List} of header values iff found, {@code null} otherwise.
     */
    public String getHeader(String name) {
        return headers.get(name);
    }

    /**
     * Gets the first header value from the {@link List} of header values corresponding to the name.
     *
     * TODO - remove?
     *
     * @param name header name.
     * @return {@link String} value iff it exists, {@code null} otherwise.
     */
    public String getFirstHeaderValue(String name) {
        if (getHeader(name) != null) {
            return getHeader(name);
        }

        return null;
    }

    /**
     * @return TODO
     */
    public String getRequestPath() {
        return requestPath;
    }

    /**
     * @param requestPath TODO
     */
    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    /**
     * @return TODO
     */
    public String getRequestURI() {
        return null; // TODO
    }

    /**
     * @return TODO
     */
    public String getQueryString() {
        return null;  // TODO: Implement.
    }

    /**
     * @return TODO
     */
    public Connection getConnection() {
        return null;  // TODO: Implement.
    }

    /**
     * @return TODO
     */
    public boolean isSecure() {
        return false;  // TODO: Implement.
    }
}
