/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.websockets;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.concurrent.Future;
import org.glassfish.tyrus.websockets.Connection;
import org.glassfish.tyrus.websockets.DataFrame;
import org.glassfish.tyrus.websockets.FrameType;
import org.glassfish.tyrus.websockets.HandShake;
import org.glassfish.tyrus.websockets.StrictUtf8;
import org.glassfish.tyrus.websockets.Utf8DecodingError;
import org.glassfish.tyrus.websockets.Utf8Utils;
import org.glassfish.tyrus.websockets.WebSocket;
import org.glassfish.tyrus.websockets.WebSocketApplication;
import org.glassfish.tyrus.websockets.WebSocketEngine;
import org.glassfish.tyrus.websockets.WebSocketException;
import org.glassfish.tyrus.websockets.WebSocketRequest;
import org.glassfish.tyrus.websockets.draft06.ClosingFrame;
import org.glassfish.tyrus.websockets.frametypes.BinaryFrameType;
import org.glassfish.tyrus.websockets.frametypes.TextFrameType;

public abstract class ProtocolHandler {
    protected Connection connection;
    private WebSocket webSocket;
    protected byte inFragmentedType;
    protected byte outFragmentedType;
    protected final boolean maskData;
    protected boolean processingFragment;
    protected Charset utf8 = new StrictUtf8();
    protected CharsetDecoder currentDecoder = this.utf8.newDecoder();
    protected ByteBuffer remainder;

    public ProtocolHandler(boolean maskData) {
        this.maskData = maskData;
    }

    public HandShake handshake(Connection connection, WebSocketApplication app, WebSocketRequest request) {
        HandShake handshake = this.createHandShake(request);
        handshake.respond(connection, app);
        return handshake;
    }

    public final Future<DataFrame> send(DataFrame frame) {
        return this.send(frame, null);
    }

    public Future<DataFrame> send(DataFrame frame, Connection.CompletionHandler<DataFrame> completionHandler) {
        return this.write(frame, completionHandler);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection handler) {
        this.connection = handler;
    }

    public WebSocket getWebSocket() {
        return this.webSocket;
    }

    public void setWebSocket(WebSocket webSocket) {
        this.webSocket = webSocket;
    }

    public boolean isMaskData() {
        return this.maskData;
    }

    public abstract byte[] frame(DataFrame var1);

    public abstract HandShake createHandShake(WebSocketRequest var1);

    public abstract HandShake createHandShake(URI var1);

    public Future<DataFrame> send(byte[] data) {
        return this.send(new DataFrame((FrameType)new BinaryFrameType(), data));
    }

    public Future<DataFrame> send(String data) {
        return this.send(new DataFrame((FrameType)new TextFrameType(), data));
    }

    public Future<DataFrame> stream(boolean last, byte[] bytes, int off, int len) {
        return this.send(new DataFrame((FrameType)new BinaryFrameType(), bytes, last));
    }

    public Future<DataFrame> stream(boolean last, String fragment) {
        return this.send(new DataFrame((FrameType)new TextFrameType(), fragment, last));
    }

    public Future<DataFrame> close(int code, String reason) {
        return this.send(new ClosingFrame(code, reason), new Connection.CompletionHandler<DataFrame>(){

            @Override
            public void failed(Throwable throwable) {
                if (ProtocolHandler.this.webSocket != null) {
                    ProtocolHandler.this.webSocket.onClose(null);
                }
            }

            @Override
            public void completed(DataFrame result) {
                if (!ProtocolHandler.this.maskData && ProtocolHandler.this.webSocket != null) {
                    ProtocolHandler.this.webSocket.onClose(null);
                }
            }
        });
    }

    private Future<DataFrame> write(DataFrame frame, Connection.CompletionHandler<DataFrame> completionHandler) {
        Connection localConnection = this.connection;
        if (localConnection == null) {
            throw new IllegalStateException("Connection is null");
        }
        return localConnection.write(frame, completionHandler);
    }

    public DataFrame unframe(ByteBuffer buffer) {
        return this.parse(buffer);
    }

    public abstract DataFrame parse(ByteBuffer var1);

    public long decodeLength(byte[] bytes) {
        return WebSocketEngine.toLong(bytes, 0, bytes.length);
    }

    public byte[] encodeLength(long length) {
        byte[] lengthBytes;
        if (length <= 125L) {
            lengthBytes = new byte[]{(byte)length};
        } else {
            byte[] b = WebSocketEngine.toArray(length);
            if (length <= 65535L) {
                lengthBytes = new byte[3];
                lengthBytes[0] = 126;
                System.arraycopy(b, 6, lengthBytes, 1, 2);
            } else {
                lengthBytes = new byte[9];
                lengthBytes[0] = 127;
                System.arraycopy(b, 0, lengthBytes, 1, 8);
            }
        }
        return lengthBytes;
    }

    protected void validate(byte fragmentType, byte opcode) {
        if (fragmentType != 0 && opcode != fragmentType && !this.isControlFrame(opcode)) {
            throw new WebSocketException("Attempting to send a message while sending fragments of another");
        }
    }

    protected abstract boolean isControlFrame(byte var1);

    protected byte checkForLastFrame(DataFrame frame, byte opcode) {
        byte local = opcode;
        if (!frame.isLast()) {
            this.validate(this.outFragmentedType, local);
            if (this.outFragmentedType != 0) {
                local = 0;
            } else {
                this.outFragmentedType = local;
                local = (byte)(local & 0x7F);
            }
        } else if (this.outFragmentedType != 0) {
            local = -128;
            this.outFragmentedType = 0;
        } else {
            local = (byte)(local | 0x80);
        }
        return local;
    }

    public void doClose() {
        Connection localConnection = this.connection;
        if (localConnection == null) {
            throw new IllegalStateException("Connection is null");
        }
        localConnection.closeSilently();
    }

    protected void utf8Decode(boolean finalFragment, byte[] data, DataFrame dataFrame) {
        CharBuffer cb;
        block7: {
            ByteBuffer b = this.getByteBuffer(data);
            int n = (int)((float)b.remaining() * this.currentDecoder.averageCharsPerByte());
            cb = CharBuffer.allocate(n);
            while (true) {
                CoderResult result;
                if ((result = this.currentDecoder.decode(b, cb, finalFragment)).isUnderflow()) {
                    if (finalFragment) {
                        this.currentDecoder.flush(cb);
                        if (b.hasRemaining()) {
                            throw new IllegalStateException("Final UTF-8 fragment received, but not all bytes consumed by decode process");
                        }
                        this.currentDecoder.reset();
                    } else if (b.hasRemaining()) {
                        this.remainder = b;
                    }
                    break block7;
                }
                if (result.isOverflow()) {
                    CharBuffer tmp = CharBuffer.allocate(2 * n + 1);
                    cb.flip();
                    tmp.put(cb);
                    cb = tmp;
                    continue;
                }
                if (result.isError() || result.isMalformed()) break;
            }
            throw new Utf8DecodingError("Illegal UTF-8 Sequence");
        }
        cb.flip();
        String res = cb.toString();
        dataFrame.setPayload(res);
        dataFrame.setPayload(Utf8Utils.encode(new StrictUtf8(), res));
    }

    protected ByteBuffer getByteBuffer(byte[] data) {
        if (this.remainder == null) {
            return ByteBuffer.wrap(data);
        }
        int rem = this.remainder.remaining();
        byte[] orig = this.remainder.array();
        byte[] b = new byte[rem + data.length];
        System.arraycopy(orig, orig.length - rem, b, 0, rem);
        System.arraycopy(data, 0, b, rem, data.length);
        this.remainder = null;
        return ByteBuffer.wrap(b);
    }
}

