/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.websockets;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.tyrus.websockets.Connection;
import org.glassfish.tyrus.websockets.HandShake;
import org.glassfish.tyrus.websockets.HandshakeException;
import org.glassfish.tyrus.websockets.ProtocolHandler;
import org.glassfish.tyrus.websockets.Version;
import org.glassfish.tyrus.websockets.WebSocket;
import org.glassfish.tyrus.websockets.WebSocketApplication;
import org.glassfish.tyrus.websockets.WebSocketRequest;
import org.glassfish.tyrus.websockets.WebSocketResponse;
import org.glassfish.tyrus.websockets.draft06.ClosingFrame;

public class WebSocketEngine {
    public static final String SEC_WS_ACCEPT = "Sec-WebSocket-Accept";
    public static final String SEC_WS_KEY_HEADER = "Sec-WebSocket-Key";
    public static final String SEC_WS_ORIGIN_HEADER = "Sec-WebSocket-Origin";
    public static final String ORIGIN_HEADER = "Origin";
    public static final String SEC_WS_PROTOCOL_HEADER = "Sec-WebSocket-Protocol";
    public static final String SEC_WS_EXTENSIONS_HEADER = "Sec-WebSocket-Extensions";
    public static final String SEC_WS_VERSION = "Sec-WebSocket-Version";
    public static final String WEBSOCKET = "websocket";
    public static final String RESPONSE_CODE_MESSAGE = "Switching Protocols";
    public static final int RESPONSE_CODE_VALUE = 101;
    public static final String UPGRADE = "Upgrade";
    public static final String CONNECTION = "Connection";
    public static final String HOST = "Host";
    public static final Version DEFAULT_VERSION = Version.DRAFT17;
    private static final WebSocketEngine engine = new WebSocketEngine();
    private static final Logger LOGGER = Logger.getLogger("websocket");
    public static final String SERVER_KEY_HASH = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    public static final int MASK_SIZE = 4;
    private final List<WebSocketApplication> applications = new ArrayList<WebSocketApplication>();
    private final Map<Connection, WebSocketHolder> webSocketHolderMap = new TreeMap<Connection, WebSocketHolder>(new Comparator<Connection>(){

        @Override
        public int compare(Connection o1, Connection o2) {
            if (o1 == null || o2 == null) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                return -1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            return o1.hashCode() - o2.hashCode();
        }
    });

    private WebSocketEngine() {
    }

    public static synchronized WebSocketEngine getEngine() {
        return engine;
    }

    public static byte[] toArray(long length) {
        long value = length;
        byte[] b = new byte[8];
        for (int i = 7; i >= 0 && value > 0L; value >>= 8, --i) {
            b[i] = (byte)(value & 0xFFL);
        }
        return b;
    }

    public static long toLong(byte[] bytes, int start, int end) {
        long value = 0L;
        for (int i = start; i < end; ++i) {
            value <<= 8;
            value ^= (long)bytes[i] & 0xFFL;
        }
        return value;
    }

    public static List<String> toString(byte[] bytes) {
        return WebSocketEngine.toString(bytes, 0, bytes.length);
    }

    private static List<String> toString(byte[] bytes, int start, int end) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = start; i < end; ++i) {
            list.add(Integer.toHexString(bytes[i] & 0xFF).toUpperCase(Locale.US));
        }
        return list;
    }

    WebSocketApplication getApplication(WebSocketRequest request) {
        for (WebSocketApplication application : this.applications) {
            if (!application.upgrade(request)) continue;
            return application;
        }
        return null;
    }

    public boolean upgrade(Connection connection, WebSocketRequest request) throws IOException {
        return this.upgrade(connection, request, null);
    }

    public boolean upgrade(Connection connection, WebSocketRequest request, WebSocketHolderListener webSocketHolderListener) throws IOException {
        block6: {
            WebSocketApplication app = WebSocketEngine.getEngine().getApplication(request);
            WebSocket socket = null;
            try {
                if (app != null) {
                    ProtocolHandler protocolHandler = WebSocketEngine.loadHandler(request.getHeaders());
                    if (protocolHandler == null) {
                        WebSocketEngine.handleUnsupportedVersion(connection, request);
                        return false;
                    }
                    protocolHandler.setConnection(connection);
                    socket = app.createSocket(protocolHandler, request, app);
                    WebSocketHolder holder = WebSocketEngine.getEngine().setWebSocketHolder(connection, protocolHandler, socket);
                    holder.application = app;
                    protocolHandler.handshake(connection, app, request);
                    request.getConnection().addCloseListener(new Connection.CloseListener(){

                        @Override
                        public void onClose(Connection connection) throws IOException {
                            WebSocket webSocket = WebSocketEngine.this.getWebSocket(connection);
                            if (webSocket != null) {
                                webSocket.close();
                                webSocket.onClose(new ClosingFrame(1001, "Close detected on connection"));
                            }
                        }
                    });
                    if (webSocketHolderListener != null) {
                        webSocketHolderListener.onWebSocketHolder(holder);
                    } else {
                        socket.onConnect();
                    }
                    return true;
                }
            }
            catch (HandshakeException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                if (socket == null) break block6;
                socket.close();
            }
        }
        return false;
    }

    private static ProtocolHandler loadHandler(Map<String, String> headers) {
        for (Version version : Version.values()) {
            if (!version.validate(headers)) continue;
            return version.createHandler(false);
        }
        return null;
    }

    public void register(WebSocketApplication app) {
        this.applications.add(app);
    }

    public void unregister(WebSocketApplication app) {
        this.applications.remove(app);
    }

    public void unregisterAll() {
        this.applications.clear();
    }

    public boolean webSocketInProgress(Connection connection) {
        return this.webSocketHolderMap.get(connection) != null;
    }

    public WebSocket getWebSocket(Connection connection) {
        WebSocketHolder holder = this.getWebSocketHolder(connection);
        return holder == null ? null : holder.webSocket;
    }

    public WebSocketHolder getWebSocketHolder(Connection connection) {
        return this.webSocketHolderMap.get(connection);
    }

    public WebSocketHolder setWebSocketHolder(Connection connection, ProtocolHandler handler, WebSocket socket) {
        WebSocketHolder holder = new WebSocketHolder(handler, socket);
        this.webSocketHolderMap.put(connection, holder);
        return holder;
    }

    private static void handleUnsupportedVersion(Connection connection, WebSocketRequest request) {
        WebSocketResponse response = new WebSocketResponse();
        response.setStatus(400);
        response.getHeaders().put(SEC_WS_VERSION, Version.getSupportedWireProtocolVersions());
        connection.write(response);
    }

    public static final class WebSocketHolder {
        public volatile WebSocket webSocket;
        public volatile HandShake handshake;
        public volatile WebSocketApplication application;
        public volatile ByteBuffer buffer;
        public volatile ProtocolHandler handler;

        WebSocketHolder(ProtocolHandler handler, WebSocket socket) {
            this.handler = handler;
            this.webSocket = socket;
        }
    }

    public static abstract class WebSocketHolderListener {
        public abstract void onWebSocketHolder(WebSocketHolder var1) throws IOException;
    }
}

