/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.websockets.draft06;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.glassfish.tyrus.websockets.HandShake;
import org.glassfish.tyrus.websockets.HandshakeException;
import org.glassfish.tyrus.websockets.WebSocketRequest;
import org.glassfish.tyrus.websockets.WebSocketResponse;
import org.glassfish.tyrus.websockets.draft06.SecKey;

public class HandShake06
extends HandShake {
    private final SecKey secKey;
    private final List<String> enabledExtensions = Collections.emptyList();
    private final List<String> enabledProtocols = Collections.emptyList();

    public HandShake06(URI url) {
        super(url);
        this.secKey = new SecKey();
    }

    public HandShake06(WebSocketRequest request) {
        super(request);
        Map<String, String> headers = request.getHeaders();
        String value = headers.get("Sec-WebSocket-Extensions");
        if (value != null) {
            this.setExtensions(HandShake.fromHeaders(Arrays.asList(value)));
        }
        this.secKey = SecKey.generateServerKey(new SecKey(headers.get("Sec-WebSocket-Key")));
    }

    @Override
    public void setHeaders(WebSocketResponse response) {
        response.setReasonPhrase("Switching Protocols");
        response.getHeaders().put("Sec-WebSocket-Accept", this.secKey.getSecKey());
        if (!this.getEnabledExtensions().isEmpty()) {
            response.getHeaders().put("Sec-WebSocket-Extensions", this.getHeaderFromList(this.getSubProtocols()));
        }
    }

    @Override
    public WebSocketRequest getRequest() {
        WebSocketRequest webSocketRequest = super.getRequest();
        webSocketRequest.getHeaders().put("Sec-WebSocket-Key", this.secKey.toString());
        webSocketRequest.getHeaders().put("Sec-WebSocket-Origin", this.getOrigin());
        webSocketRequest.getHeaders().put("Sec-WebSocket-Version", this.getVersion() + "");
        if (!this.getExtensions().isEmpty()) {
            webSocketRequest.getHeaders().put("Sec-WebSocket-Extensions", this.getHeaderFromList(this.getExtensions()));
        }
        return webSocketRequest;
    }

    protected int getVersion() {
        return 6;
    }

    @Override
    public void validateServerResponse(WebSocketResponse response) throws HandshakeException {
        super.validateServerResponse(response);
        this.secKey.validateServerKey(response.getHeaders().get("Sec-WebSocket-Accept"));
    }

    List<String> getEnabledExtensions() {
        return this.enabledExtensions;
    }

    public List<String> getEnabledProtocols() {
        return this.enabledProtocols;
    }
}

