
package org.glassfish.tyrus.websockets.uri.internal;

import org.glassfish.tyrus.websockets.uri.internal.l10n.Localizable;
import org.glassfish.tyrus.websockets.uri.internal.l10n.LocalizableMessageFactory;
import org.glassfish.tyrus.websockets.uri.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.tyrus.websockets.uri.internal.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizablePROVIDER_COULD_NOT_BE_CREATED(Object arg0, Object arg1, Object arg2) {
        return messageFactory.getMessage("provider.could.not.be.created", arg0, arg1, arg2);
    }

    /**
     * The class {0} implementing provider {1} could not be instantiated: {2}
     * 
     */
    public static String PROVIDER_COULD_NOT_BE_CREATED(Object arg0, Object arg1, Object arg2) {
        return localizer.localize(localizablePROVIDER_COULD_NOT_BE_CREATED(arg0, arg1, arg2));
    }

    public static Localizable localizableILLEGAL_CONFIG_SYNTAX() {
        return messageFactory.getMessage("illegal.config.syntax");
    }

    /**
     * Illegal configuration-file syntax.
     * 
     */
    public static String ILLEGAL_CONFIG_SYNTAX() {
        return localizer.localize(localizableILLEGAL_CONFIG_SYNTAX());
    }

    public static Localizable localizableURI_COMPONENT_ENCODED_OCTET_INVALID_DIGIT(Object arg0, Object arg1) {
        return messageFactory.getMessage("uri.component.encoded.octet.invalid.digit", arg0, arg1);
    }

    /**
     * Malformed percent-encoded octet at index {0}, invalid hexadecimal digit ''{1}''.
     * 
     */
    public static String URI_COMPONENT_ENCODED_OCTET_INVALID_DIGIT(Object arg0, Object arg1) {
        return localizer.localize(localizableURI_COMPONENT_ENCODED_OCTET_INVALID_DIGIT(arg0, arg1));
    }

    public static Localizable localizableERROR_CAUGHT_WHILE_LOADING_SPI_PROVIDERS() {
        return messageFactory.getMessage("error.caught.while.loading.spi.providers");
    }

    /**
     * Error caught while loading SPI providers.
     * 
     */
    public static String ERROR_CAUGHT_WHILE_LOADING_SPI_PROVIDERS() {
        return localizer.localize(localizableERROR_CAUGHT_WHILE_LOADING_SPI_PROVIDERS());
    }

    public static Localizable localizableILLEGAL_PROVIDER_CLASS_NAME(Object arg0) {
        return messageFactory.getMessage("illegal.provider.class.name", arg0);
    }

    /**
     * Illegal provider-class name: {0}.
     * 
     */
    public static String ILLEGAL_PROVIDER_CLASS_NAME(Object arg0) {
        return localizer.localize(localizableILLEGAL_PROVIDER_CLASS_NAME(arg0));
    }

    public static Localizable localizableDEPENDENT_CLASS_OF_PROVIDER_FORMAT_ERROR(Object arg0, Object arg1, Object arg2) {
        return messageFactory.getMessage("dependent.class.of.provider.format.error", arg0, arg1, arg2);
    }

    /**
     * {0}. A dependent class of the class {1} implementing the provider {2} is malformed. The provider implementation is ignored. Check if the malformed class is part of a stubbed jar that used for compiling only.
     * 
     */
    public static String DEPENDENT_CLASS_OF_PROVIDER_FORMAT_ERROR(Object arg0, Object arg1, Object arg2) {
        return localizer.localize(localizableDEPENDENT_CLASS_OF_PROVIDER_FORMAT_ERROR(arg0, arg1, arg2));
    }

    public static Localizable localizableDEPENDENT_CLASS_OF_PROVIDER_NOT_FOUND(Object arg0, Object arg1, Object arg2) {
        return messageFactory.getMessage("dependent.class.of.provider.not.found", arg0, arg1, arg2);
    }

    /**
     * A dependent class, {0}, of the class {1} implementing the provider {2} is not found. The provider implementation is ignored.
     * 
     */
    public static String DEPENDENT_CLASS_OF_PROVIDER_NOT_FOUND(Object arg0, Object arg1, Object arg2) {
        return localizer.localize(localizableDEPENDENT_CLASS_OF_PROVIDER_NOT_FOUND(arg0, arg1, arg2));
    }

    public static Localizable localizablePROVIDER_NOT_FOUND(Object arg0, Object arg1) {
        return messageFactory.getMessage("provider.not.found", arg0, arg1);
    }

    /**
     * The class {0} implementing the provider {1} is not found. The provider implementation is ignored.
     * 
     */
    public static String PROVIDER_NOT_FOUND(Object arg0, Object arg1) {
        return localizer.localize(localizablePROVIDER_NOT_FOUND(arg0, arg1));
    }

    public static Localizable localizableURI_COMPONENT_ENCODED_OCTET_MALFORMED(Object arg0) {
        return messageFactory.getMessage("uri.component.encoded.octet.malformed", arg0);
    }

    /**
     * Malformed percent-encoded octet at index {0}.
     * 
     */
    public static String URI_COMPONENT_ENCODED_OCTET_MALFORMED(Object arg0) {
        return localizer.localize(localizableURI_COMPONENT_ENCODED_OCTET_MALFORMED(arg0));
    }

    public static Localizable localizableEXCEPTION_CAUGHT_WHILE_LOADING_SPI_PROVIDERS() {
        return messageFactory.getMessage("exception.caught.while.loading.spi.providers");
    }

    /**
     * Exception caught while loading SPI providers.
     * 
     */
    public static String EXCEPTION_CAUGHT_WHILE_LOADING_SPI_PROVIDERS() {
        return localizer.localize(localizableEXCEPTION_CAUGHT_WHILE_LOADING_SPI_PROVIDERS());
    }

    public static Localizable localizableURI_COMPONENT_INVALID_CHARACTER(Object arg0, Object arg1, Object arg2, Object arg3) {
        return messageFactory.getMessage("uri.component.invalid.character", arg0, arg1, arg2, arg3);
    }

    /**
     * The string "{0}" for the URI component {1} contains an invalid character, ''{2}'', at index {3}.
     * 
     */
    public static String URI_COMPONENT_INVALID_CHARACTER(Object arg0, Object arg1, Object arg2, Object arg3) {
        return localizer.localize(localizableURI_COMPONENT_INVALID_CHARACTER(arg0, arg1, arg2, arg3));
    }

    public static Localizable localizablePROVIDER_CLASS_COULD_NOT_BE_LOADED(Object arg0, Object arg1, Object arg2) {
        return messageFactory.getMessage("provider.class.could.not.be.loaded", arg0, arg1, arg2);
    }

    /**
     * The class {0} implementing provider {1} could not be loaded: {2}
     * 
     */
    public static String PROVIDER_CLASS_COULD_NOT_BE_LOADED(Object arg0, Object arg1, Object arg2) {
        return localizer.localize(localizablePROVIDER_CLASS_COULD_NOT_BE_LOADED(arg0, arg1, arg2));
    }

}
