/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.tyrus.client.ClientSocket;
import org.glassfish.tyrus.client.GrizzlyWebSocket;
import org.glassfish.tyrus.platform.Model;
import org.glassfish.tyrus.platform.ServerContainerImpl;
import org.glassfish.tyrus.platform.WebSocketEndpointImpl;
import org.glassfish.tyrus.spi.SPIEndpoint;

public class WebSocketClient {
    private Set<GrizzlyWebSocket> sockets = new HashSet<GrizzlyWebSocket>();

    public static WebSocketClient createClient() {
        return new WebSocketClient();
    }

    public ClientSocket openSocket(String url, long timeoutMs, Object ... endpoints) {
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        GrizzlyWebSocket gws = new GrizzlyWebSocket(uri, timeoutMs);
        for (Object endpoint : endpoints) {
            if (endpoint instanceof SPIEndpoint) {
                gws.addEndpoint((SPIEndpoint)endpoint);
                continue;
            }
            ServerContainerImpl cci = new ServerContainerImpl(null, uri.getPath(), uri.getPort());
            Model model = null;
            try {
                model = new Model(endpoint);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            WebSocketEndpointImpl clientEndpoint = new WebSocketEndpointImpl(cci, null, model, Boolean.valueOf(false));
            gws.addEndpoint((SPIEndpoint)clientEndpoint);
        }
        gws.connect();
        this.sockets.add(gws);
        return gws;
    }
}

