/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.websocket.RemoteEndpoint;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.grizzly.websockets.WebSocketFilter;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.glassfish.grizzly.websockets.draft06.ClosingFrame;
import org.glassfish.tyrus.client.ClientSocket;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.grizzlyprovider.GrizzlyRemoteEndpoint;

class GrizzlyWebSocket
implements WebSocket,
ClientSocket {
    private URI uri;
    private ProtocolHandler protocolHandler;
    private Set<SPIEndpoint> endpoints = Collections.newSetFromMap(new ConcurrentHashMap());
    private TCPNIOTransport transport;
    EnumSet<State> connected = EnumSet.range(State.CONNECTED, State.CLOSING);
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);
    private GrizzlyRemoteEndpoint remoteEndpoint;
    private long timeoutMs;

    public GrizzlyWebSocket(URI uri, long timeoutMs, SPIEndpoint ... endpoints) {
        this(uri, timeoutMs);
        for (SPIEndpoint endpoint : endpoints) {
            this.addEndpoint(endpoint);
        }
    }

    GrizzlyWebSocket(URI uri, long timeoutMs) {
        this.uri = uri;
        this.protocolHandler = WebSocketEngine.DEFAULT_VERSION.createHandler(true);
        this.remoteEndpoint = new GrizzlyRemoteEndpoint((WebSocket)this);
        this.timeoutMs = timeoutMs;
    }

    public void connect() {
        try {
            this.transport = TCPNIOTransportBuilder.newInstance().build();
            this.transport.start();
            TCPNIOConnectorHandler connectorHandler = new TCPNIOConnectorHandler(this.transport){

                protected void preConfigure(Connection conn) {
                    super.preConfigure(conn);
                    GrizzlyWebSocket.this.protocolHandler.setConnection(conn);
                    WebSocketEngine.WebSocketHolder holder = WebSocketEngine.getEngine().setWebSocketHolder(conn, GrizzlyWebSocket.this.protocolHandler, (WebSocket)GrizzlyWebSocket.this);
                    holder.handshake = GrizzlyWebSocket.this.protocolHandler.createHandShake(GrizzlyWebSocket.this.uri);
                }
            };
            connectorHandler.setProcessor(GrizzlyWebSocket.createFilterChain());
            connectorHandler.connect((SocketAddress)new InetSocketAddress(this.uri.getHost(), this.uri.getPort()));
            connectorHandler.setSyncConnectTimeout(this.timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HandshakeException(e.getMessage());
        }
    }

    public void addEndpoint(SPIEndpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    public GrizzlyFuture<DataFrame> send(String s) {
        if (this.isConnected()) {
            return this.protocolHandler.send(s);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public GrizzlyFuture<DataFrame> send(byte[] bytes) {
        if (this.isConnected()) {
            return this.protocolHandler.send(bytes);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public GrizzlyFuture<DataFrame> sendPing(byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    public GrizzlyFuture<DataFrame> sendPong(byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    public GrizzlyFuture<DataFrame> stream(boolean b, String s) {
        throw new UnsupportedOperationException();
    }

    public GrizzlyFuture<DataFrame> stream(boolean b, byte[] bytes, int i, int i1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.close(100000, "Closing");
    }

    public void close(int i) {
        this.close(i, null);
    }

    public void close(int i, String s) {
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            this.protocolHandler.doClose();
            if (this.transport != null) {
                try {
                    this.transport.stop();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean isConnected() {
        return this.connected.contains((Object)this.state.get());
    }

    public void onConnect() {
        this.state.set(State.CONNECTED);
        for (SPIEndpoint endpoint : this.endpoints) {
            endpoint.onConnect((RemoteEndpoint)this.remoteEndpoint);
        }
    }

    public void onMessage(String message) {
        for (SPIEndpoint endpoint : this.endpoints) {
            endpoint.onMessage((RemoteEndpoint)this.remoteEndpoint, message);
        }
    }

    public void onMessage(byte[] bytes) {
        for (SPIEndpoint endpoint : this.endpoints) {
            endpoint.onMessage((RemoteEndpoint)this.remoteEndpoint, ByteBuffer.wrap(bytes));
        }
    }

    public void onFragment(boolean b, String s) {
        throw new UnsupportedOperationException();
    }

    public void onFragment(boolean b, byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    public void onClose(DataFrame dataFrame) {
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            ClosingFrame closing = (ClosingFrame)dataFrame;
            this.protocolHandler.close(closing.getCode(), closing.getTextPayload());
        } else {
            this.state.set(State.CLOSED);
            this.protocolHandler.doClose();
        }
        for (SPIEndpoint endpoint : this.endpoints) {
            endpoint.onClose((RemoteEndpoint)this.remoteEndpoint);
        }
    }

    public void onPing(DataFrame dataFrame) {
        throw new UnsupportedOperationException();
    }

    public void onPong(DataFrame dataFrame) {
        throw new UnsupportedOperationException();
    }

    public boolean add(WebSocketListener webSocketListener) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(WebSocketListener webSocketListener) {
        throw new UnsupportedOperationException();
    }

    private static Processor createFilterChain() {
        FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
        clientFilterChainBuilder.add((Filter)new TransportFilter());
        clientFilterChainBuilder.add((Filter)new HttpClientFilter());
        clientFilterChainBuilder.add((Filter)new WebSocketFilter());
        return clientFilterChainBuilder.build();
    }

    @Override
    public Set<SPIEndpoint> getEndpoints() {
        return new HashSet<SPIEndpoint>(this.endpoints);
    }

    static enum State {
        NEW,
        CONNECTED,
        CLOSING,
        CLOSED;

    }
}

