/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.platform;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.websocket.DecodeException;
import javax.net.websocket.Decoder;
import javax.net.websocket.EncodeException;
import javax.net.websocket.Encoder;
import javax.net.websocket.RemoteEndpoint;
import javax.net.websocket.ServerContainer;
import javax.net.websocket.annotations.WebSocketMessage;
import org.glassfish.tyrus.platform.Model;
import org.glassfish.tyrus.platform.RemoteEndpointWrapper;
import org.glassfish.tyrus.platform.ServerContainerImpl;
import org.glassfish.tyrus.platform.decoders.BooleanDecoder;
import org.glassfish.tyrus.platform.decoders.CharDecoder;
import org.glassfish.tyrus.platform.decoders.DoubleDecoder;
import org.glassfish.tyrus.platform.decoders.FloatDecoder;
import org.glassfish.tyrus.platform.decoders.IntegerDecoder;
import org.glassfish.tyrus.platform.decoders.LongDecoder;
import org.glassfish.tyrus.platform.decoders.ShortDecoder;
import org.glassfish.tyrus.platform.decoders.StringDecoderNoOp;
import org.glassfish.tyrus.platform.encoders.BooleanEncoder;
import org.glassfish.tyrus.platform.encoders.ByteEncoder;
import org.glassfish.tyrus.platform.encoders.CharEncoder;
import org.glassfish.tyrus.platform.encoders.DoubleEncoder;
import org.glassfish.tyrus.platform.encoders.FloatEncoder;
import org.glassfish.tyrus.platform.encoders.IntEncoder;
import org.glassfish.tyrus.platform.encoders.LongEncoder;
import org.glassfish.tyrus.platform.encoders.ShortEncoder;
import org.glassfish.tyrus.platform.encoders.StringEncoderNoOp;
import org.glassfish.tyrus.platform.utils.PrimitivesToBoxing;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIHandshakeRequest;
import org.glassfish.tyrus.spi.SPIRemoteEndpoint;

public class WebSocketEndpointImpl
implements SPIEndpoint {
    private final String path;
    private Set<Class<?>> decoders = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<Class<?>> encoders = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean server = true;
    private Model model;
    private ServerContainer containerContext;

    public WebSocketEndpointImpl(ServerContainer containerContext, String path, Model model) {
        this.containerContext = containerContext;
        this.path = path;
        this.model = model;
        this.init(model.getEncoders(), model.getDecoders());
    }

    public WebSocketEndpointImpl(ServerContainerImpl containerContext, String path, Model model, Boolean server) {
        this(containerContext, path, model);
        this.server = server;
    }

    private void init(Set<Class<?>> encodersToInit, Set<Class<?>> decodersToInit) {
        this.initDecoders(decodersToInit);
        this.initEncoders(encodersToInit);
    }

    protected boolean doesPathMatch(String remoteUri, String dynamicPath) {
        if (dynamicPath.equals("*")) {
            return true;
        }
        return (this.path + dynamicPath).equals(remoteUri);
    }

    private void initEncoders(Set<Class<?>> encodersToInit) {
        this.encoders.addAll(encodersToInit);
        this.encoders.add(StringEncoderNoOp.class);
        this.encoders.add(BooleanEncoder.class);
        this.encoders.add(ByteEncoder.class);
        this.encoders.add(CharEncoder.class);
        this.encoders.add(DoubleEncoder.class);
        this.encoders.add(FloatEncoder.class);
        this.encoders.add(IntEncoder.class);
        this.encoders.add(LongEncoder.class);
        this.encoders.add(ShortEncoder.class);
    }

    private void initDecoders(Set<Class<?>> decodersToInit) {
        this.decoders.addAll(decodersToInit);
        this.decoders.add(StringDecoderNoOp.class);
        this.decoders.add(BooleanDecoder.class);
        this.decoders.add(IntegerDecoder.class);
        this.decoders.add(LongDecoder.class);
        this.decoders.add(ShortDecoder.class);
        this.decoders.add(FloatDecoder.class);
        this.decoders.add(DoubleDecoder.class);
        this.decoders.add(CharDecoder.class);
    }

    public static String getClassTypeForTypeThatMightBePrimitive(String possiblyPrimitiveType) {
        String type = possiblyPrimitiveType;
        if (possiblyPrimitiveType.equals("boolean")) {
            type = "java.lang.Boolean";
        } else if (possiblyPrimitiveType.equals("char")) {
            type = "java.lang.Character";
        } else if (possiblyPrimitiveType.equals("double")) {
            type = "java.lang.Double";
        } else if (possiblyPrimitiveType.equals("float")) {
            type = "java.lang.Float";
        } else if (possiblyPrimitiveType.equals("int")) {
            type = "java.lang.Integer";
        } else if (possiblyPrimitiveType.equals("long")) {
            type = "java.lang.Long";
        } else if (possiblyPrimitiveType.equals("short")) {
            type = "java.lang.Short";
        }
        return type;
    }

    private Object doDecode(String message, String possiblyPrimitiveType) throws DecodeException {
        String type = WebSocketEndpointImpl.getClassTypeForTypeThatMightBePrimitive(possiblyPrimitiveType);
        for (Class<?> next : this.decoders) {
            Class<?> nextClass = next;
            List<Class<?>> interfaces = Arrays.asList(nextClass.getInterfaces());
            if (!interfaces.contains(Decoder.Text.class)) continue;
            try {
                Decoder.Text decoder;
                boolean willItDecode;
                Method m = nextClass.getDeclaredMethod("decode", String.class);
                Class<?> returnC = m.getReturnType();
                ClassLoader cl = nextClass.getClassLoader();
                Class<?> proposedType = cl.loadClass(type);
                if (!proposedType.equals(returnC) || !(willItDecode = (decoder = (Decoder.Text)nextClass.newInstance()).willDecode(message))) continue;
                return decoder.decode(message);
            }
            catch (DecodeException de) {
                de.printStackTrace();
                throw de;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    String doEncode(Object o) throws EncodeException {
        for (Class<?> next : this.encoders) {
            Class<?> nextClass = next;
            List<Class<?>> interfaces = Arrays.asList(nextClass.getInterfaces());
            if (!interfaces.contains(Encoder.Text.class)) continue;
            try {
                Method m = nextClass.getMethod("encode", o.getClass());
                if (m == null) continue;
                Encoder.Text te = (Encoder.Text)nextClass.newInstance();
                return te.encode(o);
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (EncodeException ee) {
                ee.printStackTrace();
                throw ee;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new EncodeException("Unable to encode ", o);
    }

    String getPath() {
        return this.path;
    }

    public boolean checkHandshake(SPIHandshakeRequest hr) {
        return hr.getRequestURI().startsWith(this.path);
    }

    public List<String> getSupportedProtocols(List<String> subProtocol) {
        ArrayList<String> supported = new ArrayList<String>();
        for (String nextRequestedProtocolName : subProtocol) {
            if (!this.model.getSubprotocols().contains(nextRequestedProtocolName)) continue;
            supported.add(nextRequestedProtocolName);
        }
        return supported;
    }

    public void remove() {
    }

    public void onConnect(SPIRemoteEndpoint gs) {
        RemoteEndpointWrapper peer = this.getPeer(gs);
        peer.setAddress(gs.getUri());
        this.onGeneratedBeanConnect(peer);
    }

    public void onMessage(SPIRemoteEndpoint gs, byte[] messageBytes) {
        this.processMessage(gs, messageBytes);
    }

    public void onMessage(SPIRemoteEndpoint gs, String messageString) {
        this.processMessage(gs, messageString);
    }

    private void processMessage(SPIRemoteEndpoint gs, Object o) {
        RemoteEndpointWrapper peer = this.getPeer(gs);
        for (Method m : this.model.getOnMessageMethods()) {
            try {
                Class<?>[] paramTypes = m.getParameterTypes();
                if (paramTypes[0].equals(byte[].class) && o instanceof String) continue;
                WebSocketMessage wsm = m.getAnnotation(WebSocketMessage.class);
                Object decodedMessageObject = o;
                if (o instanceof String) {
                    decodedMessageObject = this.doDecode((String)o, paramTypes[0].getName());
                }
                if (decodedMessageObject != null) {
                    Object returned = this.invokeMethod(decodedMessageObject, m, peer);
                    if (returned == null) continue;
                    if (o instanceof String) {
                        String messageToSendAsString = this.doEncode(returned);
                        peer.sendString(messageToSendAsString);
                        continue;
                    }
                    if (!(returned instanceof byte[])) continue;
                    peer.sendBytes((byte[])returned);
                    continue;
                }
                throw new DecodeException();
            }
            catch (IOException ioe) {
                this.handleGeneratedBeanException(peer, ioe);
            }
            catch (DecodeException de) {
                this.handleGeneratedBeanException(peer, (Exception)((Object)de));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException("Error invoking " + m);
            }
        }
    }

    private Object invokeMethod(Object decodedMessageObject, Method method, RemoteEndpointWrapper peer) throws Exception {
        Object result;
        Object param2;
        Object param1;
        int noOfParameters = method.getParameterTypes().length;
        Class<?>[] paramTypes = method.getParameterTypes();
        Object param0 = this.model.getBean();
        if (paramTypes[0].equals(decodedMessageObject.getClass()) || PrimitivesToBoxing.getBoxing(paramTypes[0]).equals(decodedMessageObject.getClass())) {
            param1 = decodedMessageObject;
            param2 = peer.getSession();
        } else {
            param1 = peer.getSession();
            param2 = decodedMessageObject;
        }
        switch (noOfParameters) {
            case 1: {
                result = method.invoke(param0, param1);
                break;
            }
            case 2: {
                result = method.invoke(param0, param1, param2);
                break;
            }
            default: {
                throw new RuntimeException("can't deal with " + noOfParameters + " parameters.");
            }
        }
        return result;
    }

    public void onClose(SPIRemoteEndpoint gs) {
        RemoteEndpointWrapper wsw = this.getPeer(gs);
        this.onGeneratedBeanClose(wsw);
        wsw.discard();
    }

    public void handleGeneratedBeanException(RemoteEndpoint peer, Exception e) {
        throw new RuntimeException("Error handling not supported yet.");
    }

    public void onGeneratedBeanConnect(RemoteEndpointWrapper peer) {
        for (Method m : this.model.getOnOpenMethods()) {
            try {
                m.invoke(this.model.getBean(), peer.getSession());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Error invoking it.");
            }
        }
    }

    public void onGeneratedBeanClose(RemoteEndpointWrapper peer) {
        for (Method m : this.model.getOnCloseMethods()) {
            try {
                m.invoke(this.model.getBean(), peer.getSession());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Error invoking it.");
            }
        }
    }

    protected final RemoteEndpointWrapper getPeer(SPIRemoteEndpoint gs) {
        return RemoteEndpointWrapper.getRemoteWrapper(gs, this, this.server);
    }

    public ServerContainer getContainerContext() {
        return this.containerContext;
    }
}

