/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.platform;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.websocket.CloseReason;
import javax.net.websocket.Encoder;
import javax.net.websocket.MessageHandler;
import javax.net.websocket.RemoteEndpoint;
import javax.net.websocket.Session;
import javax.net.websocket.extensions.Extension;
import javax.servlet.http.HttpSession;
import org.glassfish.tyrus.platform.RemoteEndpointWrapper;

public class SessionImpl
implements Session {
    private Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final long id;
    private RemoteEndpointWrapper peer;
    private HttpSession httpSession;
    private CloseReason closeReason = null;
    private long timeout = 60000000L;
    private long maximumMessageSize = 8192L;
    private Set<MessageHandler> messageHandlers = new HashSet<MessageHandler>();
    private Set<Encoder> encoders = new HashSet<Encoder>();
    private static final AtomicLong count = new AtomicLong();

    SessionImpl() {
        this.id = count.getAndIncrement();
    }

    public String getProtocolVersion() {
        return "13";
    }

    void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public HttpSession getSession() {
        return this.httpSession;
    }

    public String getNegotiatedSubprotocol() {
        return "not implemented";
    }

    public RemoteEndpoint getRemote() {
        return this.peer;
    }

    public RemoteEndpoint getRemote(Class c) {
        return this.peer;
    }

    public Long getId() {
        return count.get();
    }

    public boolean isActive() {
        return this.peer.isConnected();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void close() throws IOException {
        this.close(new CloseReason(CloseReason.Code.NORMAL_CLOSURE, "no reason given"));
    }

    public void close(CloseReason closeReason) throws IOException {
        this.closeReason = closeReason;
        this.peer.close(closeReason);
    }

    public String toString() {
        return "Session(" + this.id + ", " + this.isActive() + ")";
    }

    void setPeer(RemoteEndpointWrapper peer) {
        this.peer = peer;
    }

    public CloseReason getCloseStatus() {
        return this.closeReason;
    }

    public void setTimeout(long seconds) {
        this.timeout = seconds;
    }

    public void setMaximumMessageSize(long maximumMessageSize) {
        this.maximumMessageSize = maximumMessageSize;
    }

    public long getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    public List<Extension> getNegotiatedExtensions() {
        throw new UnsupportedOperationException();
    }

    public boolean isSecure() {
        throw new UnsupportedOperationException();
    }

    public long getInactiveTime() {
        throw new UnsupportedOperationException();
    }

    public void addEncoder(Encoder encoder) {
        this.encoders.add(encoder);
    }

    public void addMessageHandler(MessageHandler listener) {
        this.messageHandlers.add(listener);
    }

    public Set getMessageHandlers() {
        return Collections.unmodifiableSet(this.messageHandlers);
    }

    public void removeMessageHandler(MessageHandler listener) {
        this.messageHandlers.remove(listener);
    }

    public URI getRequestURI() {
        return URI.create(this.peer.getAddress());
    }

    void notifyMessageHandlers(String message) {
        for (MessageHandler mh : this.messageHandlers) {
            if (mh instanceof MessageHandler.Text) {
                ((MessageHandler.Text)mh).onMessage(message);
                continue;
            }
            throw new UnsupportedOperationException("don't handle types other than MessageHandler.Text so far.");
        }
    }

    void notifyMessageHandlers(byte[] message) {
        for (MessageHandler mh : this.messageHandlers) {
            if (mh instanceof MessageHandler.Binary) {
                ((MessageHandler.Binary)mh).onMessage(message);
                continue;
            }
            throw new UnsupportedOperationException("don't handle types other than MessageHandler.Text so far.");
        }
    }
}

