/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.platform.main;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.websockets.WebSocketAddOn;
import org.glassfish.tyrus.platform.BeanServer;
import org.glassfish.tyrus.platform.ServerContainerImpl;

public class Server {
    private HttpServer server;
    private BeanServer beanServer;
    private final Set<Class<?>> beans;
    private final String hostName;
    private final int port;
    private final String rootPath;
    private static final String ENGINE_PROVIDER_CLASSNAME = "org.glassfish.tyrus.spi.grizzlyprovider.GrizzlyEngine";
    private static final Logger LOGGER = Logger.getLogger(Server.class.getClass().getName());
    private static final int DEFAULT_PORT = 8025;
    private static final String DEFAULT_HOST_NAME = "localhost";
    private static final String DEFAULT_ROOT_PATH = "/websockets/tests";

    public Server(Class<?> ... beans) {
        this(null, 0, null, beans);
    }

    public Server(String ... beanNames) {
        this(null, 0, null, new HashSet());
        for (String beanName : beanNames) {
            try {
                this.beans.add(Class.forName(beanName));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Server(String hostName, int port, String rootPath, Class<?> ... beans) {
        this(hostName, port, rootPath, new HashSet(Arrays.asList(beans)));
    }

    public Server(String hostName, int port, String rootPath, Set<Class<?>> beans) {
        this.hostName = hostName == null ? DEFAULT_HOST_NAME : hostName;
        this.port = port == 0 ? 8025 : port;
        this.rootPath = rootPath == null ? DEFAULT_ROOT_PATH : rootPath;
        this.beans = beans;
    }

    public static void setWebMode(boolean b) {
        ServerContainerImpl.setWebMode(b);
    }

    public synchronized void start() {
        block4: {
            try {
                if (this.server != null) break block4;
                this.server = HttpServer.createSimpleServer((String)this.rootPath, (int)this.port);
                this.server.getListener("grizzly").registerAddOn((AddOn)new WebSocketAddOn());
                this.server.start();
                this.beanServer = new BeanServer(ENGINE_PROVIDER_CLASSNAME);
                try {
                    this.beanServer.initWebSocketServer(this.rootPath, this.port, this.beans);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                LOGGER.info("WebSocket Registered apps: URLs all start with ws://" + this.hostName + ":" + this.port);
                LOGGER.info("WebSocket server started.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void stop() {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
            this.beanServer = null;
            LOGGER.info("Websocket Server stopped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Please provide: (<hostname>, <port>, <websockets root path>, <;-sep fully qualfied classnames of your bean>) in the command line");
            System.out.println("e.g. localhost 8021 /websockets/myapp myapp.Bean1;myapp.Bean2");
            System.exit(1);
        }
        Set<Class<?>> beanClasses = Server.getClassesFromString(args[3]);
        int port = Integer.parseInt(args[1]);
        String hostname = args[0];
        String wsroot = args[2];
        Server server = new Server(hostname, port, wsroot, beanClasses);
        try {
            server.start();
            System.out.println("Press any key to stop the WebSocket server...");
            System.in.read();
        }
        catch (IOException ioe) {
            System.err.println("IOException during server run");
            ioe.printStackTrace();
        }
        finally {
            server.stop();
        }
    }

    private static Set<Class<?>> getClassesFromString(String rawString) {
        HashSet beanClasses = new HashSet();
        StringTokenizer st = new StringTokenizer(rawString, ";");
        while (st.hasMoreTokens()) {
            String nextClassname = st.nextToken().trim();
            if ("".equals(nextClassname)) continue;
            try {
                beanClasses.add(Class.forName(nextClassname));
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Stop: cannot load class: " + nextClassname);
            }
        }
        return beanClasses;
    }
}

