/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.platform;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.net.websocket.CloseReason;
import javax.net.websocket.EncodeException;
import javax.net.websocket.RemoteEndpoint;
import javax.net.websocket.SendHandler;
import javax.net.websocket.SendResult;
import javax.net.websocket.Session;
import org.glassfish.tyrus.platform.EndpointWrapper;
import org.glassfish.tyrus.platform.SessionImpl;

public final class RemoteEndpointWrapper<T>
implements RemoteEndpoint<T> {
    private final RemoteEndpoint providedRemoteEndpoint;
    private final SessionImpl webSocketSession;
    private final EndpointWrapper correspondingEndpoint;
    private String connectedToAddress;

    public static RemoteEndpointWrapper getRemoteWrapper(RemoteEndpoint socket, EndpointWrapper application) {
        return new RemoteEndpointWrapper(socket, application);
    }

    private RemoteEndpointWrapper(RemoteEndpoint providedRemoteEndpoint, EndpointWrapper correspondingEndpoint) {
        this.providedRemoteEndpoint = providedRemoteEndpoint;
        this.correspondingEndpoint = correspondingEndpoint;
        this.webSocketSession = new SessionImpl();
        this.webSocketSession.setPeer(this);
    }

    public String getAddress() {
        return this.connectedToAddress;
    }

    public boolean isConnected() {
        return true;
    }

    @Override
    public void sendString(String data) throws IOException {
        this.providedRemoteEndpoint.sendString(data);
        this.webSocketSession.updateLastConnectionActivity();
    }

    @Override
    public void sendBytes(ByteBuffer data) throws IOException {
        this.providedRemoteEndpoint.sendBytes(data);
        this.webSocketSession.updateLastConnectionActivity();
    }

    @Override
    public void sendPartialString(String fragment, boolean isLast) throws IOException {
        this.webSocketSession.updateLastConnectionActivity();
    }

    @Override
    public void sendPartialBytes(ByteBuffer byteBuffer, boolean isLast) throws IOException {
        this.webSocketSession.updateLastConnectionActivity();
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public OutputStream getSendStream() throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Writer getSendWriter() throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void sendObject(T o) throws IOException, EncodeException {
        this.webSocketSession.updateLastConnectionActivity();
        this.sendPolymorphic(o);
    }

    @Override
    public Future<SendResult> sendString(String text, SendHandler completion) {
        this.webSocketSession.updateLastConnectionActivity();
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Future<SendResult> sendBytes(ByteBuffer data, SendHandler completion) {
        this.webSocketSession.updateLastConnectionActivity();
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Future<SendResult> sendObject(T o, SendHandler handler) {
        this.webSocketSession.updateLastConnectionActivity();
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void sendPing(ByteBuffer applicationData) {
        this.webSocketSession.updateLastConnectionActivity();
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void sendPong(ByteBuffer applicationData) {
        this.webSocketSession.updateLastConnectionActivity();
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String toString() {
        return "Wrapped: " + this.getClass().getSimpleName();
    }

    void setAddress(String clientAddress) {
        this.connectedToAddress = clientAddress;
    }

    private void sendPrimitiveMessage(Object data) throws IOException, EncodeException {
        if (!this.isPrimitiveData(data)) {
            throw new EncodeException("object " + data + " is not a primitive type.", data);
        }
        this.sendString(data.toString());
    }

    private void sendPolymorphic(Object o) throws IOException, EncodeException {
        if (o instanceof String) {
            this.sendString((String)o);
        } else if (this.isPrimitiveData(o)) {
            this.sendPrimitiveMessage(o);
        } else {
            String stringToSend = this.correspondingEndpoint.doEncode(o);
            this.sendString(stringToSend);
        }
    }

    private boolean isPrimitiveData(Object data) {
        Class<?> dataClass = data.getClass();
        return dataClass.equals(Integer.class) || dataClass.equals(Byte.class) || dataClass.equals(Short.class) || dataClass.equals(Long.class) || dataClass.equals(Float.class) || dataClass.equals(Double.class) || dataClass.equals(Boolean.class) || dataClass.equals(Character.class);
    }

    public void close(CloseReason cr) throws IOException {
        System.out.println("Close  public void close(CloseReason cr)");
    }

    public Session getSession() {
        return this.webSocketSession;
    }

    public void updateLastConnectionActivity() {
        this.webSocketSession.updateLastConnectionActivity();
    }
}

