/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.platform;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.websocket.ClientContainer;
import javax.net.websocket.CloseReason;
import javax.net.websocket.Encoder;
import javax.net.websocket.MessageHandler;
import javax.net.websocket.RemoteEndpoint;
import javax.net.websocket.Session;
import javax.net.websocket.extensions.Extension;
import org.glassfish.tyrus.platform.RemoteEndpointWrapper;

public class SessionImpl<T>
implements Session<T> {
    private Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final long id;
    private RemoteEndpointWrapper peer;
    private CloseReason closeReason = null;
    private long timeout;
    private long maximumMessageSize = 8192L;
    private Set<MessageHandler> messageHandlers = new HashSet<MessageHandler>();
    private Set<Encoder> encoders = new HashSet<Encoder>();
    private static final AtomicLong count = new AtomicLong();
    private String negotiatedSubprotocol;
    private List<Extension> negotiatedExtensions;
    private boolean isSecure;
    private long lastConnectionActivity;

    SessionImpl() {
        this.id = count.getAndIncrement();
    }

    @Override
    public String getProtocolVersion() {
        return "13";
    }

    @Override
    public String getNegotiatedSubprotocol() {
        return this.negotiatedSubprotocol;
    }

    @Override
    public RemoteEndpoint getRemote() {
        return this.peer;
    }

    @Override
    public RemoteEndpoint<T> getRemoteL(Class<T> aClass) {
        return null;
    }

    public Long getId() {
        return count.get();
    }

    @Override
    public boolean isActive() {
        return this.peer.isConnected();
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void close() throws IOException {
        this.close(new CloseReason(CloseReason.CloseCodes.NORMAL_CLOSURE, "no reason given"));
    }

    @Override
    public void close(CloseReason closeReason) throws IOException {
        this.closeReason = closeReason;
        this.peer.close(closeReason);
    }

    public String toString() {
        return "Session(" + this.id + ", " + this.isActive() + ")";
    }

    void setPeer(RemoteEndpointWrapper peer) {
        this.peer = peer;
    }

    @Override
    public void setTimeout(long seconds) {
        this.timeout = seconds;
    }

    @Override
    public void setMaximumMessageSize(long maximumMessageSize) {
        this.maximumMessageSize = maximumMessageSize;
    }

    @Override
    public long getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    @Override
    public List<Extension> getNegotiatedExtensions() {
        return this.negotiatedExtensions;
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public long getInactiveTime() {
        return (System.currentTimeMillis() - this.lastConnectionActivity) / 1000L;
    }

    @Override
    public ClientContainer getContainer() {
        return null;
    }

    @Override
    public void setEncoders(List<Encoder> encoders) {
    }

    @Override
    public void addMessageHandler(MessageHandler listener) {
        this.messageHandlers.add(listener);
    }

    @Override
    public Set getMessageHandlers() {
        return Collections.unmodifiableSet(this.messageHandlers);
    }

    @Override
    public void removeMessageHandler(MessageHandler listener) {
        this.messageHandlers.remove(listener);
    }

    @Override
    public URI getRequestURI() {
        return URI.create(this.peer.getAddress());
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return null;
    }

    @Override
    public String getQueryString() {
        return null;
    }

    protected void updateLastConnectionActivity() {
        this.lastConnectionActivity = System.currentTimeMillis();
    }

    void notifyMessageHandlers(String message) {
        for (MessageHandler mh : this.messageHandlers) {
            if (mh instanceof MessageHandler.Text) {
                ((MessageHandler.Text)mh).onMessage(message);
                continue;
            }
            throw new UnsupportedOperationException("don't handle types other than MessageHandler.Text so far.");
        }
    }

    void notifyMessageHandlers(ByteBuffer message) {
        for (MessageHandler mh : this.messageHandlers) {
            if (mh instanceof MessageHandler.Binary) {
                ((MessageHandler.Binary)mh).onMessage(message);
                continue;
            }
            throw new UnsupportedOperationException("don't handle types other than MessageHandler.Text so far.");
        }
    }
}

