/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2011 - 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.glassfish.tyrus.sample.auction;

import org.glassfish.tyrus.sample.auction.message.PreAuctionTimeBroadcastMessage;

import javax.net.websocket.Session;
import java.io.IOException;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Stepan Kopriva (stepan.kopriva at oracle.com)
 */
public class PreAuctionTimeBroadcasterTask extends TimerTask {

    private long startTimeMs;
    private Auction owner;
    private static final long MILISECONDS_IN_SECOND = 1000;
    private static final long MILISECONDS_IN_MINUTE = MILISECONDS_IN_SECOND * 60;
    private static final long MILISECONDS_IN_HOUR = MILISECONDS_IN_MINUTE * 60;
    private static final long MILISECONDS_IN_DAY = MILISECONDS_IN_HOUR * 24;

    public PreAuctionTimeBroadcasterTask(Auction owner, long startTimeMs) {
        this.owner = owner;
        this.startTimeMs = startTimeMs;
    }

    @Override
    public void run() {
        long diff = startTimeMs - System.currentTimeMillis();

        if (diff < 0) {
            owner.switchStateToAuctionRunning();
        } else {
            if (!owner.getRemoteClients().isEmpty()) {
                String diffString = convertTimeDiffToString(diff);
                PreAuctionTimeBroadcastMessage tbm = new PreAuctionTimeBroadcastMessage("0", diffString);

                for (Session arc : owner.getRemoteClients()) {
                    try {
                        arc.getRemote().sendString(tbm.asString());
                    } catch (IOException ex) {
                        Logger.getLogger(PreAuctionTimeBroadcasterTask.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    private static String convertTimeDiffToString(long timeDiff) {

        long days = timeDiff / MILISECONDS_IN_DAY;
        long rest = timeDiff % MILISECONDS_IN_DAY;

        long hours = rest / MILISECONDS_IN_HOUR;
        rest = rest % MILISECONDS_IN_HOUR;

        long minutes = rest / MILISECONDS_IN_MINUTE;
        rest = rest % MILISECONDS_IN_MINUTE;

        long seconds = rest / MILISECONDS_IN_SECOND;
        return "" + days + ":" + hours + ":" + minutes + ":" + seconds;
    }
}
