/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.sample.auction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.websocket.Session;
import org.glassfish.tyrus.sample.auction.AuctionItem;
import org.glassfish.tyrus.sample.auction.AuctionServer;
import org.glassfish.tyrus.sample.auction.AuctionState;
import org.glassfish.tyrus.sample.auction.AuctionTimeBroadcasterTask;
import org.glassfish.tyrus.sample.auction.PreAuctionTimeBroadcasterTask;
import org.glassfish.tyrus.sample.auction.message.BidRequestMessage;
import org.glassfish.tyrus.sample.auction.message.LoginRequestMessage;
import org.glassfish.tyrus.sample.auction.message.LoginResponseMessage;
import org.glassfish.tyrus.sample.auction.message.PriceUpdateResponseMessage;
import org.glassfish.tyrus.sample.auction.message.ResultMessage;

public class Auction {
    private AuctionServer owner;
    private AuctionState state;
    private final String id;
    private static int idCounter = 0;
    private AuctionItem item;
    private List<Session> arcList = new ArrayList();
    private Timer preAuctionTimer;
    private Timer auctionRunningTimer;
    public Session bestBidder;
    public double bestBid;
    public static final String SEPARATOR = ":";

    public Auction(AuctionServer owner, AuctionItem item) {
        this.owner = owner;
        this.item = item;
        this.state = AuctionState.PRE_AUCTION;
        this.id = new Integer(idCounter).toString();
        this.bestBid = item.getStartingPrice();
        ++idCounter;
    }

    public synchronized void addArc(Session arc) {
        this.arcList.add(arc);
    }

    public synchronized void removeArc(Session arc) {
        this.arcList.remove(arc);
    }

    public void handleLoginRequest(LoginRequestMessage lrm, Session arc) {
        this.addArc(arc);
        LoginResponseMessage response = new LoginResponseMessage(this.id, this.item);
        try {
            arc.getRemote().sendString(response.asString());
        }
        catch (IOException ex) {
            Logger.getLogger(Auction.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.arcList.size() == 1) {
            this.startPreAuctionTimeBroadcast();
        }
    }

    public void handleBidRequest(BidRequestMessage brm, Session arc) {
        Double bid;
        if (this.state == AuctionState.AUCTION_RUNNING && (bid = Double.valueOf(Double.parseDouble((String)brm.getData()))) > this.bestBid) {
            this.bestBid = bid;
            this.bestBidder = arc;
            this.sendPriceUpdateMessage();
            this.stopAuctionTimeBroadcast();
            this.startAuctionTimeBroadcast();
        }
    }

    private void sendPriceUpdateMessage() {
        PriceUpdateResponseMessage purm = new PriceUpdateResponseMessage(this.id, "" + this.bestBid);
        for (Session arc : this.getRemoteClients()) {
            try {
                arc.getRemote().sendString(purm.asString());
            }
            catch (IOException ex) {
                Logger.getLogger(Auction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void startPreAuctionTimeBroadcast() {
        this.preAuctionTimer = new Timer();
        this.preAuctionTimer.schedule((TimerTask)new PreAuctionTimeBroadcasterTask(this, this.item.getAuctionStartTime()), 0L, 1000L);
    }

    private void stopPreAuctionTimeBroadcast() {
        this.preAuctionTimer.cancel();
    }

    public void switchStateToAuctionRunning() {
        this.state = AuctionState.AUCTION_RUNNING;
        this.stopPreAuctionTimeBroadcast();
        this.startAuctionTimeBroadcast();
    }

    public void switchStateToAuctionFinished() {
        this.state = AuctionState.AUCTION_FINISHED;
        this.stopAuctionTimeBroadcast();
        this.sendAuctionResults();
    }

    private void sendAuctionResults() {
        if (this.bestBidder != null) {
            ResultMessage winnerMessage = new ResultMessage(this.id, "Congratulations, You have won the auction.");
            try {
                this.bestBidder.getRemote().sendString(winnerMessage.asString());
            }
            catch (IOException ex) {
                Logger.getLogger(Auction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        ResultMessage loserMessage = new ResultMessage(this.id, "User ");
        for (Session arc : this.arcList) {
            if (arc == this.bestBidder) continue;
            try {
                arc.getRemote().sendString(loserMessage.asString());
            }
            catch (IOException ex) {
                Logger.getLogger(Auction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void startAuctionTimeBroadcast() {
        this.auctionRunningTimer = new Timer();
        this.auctionRunningTimer.schedule((TimerTask)new AuctionTimeBroadcasterTask(this, this.item.getBidTimeoutS()), 0L, 1000L);
    }

    private void stopAuctionTimeBroadcast() {
        this.auctionRunningTimer.cancel();
    }

    public AuctionState getState() {
        return this.state;
    }

    public void setState(AuctionState state) {
        this.state = state;
    }

    public String getId() {
        return this.id;
    }

    public List<Session> getRemoteClients() {
        return Collections.unmodifiableList(this.arcList);
    }

    public AuctionItem getItem() {
        return this.item;
    }
}

