/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.sample.auction;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.websocket.Session;
import javax.net.websocket.annotations.WebSocketClose;
import javax.net.websocket.annotations.WebSocketEndpoint;
import javax.net.websocket.annotations.WebSocketMessage;
import javax.net.websocket.annotations.WebSocketOpen;
import org.glassfish.tyrus.sample.auction.Auction;
import org.glassfish.tyrus.sample.auction.AuctionItem;
import org.glassfish.tyrus.sample.auction.decoders.AuctionListRequestDecoder;
import org.glassfish.tyrus.sample.auction.decoders.BidRequestDecoder;
import org.glassfish.tyrus.sample.auction.decoders.LoginRequestDecoder;
import org.glassfish.tyrus.sample.auction.decoders.LogoutRequestDecoder;
import org.glassfish.tyrus.sample.auction.encoders.LogoutResponseEncoder;
import org.glassfish.tyrus.sample.auction.message.AuctionListRequestMessage;
import org.glassfish.tyrus.sample.auction.message.AuctionListResponseMessage;
import org.glassfish.tyrus.sample.auction.message.BidRequestMessage;
import org.glassfish.tyrus.sample.auction.message.LoginRequestMessage;
import org.glassfish.tyrus.sample.auction.message.LogoutRequestMessage;

@WebSocketEndpoint(value="/auction", decoders={LoginRequestDecoder.class, BidRequestDecoder.class, LogoutRequestDecoder.class, AuctionListRequestDecoder.class, LogoutRequestDecoder.class}, encoders={LogoutResponseEncoder.class})
public class AuctionServer {
    private Set<Auction> auctions = new HashSet();
    private static final Logger logger = Logger.getLogger("application");

    public AuctionServer() {
        Auction auction = new Auction(this, new AuctionItem("Swatch", "Nice Swatch watches, hand made", 100.0, System.currentTimeMillis() + 60000L, 30));
        this.auctions.add(auction);
        Auction auction1 = new Auction(this, new AuctionItem("Rolex", "Nice Rolex watches, hand made", 200.0, System.currentTimeMillis() + 120000L, 30));
        this.auctions.add(auction1);
        Auction auction2 = new Auction(this, new AuctionItem("Omega", "Nice Omega watches, hand made", 300.0, System.currentTimeMillis() + 180000L, 30));
        this.auctions.add(auction2);
    }

    @WebSocketOpen
    public void init(Session remote) {
    }

    @WebSocketClose
    public void handleClosedConnection(Session arc) {
        for (Auction auction : this.auctions) {
            auction.removeArc(arc);
        }
    }

    @WebSocketMessage
    public void handleLogoutRequest(LogoutRequestMessage alrm, Session arc) {
        this.handleClosedConnection(arc);
    }

    @WebSocketMessage
    public void handleAuctionListRequest(AuctionListRequestMessage alrm, Session arc) {
        StringBuilder sb = new StringBuilder("-");
        SimpleDateFormat formatter = new SimpleDateFormat("hh:mm:ss");
        for (Auction auction : this.auctions) {
            Date d = new Date(auction.getItem().getAuctionStartTime());
            sb.append(auction.getId()).append("-").append(auction.getItem().getName()).append("-");
        }
        try {
            arc.getRemote().sendString(new AuctionListResponseMessage("0", sb.toString()).asString());
        }
        catch (IOException ex) {
            Logger.getLogger(AuctionServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @WebSocketMessage
    public void handleLoginRequest(LoginRequestMessage lrm, Session arc) {
        String communicationId = lrm.getCommunicationId();
        for (Auction auction : this.auctions) {
            if (!communicationId.equals(auction.getId())) continue;
            auction.handleLoginRequest(lrm, arc);
        }
    }

    @WebSocketMessage
    public void handleBidRequest(BidRequestMessage brm, Session arc) {
        String communicationId = brm.getCommunicationId();
        for (Auction auction : this.auctions) {
            if (!communicationId.equals(auction.getId())) continue;
            auction.handleBidRequest(brm, arc);
            break;
        }
    }
}

