/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.sample.auction;

import java.io.IOException;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.websocket.Session;
import org.glassfish.tyrus.sample.auction.Auction;
import org.glassfish.tyrus.sample.auction.PreAuctionTimeBroadcasterTask;
import org.glassfish.tyrus.sample.auction.message.AuctionTimeBroadcastMessage;

public class AuctionTimeBroadcasterTask
extends TimerTask {
    private Auction owner;
    private int timeoutCounter;

    public AuctionTimeBroadcasterTask(Auction owner, int timeoutCounter) {
        this.owner = owner;
        this.timeoutCounter = timeoutCounter;
    }

    @Override
    public void run() {
        if (this.timeoutCounter < 0) {
            this.owner.switchStateToAuctionFinished();
        } else if (!this.owner.getRemoteClients().isEmpty()) {
            AuctionTimeBroadcastMessage atbm = new AuctionTimeBroadcastMessage(this.owner.getId(), this.timeoutCounter);
            for (Session arc : this.owner.getRemoteClients()) {
                try {
                    arc.getRemote().sendString(atbm.asString());
                }
                catch (IOException ex) {
                    Logger.getLogger(PreAuctionTimeBroadcasterTask.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        --this.timeoutCounter;
    }
}

