/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Enumeration;
import java.util.logging.Level;

public class RoleLink
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!descriptor.getWebComponentDescriptors().isEmpty()) {
            boolean oneFailed = false;
            int na = 0;
            int noWd = 0;
            for (WebComponentDescriptor next : descriptor.getWebComponentDescriptors()) {
                ++noWd;
                boolean foundIt = false;
                if (next.getSecurityRoleReferences().hasMoreElements()) {
                    Enumeration ee = next.getSecurityRoleReferences();
                    while (ee.hasMoreElements()) {
                        RoleReference rr = (RoleReference)ee.nextElement();
                        foundIt = false;
                        String linkName = rr.getValue();
                        this.logger.log(Level.FINE, "servlet linkName: " + linkName);
                        if (descriptor.getSecurityRoles().hasMoreElements()) {
                            Enumeration eee = descriptor.getSecurityRoles();
                            while (eee.hasMoreElements()) {
                                SecurityRoleDescriptor srdNext = (SecurityRoleDescriptor)eee.nextElement();
                                if (!linkName.equals(srdNext.getName())) continue;
                                foundIt = true;
                                break;
                            }
                        } else {
                            foundIt = false;
                        }
                        if (foundIt) {
                            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "role-link [ {0} ] links security role reference to a defined security role within web application [ {1} ]", new Object[]{linkName, descriptor.getName()}));
                            continue;
                        }
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: role-link [ {0} ] does not link security role reference to a defined security role within web application [ {1} ]", new Object[]{linkName, descriptor.getName()}));
                    }
                    continue;
                }
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "[ {0} ] has no role-link element defined within the web archive [ {1} ]", new Object[]{next.getName(), descriptor.getName()}));
                ++na;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (na == noWd) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no location elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

