/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.BaseVerifier;
import com.sun.enterprise.tools.verifier.DescriptorFactory;
import com.sun.enterprise.tools.verifier.ReportHandler;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.tools.verifier.apiscan.stdapis.APIRepository;
import com.sun.enterprise.tools.verifier.app.ApplicationVerifier;
import com.sun.enterprise.tools.verifier.appclient.AppClientVerifier;
import com.sun.enterprise.tools.verifier.connector.ConnectorVerifier;
import com.sun.enterprise.tools.verifier.ejb.EjbVerifier;
import com.sun.enterprise.tools.verifier.util.LogDomains;
import com.sun.enterprise.tools.verifier.web.WebVerifier;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.deployment.common.OptionalPkgDependency;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class Verifier {
    @Inject
    private DescriptorFactory descriptorFactory;
    @Inject
    private ClassLoaderHierarchy clh;
    private Application application = null;
    private static boolean debug = false;
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");
    private LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    private final String TMPDIR = System.getProperty("java.io.tmpdir");
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddhhmmss");
    private String explodeDirName = this.TMPDIR + File.separator + "exploded" + this.dateFormatter.format(new Date());
    private VerifierFrameworkContext verifierFrameworkContext = null;

    public void init(VerifierFrameworkContext verifierFrameworkContext) throws IOException {
        this.verifierFrameworkContext = verifierFrameworkContext;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("com/sun/enterprise/tools/verifier/config/standard-apis.xml");
        try {
            APIRepository.Initialize(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        if (!verifierFrameworkContext.isBackend()) {
            try {
                this.initStandalone();
            }
            catch (IOException ioe) {
                this.cleanup();
                throw ioe;
            }
            catch (RuntimeException re) {
                this.cleanup();
                throw re;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify() throws IOException {
        assert (this.verifierFrameworkContext != null);
        try {
            this.verifyArchive();
        }
        finally {
            this.cleanup();
        }
    }

    public void generateReports() throws IOException {
        new ReportHandler(this.verifierFrameworkContext).generateAllReports();
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void debug(Throwable t) {
        logger.log(Level.FINEST, "Exception occurred", t);
    }

    private void verifyArchive() {
        if (!this.application.isVirtual()) {
            this.runVerifier(new ApplicationVerifier(this.verifierFrameworkContext, this.application));
        }
        for (EjbBundleDescriptor ejbd : this.application.getEjbBundleDescriptors()) {
            this.runVerifier(new EjbVerifier(this.verifierFrameworkContext, ejbd));
        }
        for (WebBundleDescriptor webd : this.application.getWebBundleDescriptors()) {
            this.runVerifier(new WebVerifier(this.verifierFrameworkContext, webd));
        }
        for (ApplicationClientDescriptor appClientDescriptor : this.application.getApplicationClientDescriptors()) {
            this.runVerifier(new AppClientVerifier(this.verifierFrameworkContext, appClientDescriptor));
        }
        for (ConnectorDescriptor cond : this.application.getRarDescriptors()) {
            this.runVerifier(new ConnectorVerifier(this.verifierFrameworkContext, cond));
        }
    }

    private void initStandalone() throws IOException {
        logger.log(Level.FINE, this.getClass().getName() + ".debug.startingLoadJar");
        this.initVerifierTmpDirs();
        String jarFile = this.verifierFrameworkContext.getJarFileName();
        OptionalPkgDependency.satisfyOptionalPackageDependencies();
        try {
            DescriptorFactory.ResultHolder result = this.descriptorFactory.createApplicationDescriptor(new File(jarFile), new File(this.explodeDirName), this.clh.getCommonClassLoader());
            this.application = result.application;
            this.verifierFrameworkContext.setApplication(this.application);
            this.verifierFrameworkContext.setArchive(result.archive);
        }
        catch (IOException e) {
            this.log("Problem in creating application descriptor", e);
            throw e;
        }
    }

    private void runVerifier(BaseVerifier baseVerifier) {
        try {
            baseVerifier.verify();
        }
        catch (Exception e) {
            this.log("Problem in running tests for :" + baseVerifier.getDescriptor().getName(), e);
        }
    }

    private boolean initVerifierTmpDirs() throws IOException {
        File test = new File(this.explodeDirName);
        if (!test.isDirectory() && !test.getAbsoluteFile().mkdirs()) {
            logger.log(Level.SEVERE, this.getClass().getName() + ".explodedircreateerror", test.getAbsolutePath());
            throw new IOException(this.smh.getLocalString(this.getClass().getName() + ".explodedircreateerror", test.getAbsolutePath()));
        }
        return true;
    }

    public void cleanup() {
        if (!this.verifierFrameworkContext.isBackend() && !new File(this.verifierFrameworkContext.getJarFileName()).isDirectory()) {
            FileUtils.whack((File)new File(this.explodeDirName));
        }
    }

    private void log(String message, Exception e) {
        if (message == null) {
            message = "";
        }
        LogRecord logRecord = new LogRecord(Level.SEVERE, message);
        logRecord.setThrown(e);
        this.verifierFrameworkContext.getResultManager().log(logRecord);
    }
}

