/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.glassfish.bootstrap.ASMainFelix;
import com.sun.enterprise.module.bootstrap.ArgumentManager;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class VerifierOSGiMain {
    private static final String VERIFIER_MODULE = "org.glassfish.verifier";

    public static void main(String[] args) throws Exception {
        Properties ctx = VerifierOSGiMain.buildStartupContextProperties(args);
        ASMainFelix main = new ASMainFelix(){

            protected void configureEnvironment() throws IOException {
                File cacheDir = File.createTempFile("verifier-felix-cache", "tmp");
                if (!cacheDir.delete() || !cacheDir.mkdirs()) {
                    throw new IOException("Not able to create felix cache dir " + cacheDir.getAbsolutePath());
                }
                System.out.println("Felix cache dir created at " + cacheDir.getAbsolutePath());
                cacheDir.deleteOnExit();
                System.setProperty("org.osgi.framework.storage", cacheDir.getAbsolutePath());
                System.setProperty("com.sun.enterprise.hk2.cacheDir", cacheDir.getAbsolutePath());
            }
        };
        main.start(ctx);
    }

    private static Properties buildStartupContextProperties(String ... args) throws IOException {
        Properties p = ArgumentManager.argsToMap((String[])args);
        p.put("__time_zero", new Long(System.currentTimeMillis()).toString());
        p.put("hk2.startup.context.mainModule", VERIFIER_MODULE);
        VerifierOSGiMain.addRawStartupInfo(args, p);
        return p;
    }

    private static void addRawStartupInfo(String[] args, Properties p) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(",,,");
            }
            sb.append(args[i]);
        }
        p.put("-startup-classpath", System.getProperty("java.class.path"));
        p.put("-startup-classname", VerifierOSGiMain.class.getName());
        p.put("-startup-args", sb.toString());
    }
}

