/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.ResultManager;
import com.sun.enterprise.tools.verifier.TestInformation;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierEventsListener;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.persistence.PersistenceUnitCheckMgrImpl;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.util.LogDomains;
import com.sun.enterprise.tools.verifier.webservices.WebServiceCheckMgrImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.EventObject;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.api.deployment.archive.Archive;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CheckMgr {
    static Vector<VerifierEventsListener> listenerList = new Vector();
    protected VerifierFrameworkContext verifierFrameworkContext = null;
    protected final boolean debug = Verifier.isDebug();
    protected VerifierTestContext context = null;
    private static final String excludeListFileName = "TestExcludeList.xml";
    private Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");
    protected boolean isDDPresent = false;
    private Vector<TestInformation> test = new Vector();

    protected void check(Descriptor descriptor) throws Exception {
        this.logger.log(Level.FINE, "com.sun.enterprise.tools.verifier.CheckMgr.check", new Object[]{this.getClass().getName(), descriptor.getName()});
        this.setRuntimeDDPresent(this.getAbstractArchiveUri(descriptor));
        this.loadTestInformationFromPropsFile();
        this.logger.log(Level.FINE, "com.sun.enterprise.tools.verifier.CheckMgr.RunAllTests", new Object[]{descriptor.getName()});
        String schemaVersion = this.getSchemaVersion(descriptor);
        this.context.setSchemaVersion(schemaVersion);
        this.context.setJavaEEVersion(this.verifierFrameworkContext.getJavaEEVersion());
        this.context.setComponentNameConstructor(this.getComponentNameConstructor(descriptor));
        FileArchive moduleArchive = new FileArchive();
        moduleArchive.open(this.getAbstractArchiveUri(descriptor));
        this.context.setModuleArchive((Archive)moduleArchive);
        ResultManager resultManager = this.verifierFrameworkContext.getResultManager();
        for (int i = 0; i < this.test.size(); ++i) {
            TestInformation ti = this.test.elementAt(i);
            String minVersion = ti.getMinimumVersion();
            String maxVersion = ti.getMaximumVersion();
            if (schemaVersion != null && minVersion != null && schemaVersion.compareTo(minVersion) < 0) {
                this.logger.log(Level.FINE, "com.sun.enterprise.tools.verifier.CheckMgr.version.NOT_APPLICABLE", new Object[]{ti.getClassName()});
                continue;
            }
            if (schemaVersion != null && maxVersion != null && schemaVersion.compareTo(maxVersion) > 0) {
                this.logger.log(Level.FINE, "com.sun.enterprise.tools.verifier.CheckMgr.version.NOT_APPLICABLE", new Object[]{ti.getClassName()});
                continue;
            }
            if (!this.isApplicable(ti, descriptor)) {
                this.logger.log(Level.FINE, "com.sun.enterprise.tools.verifier.CheckMgr.version.NOT_APPLICABLE", new Object[]{ti.getClassName()});
                continue;
            }
            try {
                Class<?> c = Class.forName(ti.getClassName());
                VerifierCheck t = (VerifierCheck)c.newInstance();
                t.setVerifierContext(this.context);
                Result r = t.check(descriptor);
                this.setModuleName(r);
                resultManager.add(r);
                this.fireTestFinishedEvent(r);
                continue;
            }
            catch (Throwable e) {
                LogRecord logRecord = new LogRecord(Level.SEVERE, ti.getClassName());
                logRecord.setThrown(e);
                resultManager.log(logRecord);
            }
        }
        this.fireAllTestsFinishedEvent();
    }

    protected abstract ComponentNameConstructor getComponentNameConstructor(Descriptor var1);

    public void setVerifierContext(VerifierTestContext context) {
        this.context = context;
    }

    public static void addVerifierEventsListener(VerifierEventsListener l) {
        listenerList.add(l);
    }

    public static void removeVerifierEventsListener(VerifierEventsListener l) {
        listenerList.remove(l);
    }

    protected abstract String getTestsListFileName();

    protected abstract void setModuleName(Result var1);

    protected abstract String getSchemaVersion(Descriptor var1);

    protected abstract String getSunONETestsListFileName();

    protected String getArchiveUri(Descriptor descriptor) {
        String archiveUri = this.getBundleDescriptor(descriptor).getModuleDescriptor().getArchiveUri();
        return new File(archiveUri).getName();
    }

    protected boolean isApplicable(TestInformation test, Descriptor descriptor) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTestFinishedEvent(Result r) {
        Object[] listeners;
        Vector<VerifierEventsListener> vector = listenerList;
        synchronized (vector) {
            listeners = listenerList.toArray();
        }
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof VerifierEventsListener)) continue;
            EventObject event = new EventObject(r);
            ((VerifierEventsListener)listeners[i]).testFinished(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAllTestsFinishedEvent() {
        Object[] listeners;
        Vector<VerifierEventsListener> vector = listenerList;
        synchronized (vector) {
            listeners = listenerList.toArray();
        }
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof VerifierEventsListener)) continue;
            EventObject event = new EventObject(this);
            ((VerifierEventsListener)listeners[i]).allTestsFinished(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTestInformationFromPropsFile() throws ParserConfigurationException, SAXException, IOException {
        if (!this.test.isEmpty()) {
            return;
        }
        this.logger.log(Level.FINE, "com.sun.enterprise.tools.verifier.CheckMgr.TestnamesPropsFile");
        InputStream is = this.getTestsFileInputStreamFor(this.getTestsListFileName());
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = db.parse(is);
            NodeList list = doc.getElementsByTagName("test");
            for (int i = 0; i < list.getLength(); ++i) {
                Element e = (Element)list.item(i);
                NodeList nl = e.getChildNodes();
                TestInformation ti = new TestInformation();
                for (int j = 0; j < nl.getLength(); ++j) {
                    Node el;
                    String nodeName = nl.item(j).getNodeName();
                    if ("test-class".equals(nodeName.trim())) {
                        el = nl.item(j);
                        ti.setClassName(el.getFirstChild().getNodeValue().trim());
                    }
                    if ("minimum-version".equals(nodeName.trim())) {
                        el = nl.item(j);
                        ti.setMinimumVersion(el.getFirstChild().getNodeValue().trim());
                    }
                    if (!"maximum-version".equals(nodeName.trim())) continue;
                    el = nl.item(j);
                    ti.setMaximumVersion(el.getFirstChild().getNodeValue().trim());
                }
                this.test.addElement(ti);
            }
            if (!this.verifierFrameworkContext.isPortabilityMode() && this.getRuntimeDDPresent()) {
                this.readSunONETests(this.test);
            }
            Vector<TestInformation> testExcluded = this.getTestFromExcludeList();
            this.test = this.getFinalTestList(this.test, testExcluded);
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<TestInformation> getTestFromExcludeList() throws ParserConfigurationException, SAXException, IOException {
        Vector<TestInformation> testExcluded = new Vector<TestInformation>();
        this.logger.log(Level.FINE, "com.sun.enterprise.tools.verifier.CheckMgr.TestnamesPropsFile");
        InputStream is = this.getTestsFileInputStreamFor(excludeListFileName);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            NodeList list = doc.getElementsByTagName("test");
            for (int i = 0; i < list.getLength(); ++i) {
                Element e = (Element)list.item(i);
                NodeList nl = e.getChildNodes();
                TestInformation ti = new TestInformation();
                for (int j = 0; j < nl.getLength(); ++j) {
                    String nodeName = nl.item(j).getNodeName();
                    if (!"test-class".equals(nodeName.trim())) continue;
                    Node el = nl.item(j);
                    ti.setClassName(el.getFirstChild().getNodeValue().trim());
                }
                testExcluded.addElement(ti);
            }
        }
        finally {
            is.close();
        }
        return testExcluded;
    }

    protected Vector<TestInformation> getFinalTestList(Vector<TestInformation> orignalList, Vector<TestInformation> excludeList) {
        if (excludeList == null) {
            return orignalList;
        }
        if (orignalList.size() != 0 && excludeList.size() != 0) {
            for (int i = 0; i < excludeList.size(); ++i) {
                for (int j = 0; j < orignalList.size(); ++j) {
                    if (!orignalList.elementAt(j).getClassName().equals(excludeList.elementAt(i).getClassName())) continue;
                    orignalList.remove(j);
                }
            }
        }
        return orignalList;
    }

    protected void checkWebServices(Descriptor descriptor) throws Exception {
        if (this.verifierFrameworkContext.isPartition() && !this.verifierFrameworkContext.isWebServices()) {
            return;
        }
        BundleDescriptor bundleDescriptor = (BundleDescriptor)descriptor;
        WebServiceCheckMgrImpl webServiceCheckMgr = new WebServiceCheckMgrImpl(this.verifierFrameworkContext);
        if (bundleDescriptor.hasWebServices()) {
            WebServicesDescriptor wdesc = bundleDescriptor.getWebServices();
            webServiceCheckMgr.setVerifierContext(this.context);
            webServiceCheckMgr.check((Descriptor)wdesc);
        }
    }

    protected void checkPersistenceUnits(RootDeploymentDescriptor descriptor) throws Exception {
        if (this.verifierFrameworkContext.isPartition() && !this.verifierFrameworkContext.isPersistenceUnits()) {
            return;
        }
        PersistenceUnitCheckMgrImpl puCheckMgr = new PersistenceUnitCheckMgrImpl(this.verifierFrameworkContext, this.context);
        for (PersistenceUnitsDescriptor pus : descriptor.getExtensionsDescriptors(PersistenceUnitsDescriptor.class)) {
            for (PersistenceUnitDescriptor pu : pus.getPersistenceUnitDescriptors()) {
                ((CheckMgr)puCheckMgr).check((Descriptor)pu);
            }
        }
    }

    protected static String getSunPrefix() {
        return "sun-";
    }

    protected void setRuntimeDDPresent(String uri) {
        this.logger.warning("setRuntimeDDPresent method not implemented");
    }

    private boolean getRuntimeDDPresent() {
        return this.isDDPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSunONETests(Vector<TestInformation> test) throws ParserConfigurationException, SAXException, IOException {
        String sunonetests = this.getSunONETestsListFileName();
        if (sunonetests == null) {
            return;
        }
        InputStream is = this.getTestsFileInputStreamFor(sunonetests);
        if (is == null) {
            return;
        }
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = db.parse(is);
            NodeList list = doc.getElementsByTagName("test");
            for (int i = 0; i < list.getLength(); ++i) {
                Element e = (Element)list.item(i);
                NodeList nl = e.getChildNodes();
                TestInformation ti = new TestInformation();
                for (int j = 0; j < nl.getLength(); ++j) {
                    Node el;
                    String nodeName = nl.item(j).getNodeName();
                    if ("test-class".equals(nodeName.trim())) {
                        el = nl.item(j);
                        ti.setClassName(el.getFirstChild().getNodeValue().trim());
                    }
                    if ("minimum-version".equals(nodeName.trim())) {
                        el = nl.item(j);
                        ti.setMinimumVersion(el.getFirstChild().getNodeValue().trim());
                    }
                    if (!"maximum-version".equals(nodeName.trim())) continue;
                    el = nl.item(j);
                    ti.setMaximumVersion(el.getFirstChild().getNodeValue().trim());
                }
                test.addElement(ti);
            }
        }
        finally {
            is.close();
        }
    }

    private InputStream getTestsFileInputStreamFor(String filename) {
        return this.getClass().getClassLoader().getResourceAsStream("com/sun/enterprise/tools/verifier/config/" + filename);
    }

    protected String getAbstractArchiveUri(Descriptor descriptor) {
        String archBase = this.context.getAbstractArchive().getURI().toString();
        if (descriptor instanceof Application) {
            return archBase;
        }
        ModuleDescriptor mdesc = this.getBundleDescriptor(descriptor).getModuleDescriptor();
        if (mdesc.isStandalone()) {
            return archBase;
        }
        return archBase + "/" + FileUtils.makeFriendlyFilename((String)mdesc.getArchiveUri());
    }

    protected BundleDescriptor getBundleDescriptor(Descriptor descriptor) {
        return (BundleDescriptor)descriptor;
    }
}

