/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.packaging;

class DeweyDecimal {
    private int major = 0;
    private int minor = 0;
    private int micro = 0;

    public DeweyDecimal() {
    }

    public DeweyDecimal(String s) {
        s = s.trim();
        int idxOfFirstDot = s.indexOf(46, 0);
        if (idxOfFirstDot == -1) {
            this.major = Integer.parseInt(s);
            return;
        }
        this.major = Integer.parseInt(s.substring(0, idxOfFirstDot));
        int idxOfSecondDot = s.indexOf(46, idxOfFirstDot + 1);
        if (idxOfSecondDot == -1) {
            this.minor = Integer.parseInt(s.substring(idxOfFirstDot + 1));
            return;
        }
        this.minor = Integer.parseInt(s.substring(idxOfFirstDot + 1, idxOfSecondDot));
        this.micro = Integer.parseInt(s.substring(idxOfSecondDot + 1));
    }

    public boolean isCompatible(DeweyDecimal another) {
        if (another == null) {
            return false;
        }
        if (this.major < another.major) {
            return false;
        }
        if (this.major == another.major) {
            if (this.minor < another.minor) {
                return false;
            }
            if (this.minor == another.minor) {
                return this.micro >= another.micro;
            }
            return true;
        }
        return true;
    }

    public boolean isCompatible(String another) {
        if (another == null) {
            return false;
        }
        return this.isCompatible(new DeweyDecimal(another));
    }

    public int hashCode() {
        return this.major + this.minor + this.micro;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        try {
            DeweyDecimal other = (DeweyDecimal)o;
            return this.major == other.major && this.minor == other.minor && this.micro == other.micro;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        return "" + this.major + "." + this.minor + "." + this.micro;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: " + DeweyDecimal.class.getName() + " <s1 in the format 1.2.3> <s2 in the format 5.5.6>");
            System.exit(1);
        }
        DeweyDecimal d1 = new DeweyDecimal(args[0]);
        DeweyDecimal d2 = new DeweyDecimal(args[1]);
        System.out.println(d1 + ".isCompatible(" + d1 + ")=" + d1.isCompatible(d1));
        System.out.println(d2 + ".isCompatible(" + d2 + ")=" + d2.isCompatible(d2));
        System.out.println(d1 + ".isCompatible(" + d2 + ")=" + d1.isCompatible(d2));
        System.out.println(d2 + ".isCompatible(" + d1 + ")=" + d2.isCompatible(d1));
        System.out.println(d1 + ".equals(" + d1 + ")=" + d1.equals(d1));
        System.out.println(d2 + ".equals(" + d2 + ")=" + d2.equals(d2));
        System.out.println(d1 + ".equals(" + d2 + ")=" + d1.equals(d2));
        System.out.println(d2 + ".equals(" + d1 + ")=" + d2.equals(d1));
        System.out.println(d1 + ".hashCode()=" + d1.hashCode());
        System.out.println(d2 + ".hashCode()=" + d2.hashCode());
    }
}

