/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.classfile;

import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoader;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompiler;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClosureCompilerImplBase
implements ClosureCompiler {
    protected ClassFileLoader loader;
    protected HashSet<String> excludedClasses = new HashSet();
    protected HashSet<String> excludedPackages = new HashSet();
    protected HashSet<String> excludedPatterns = new HashSet();
    protected HashSet<String> visitedClasses = new HashSet();
    private static String resourceBundleName = "com.sun.enterprise.tools.verifier.apiscan.LocalStrings";
    protected static final Logger logger = Logger.getLogger("apiscan.classfile", resourceBundleName);
    private static final String myClassName = "ClosureCompilerImplBase";

    protected ClosureCompilerImplBase(ClassFileLoader loader) {
        this.loader = loader;
    }

    public void addExcludedClass(String className) {
        this.excludedClasses.add(className);
    }

    public void addExcludedPackage(String pkgName) {
        this.excludedPackages.add(pkgName);
    }

    public void addExcludedPattern(String pattern) {
        this.excludedPatterns.add(pattern);
    }

    public boolean buildClosure(JarFile jar) throws IOException {
        boolean result = true;
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            String clsName = entries.nextElement().getName();
            if (!clsName.endsWith(".class")) continue;
            String externalClsName = clsName.substring(0, clsName.lastIndexOf(".class")).replace('/', '.');
            boolean newresult = this.buildClosure(externalClsName);
            result = newresult && result;
        }
        return result;
    }

    public Collection<String> getNativeMethods() {
        throw new UnsupportedOperationException();
    }

    protected boolean needToBuildClosure(String className) {
        boolean result = true;
        if (this.visitedClasses.contains(className)) {
            result = false;
        } else if (this.excludedClasses.contains(className)) {
            result = false;
        } else if (this.excludedPackages.contains(ClosureCompilerImplBase.getPackageName(className))) {
            result = false;
        } else {
            for (String pattern : this.excludedPatterns) {
                if (!className.startsWith(pattern)) continue;
                result = false;
                break;
            }
        }
        logger.logp(Level.FINEST, myClassName, "needToBuildClosure", className + " " + result);
        return result;
    }

    protected static String getPackageName(String className) {
        int idx = className.lastIndexOf(46);
        if (idx != -1) {
            return className.substring(0, idx);
        }
        return "";
    }
}

