/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.jk.common;

import java.io.IOException;

import org.apache.jk.core.JkHandler;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;




/**
 * Dispatch based on the message type. ( XXX make it more generic,
 * now it's specific to ajp13 ).
 * 
 * @author Costin Manolache
 */
public class HandlerDispatch extends JkHandler
{
    private static org.apache.commons.logging.Log log=
        org.apache.commons.logging.LogFactory.getLog( HandlerDispatch.class );

    public HandlerDispatch() 
    {
    }

    public void init() {
    }

    JkHandler handlers[]=new JkHandler[MAX_HANDLERS];
    String handlerNames[]=new String[MAX_HANDLERS];
    
    static final int MAX_HANDLERS=32;    
    static final int RESERVED=16;  // reserved names, backward compat
    int currentId=RESERVED;

    public int registerMessageType( int id, String name, JkHandler h,
                                    String sig[] )
    {
        if( log.isDebugEnabled() )
            log.debug( "Register message " + id + " " + h.getName() +
                 " " + h.getClass().getName());
	if( id < 0 ) {
	    // try to find it by name
	    for( int i=0; i< handlerNames.length; i++ ) {
                if( handlerNames[i]==null ) continue;
                if( name.equals( handlerNames[i] ) )
                    return i;
            }
	    handlers[currentId]=h;
            handlerNames[currentId]=name;
	    currentId++;
	    return currentId;
	}
	handlers[id]=h;
        handlerNames[currentId]=name;
	return id;
    }

    
    // -------------------- Incoming message --------------------

    public int invoke(Msg msg, MsgContext ep ) 
        throws IOException
    {
        int type=msg.peekByte();
        ep.setType( type );
        
        if( type > handlers.length ||
            handlers[type]==null ) {
	    if( log.isDebugEnabled() )
                log.debug( "Invalid handler " + type );
	    return ERROR;
	}

        if( log.isDebugEnabled() )
            log.debug( "Received " + type + " " + handlers[type].getName());
        
	JkHandler handler=handlers[type];
        
        return handler.invoke( msg, ep );
    }

 }
