/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 */

package org.glassfish.api.embedded.web.config;

import java.util.Set;

/**
 * This class represents a list of URL patterns and HTTP
 * methods that describe a set of Web resources to be protected.
 * @author Rajiv Mordani
 */
public class WebResourceCollection {

    private String name;
    private Set<String> urlPatterns;
    private Set<String> httpMethods;
    private Set<String> httpMethodOmissions;

    /**
     * Sets the name of this collection
     *
     * @param name the name of this collection
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Gets the name of this collection
     *
     * @return the name of this collection
     */
    public String getName() {
        return this.name;
    }

    /**
     * The set of url patterns that correspond to this
     * web resource
     * 
     * @param urlPatterns
     */
    public void setUrlPatterns(Set<String> urlPatterns) {
        this.urlPatterns = urlPatterns;          
    }

    /**
     *
     * @return
     */
    public Set<String> getUrlPatterns() {
        return this.urlPatterns;
    }

    /**
     *
     * @param httpMethods
     */
    public void setHttpMethods(Set<String> httpMethods) {
        this.httpMethods = httpMethods;
    }

    /**
     *
     * @return
     */
    public Set<String> getHttpMethods() {
        return this.httpMethods;
    }

    /**
     *
     * @param httpMethodOmissions
     */
    public void setHttpMethodOmissions(Set<String> httpMethodOmissions) {
        this.httpMethodOmissions = httpMethodOmissions;
    }

    /**
     *
     * @return
     */
    public Set<String> getHttpMethodOmissions() {
        return this.httpMethodOmissions;
    }
}
