/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.embed.impl;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Pipeline;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.valves.RemoteAddrValve;
import org.apache.catalina.valves.RemoteHostValve;
import org.glassfish.api.embedded.web.ConfigException;
import org.glassfish.api.embedded.web.WebListener;
import org.glassfish.api.embedded.web.config.VirtualServerConfig;
import org.glassfish.web.embed.impl.Context;
import org.glassfish.web.valve.GlassFishValve;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualServer
extends StandardHost
implements org.glassfish.api.embedded.web.VirtualServer {
    private static Logger log = Logger.getLogger(VirtualServer.class.getName());
    private AccessLogValve accessLogValve = new AccessLogValve();
    private boolean allowLinking = false;
    private VirtualServerConfig config;
    private String defaultContextXmlLocation;
    private String defaultWebXmlLocation;

    public VirtualServer() {
        this.accessLogValve.setContainer((Container)this);
    }

    public String getId() {
        return this.getName();
    }

    public File getDocRoot() {
        return new File(this.getAppBase());
    }

    public Collection<WebListener> getWebListeners() {
        return null;
    }

    public void addContext(org.glassfish.api.embedded.web.Context context, String contextRoot) throws ConfigException, org.glassfish.api.embedded.LifecycleException {
        this.addChild((Container)context);
    }

    public void removeContext(org.glassfish.api.embedded.web.Context context) {
        this.removeChild((Container)context);
    }

    public Context findContext(String contextRoot) {
        Context[] contexts;
        Context context = null;
        for (Context c : contexts = (Context[])this.findChildren()) {
            if (!c.getPath().equals(contextRoot)) continue;
            context = c;
        }
        return context;
    }

    public Collection<org.glassfish.api.embedded.web.Context> getContexts() {
        org.glassfish.api.embedded.web.Context[] contexts = (org.glassfish.api.embedded.web.Context[])this.findChildren();
        return Arrays.asList(contexts);
    }

    public VirtualServerConfig getConfig() {
        return this.config;
    }

    public void enable() throws org.glassfish.api.embedded.LifecycleException {
        try {
            this.start();
        }
        catch (LifecycleException e) {
            throw new org.glassfish.api.embedded.LifecycleException((Throwable)e);
        }
    }

    public void disable() throws org.glassfish.api.embedded.LifecycleException {
        try {
            this.stop();
        }
        catch (LifecycleException e) {
            throw new org.glassfish.api.embedded.LifecycleException((Throwable)e);
        }
    }

    public void setConfig(VirtualServerConfig config) throws ConfigException {
        this.config = config;
        this.configureSingleSignOn(config.isSsoEnabled());
        if (config.isAccessLoggingEnabled()) {
            this.enableAccessLogging();
        } else {
            this.disableAccessLogging();
        }
        this.setDefaultWebXmlLocation(config.getDefaultWebXml());
        this.setDefaultContextXmlLocation(config.getContextXmlDefault());
        this.setAllowLinking(config.isAllowLinking());
        this.configureRemoteAddressFilterValve(config.getAllowRemoteAddress(), config.getDenyRemoteAddress());
        this.configureRemoteHostFilterValve(config.getAllowRemoteHost(), config.getAllowRemoteHost());
        this.configureAliases(config.getHostNames());
    }

    protected void configureAliases(String ... hosts) {
        for (String host : hosts) {
            if (host.equalsIgnoreCase("localhost") || host.equalsIgnoreCase("localhost.localdomain")) continue;
            this.addAlias(host);
        }
    }

    protected void configureRemoteAddressFilterValve(String allow, String deny) {
        RemoteAddrValve remoteAddrValve = null;
        if (allow != null || deny != null) {
            remoteAddrValve = new RemoteAddrValve();
        }
        if (allow != null) {
            remoteAddrValve.setAllow(allow);
        }
        if (deny != null) {
            remoteAddrValve.setDeny(deny);
        }
        if (remoteAddrValve != null) {
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteAddrValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve((GlassFishValve)remoteAddrValve);
        }
    }

    protected void configureRemoteHostFilterValve(String allow, String deny) {
        RemoteHostValve remoteHostValve = null;
        if (allow != null || deny != null) {
            remoteHostValve = new RemoteHostValve();
        }
        if (allow != null) {
            remoteHostValve.setAllow(allow);
        }
        if (deny != null) {
            remoteHostValve.setDeny(deny);
        }
        if (remoteHostValve != null) {
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteHostValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve((GlassFishValve)remoteHostValve);
        }
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public void configureSingleSignOn(boolean ssoEnabled) {
        if (!ssoEnabled) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("sso is disabled");
            }
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                this.removeValve(valves[i]);
                break;
            }
        } else {
            try {
                SingleSignOn sso = new SingleSignOn();
                GlassFishValve[] valves = this.getValves();
                for (int i = 0; valves != null && i < valves.length; ++i) {
                    if (!(valves[i] instanceof SingleSignOn)) continue;
                    this.removeValve(valves[i]);
                    break;
                }
                this.addValve((GlassFishValve)sso);
            }
            catch (Exception e) {
                log.severe(e.getMessage());
            }
        }
    }

    private boolean isAccessLogValveActivated() {
        GlassFishValve[] valves;
        Pipeline p = this.getPipeline();
        if (p != null && (valves = p.getValves()) != null) {
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof AccessLogValve)) continue;
                return true;
            }
        }
        return false;
    }

    public void enableAccessLogging() {
        if (!this.isAccessLogValveActivated()) {
            this.addValve((GlassFishValve)this.accessLogValve);
        } else {
            try {
                if (this.accessLogValve.isStarted()) {
                    this.accessLogValve.stop();
                }
                this.accessLogValve.start();
            }
            catch (LifecycleException le) {
                log.severe(le.getMessage());
            }
        }
    }

    public void disableAccessLogging() {
        this.removeValve((GlassFishValve)this.accessLogValve);
    }

    public String getDefaultContextXmlLocation() {
        return this.defaultContextXmlLocation;
    }

    public void setDefaultContextXmlLocation(String defaultContextXmlLocation) {
        this.defaultContextXmlLocation = defaultContextXmlLocation;
    }

    public String getDefaultWebXmlLocation() {
        return this.defaultWebXmlLocation;
    }

    public void setDefaultWebXmlLocation(String defaultWebXmlLocation) {
        this.defaultWebXmlLocation = defaultWebXmlLocation;
    }
}

