/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.coyote;

import com.sun.appserv.security.provider.ProxyHandler;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.ConnectionPool;
import com.sun.enterprise.config.serverbeans.HttpFileCache;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.KeepAlive;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.RequestProcessing;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.connector.coyote.PECoyoteResponse;
import com.sun.enterprise.web.connector.extension.GrizzlyConfig;
import com.sun.enterprise.web.connector.grizzly.DummyConnectorLauncher;
import com.sun.enterprise.web.pwc.connector.coyote.PwcCoyoteRequest;
import com.sun.grizzly.util.IntrospectionUtils;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Connector;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.connector.MapperListener;
import org.glassfish.security.common.CipherInfo;
import org.glassfish.web.admin.monitor.RequestProbeProvider;

public class PECoyoteConnector
extends org.apache.catalina.connector.Connector {
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static final String DEFAULT_TRUSTSTORE_TYPE = "JKS";
    private static final String DUMMY_CONNECTOR_LAUNCHER = DummyConnectorLauncher.class.getName();
    protected static final Logger _logger = LogDomains.getLogger(PECoyoteConnector.class, (String)"javax.enterprise.system.container.web");
    protected static final ResourceBundle _rb = _logger.getResourceBundle();
    protected boolean recycleObjects;
    protected int maxAcceptWorkerThreads;
    protected int maxReadWorkerThreads;
    protected int processorWorkerThreadsTimeout;
    protected int minProcessorWorkerThreadsIncrement;
    protected int minAcceptQueueLength;
    protected int minReadQueueLength;
    protected int minProcessorQueueLength;
    protected boolean useDirectByteBuffer;
    private boolean coyoteOn = false;
    private int keepAliveTimeoutInSeconds;
    private int keepAliveThreadCount;
    private boolean chunkingDisabled;
    private int queueSizeInBytes = 4096;
    protected int ssBackLog = 4096;
    public int selectorReadThreadsCount = 0;
    protected String defaultResponseType = "text/plain; charset=iso-8859-1";
    protected String forcedRequestType = "text/plain; charset=iso-8859-1";
    protected GrizzlyConfig grizzlyMonitor;
    private String rootFolder = "";
    private String name;
    private int secondsMaxAge = -1;
    private int maxCacheEntries = 1024;
    private long minEntrySize = 2048L;
    private long maxEntrySize = 537600L;
    private long maxLargeFileCacheSize = 0xA00000L;
    private long maxSmallFileCacheSize = 0x100000L;
    private boolean fileCacheEnabled = true;
    private boolean isLargeFileCacheEnabled = true;
    private String crlFile;
    private String trustAlgorithm;
    private String trustMaxCertLength;
    private WebContainer webContainer;
    private RequestProbeProvider requestProbeProvider;

    public PECoyoteConnector(WebContainer webContainer) {
        this.webContainer = webContainer;
        this.requestProbeProvider = webContainer.getRequestProbeProvider();
        this.setProtocolHandlerClassName(DUMMY_CONNECTOR_LAUNCHER);
    }

    public void setChunkingDisabled(boolean chunkingDisabled) {
        this.chunkingDisabled = chunkingDisabled;
    }

    public boolean isChunkingDisabled() {
        return this.chunkingDisabled;
    }

    public Request createRequest() {
        PwcCoyoteRequest request = new PwcCoyoteRequest();
        request.setConnector((Connector)this);
        return request;
    }

    public Response createResponse() {
        PECoyoteResponse response = new PECoyoteResponse(this.isChunkingDisabled());
        response.setConnector((Connector)this);
        return response;
    }

    public int getKeepAliveTimeoutInSeconds() {
        return this.keepAliveTimeoutInSeconds;
    }

    public void setKeepAliveTimeoutInSeconds(int timeout) {
        this.keepAliveTimeoutInSeconds = timeout;
        this.setProperty("keepAliveTimeoutInSeconds", String.valueOf(timeout));
    }

    public int getKeepAliveThreadCount() {
        return this.keepAliveThreadCount;
    }

    public void setKeepAliveThreadCount(int threadCount) {
        this.keepAliveThreadCount = threadCount;
        this.setProperty("keepAliveThreadCount", String.valueOf(threadCount));
    }

    public void setQueueSizeInBytes(int queueSizeInBytes) {
        this.queueSizeInBytes = queueSizeInBytes;
        this.setProperty("queueSizeInBytes", queueSizeInBytes);
    }

    public int getQueueSizeInBytes() {
        return this.queueSizeInBytes;
    }

    public void setSocketServerBacklog(int ssBackLog) {
        this.ssBackLog = ssBackLog;
        this.setProperty("socketServerBacklog", ssBackLog);
    }

    public int getSocketServerBacklog() {
        return this.ssBackLog;
    }

    public void setRecycleObjects(boolean recycleObjects) {
        this.recycleObjects = recycleObjects;
        this.setProperty("recycleObjects", String.valueOf(recycleObjects));
    }

    public boolean getRecycleObjects() {
        return this.recycleObjects;
    }

    public void setMaxReadWorkerThreads(int maxReadWorkerThreads) {
        this.maxReadWorkerThreads = maxReadWorkerThreads;
        this.setProperty("maxReadWorkerThreads", String.valueOf(maxReadWorkerThreads));
    }

    public int getMaxReadWorkerThreads() {
        return this.maxReadWorkerThreads;
    }

    public void setMaxAcceptWorkerThreads(int maxAcceptWorkerThreads) {
        this.maxAcceptWorkerThreads = maxAcceptWorkerThreads;
        this.setProperty("maxAcceptWorkerThreads", String.valueOf(maxAcceptWorkerThreads));
    }

    public int getMaxAcceptWorkerThreads() {
        return this.maxAcceptWorkerThreads;
    }

    public void setMinAcceptQueueLength(int minAcceptQueueLength) {
        this.minAcceptQueueLength = minAcceptQueueLength;
        this.setProperty("minAcceptQueueLength", String.valueOf(minAcceptQueueLength));
    }

    public int getMinAcceptQueueLength() {
        return this.minAcceptQueueLength;
    }

    public void setMinReadQueueLength(int minReadQueueLength) {
        this.minReadQueueLength = minReadQueueLength;
        this.setProperty("minReadQueueLength", String.valueOf(minReadQueueLength));
    }

    public int getMinReadQueueLength() {
        return this.minReadQueueLength;
    }

    public void setMinProcessorQueueLength(int minProcessorQueueLength) {
        this.minProcessorQueueLength = minProcessorQueueLength;
        this.setProperty("minProcessorQueueLength", String.valueOf(minProcessorQueueLength));
    }

    public int getMinProcessorQueueLength() {
        return this.minProcessorQueueLength;
    }

    public void setUseDirectByteBuffer(boolean useDirectByteBuffer) {
        this.useDirectByteBuffer = useDirectByteBuffer;
        this.setProperty("useDirectByteBuffer", String.valueOf(useDirectByteBuffer));
    }

    public boolean getUseDirectByteBuffer() {
        return this.useDirectByteBuffer;
    }

    public void setProcessorWorkerThreadsTimeout(int timeout) {
        this.processorWorkerThreadsTimeout = timeout;
        this.setProperty("processorWorkerThreadsTimeout", String.valueOf(timeout));
    }

    public int getProcessorWorkerThreadsTimeout() {
        return this.processorWorkerThreadsTimeout;
    }

    public void setProcessorWorkerThreadsIncrement(int increment) {
        this.minProcessorWorkerThreadsIncrement = increment;
        this.setProperty("processorThreadsIncrement", String.valueOf(increment));
    }

    public int getMinProcessorWorkerThreadsIncrement() {
        return this.minProcessorWorkerThreadsIncrement;
    }

    public void setSelectorReadThreadsCount(int selectorReadThreadsCount) {
        this.setProperty("selectorReadThreadsCount", String.valueOf(selectorReadThreadsCount));
    }

    public void setDefaultResponseType(String defaultResponseType) {
        this.defaultResponseType = defaultResponseType;
        this.setProperty("defaultResponseType", defaultResponseType);
    }

    public String getDefaultResponseType() {
        return this.defaultResponseType;
    }

    public void setForcedRequestType(String forcedResponseType) {
        this.forcedRequestType = forcedResponseType;
        this.setProperty("forcedRequestType", forcedResponseType);
    }

    public String getForcedRequestType() {
        return this.forcedRequestType;
    }

    public void start() throws LifecycleException {
        super.start();
        if (this.grizzlyMonitor != null) {
            this.grizzlyMonitor.initConfig();
            this.grizzlyMonitor.registerMonitoringLevelEvents();
        }
    }

    public void stop() throws LifecycleException {
        super.stop();
        if (this.grizzlyMonitor != null) {
            this.grizzlyMonitor.destroy();
            this.grizzlyMonitor = null;
        }
    }

    public void setSecondsMaxAge(int sMaxAges) {
        this.secondsMaxAge = sMaxAges;
        this.setProperty("secondsMaxAge", String.valueOf(this.secondsMaxAge));
    }

    public void setMaxCacheEntries(int mEntries) {
        this.maxCacheEntries = mEntries;
        this.setProperty("maxCacheEntries", String.valueOf(this.maxCacheEntries));
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMinEntrySize(long mSize) {
        this.minEntrySize = mSize;
        this.setProperty("minEntrySize", String.valueOf(this.minEntrySize));
    }

    public long getMinEntrySize() {
        return this.minEntrySize;
    }

    public void setMaxEntrySize(long mEntrySize) {
        this.maxEntrySize = mEntrySize;
        this.setProperty("maxEntrySize", String.valueOf(this.maxEntrySize));
    }

    public long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public void setMaxLargeCacheSize(long mCacheSize) {
        this.maxLargeFileCacheSize = mCacheSize;
        this.setProperty("maxLargeFileCacheSize", String.valueOf(this.maxLargeFileCacheSize));
    }

    public long getMaxLargeCacheSize() {
        return this.maxLargeFileCacheSize;
    }

    public void setMaxSmallCacheSize(long mCacheSize) {
        this.maxSmallFileCacheSize = mCacheSize;
        this.setProperty("maxSmallFileCacheSize", String.valueOf(this.maxSmallFileCacheSize));
    }

    public long getMaxSmallCacheSize() {
        return this.maxSmallFileCacheSize;
    }

    public boolean isFileCacheEnabled() {
        return this.fileCacheEnabled;
    }

    public void setFileCacheEnabled(boolean fileCacheEnabled) {
        this.fileCacheEnabled = fileCacheEnabled;
        this.setProperty("fileCacheEnabled", String.valueOf(fileCacheEnabled));
    }

    public void setLargeFileCacheEnabled(boolean isLargeEnabled) {
        this.isLargeFileCacheEnabled = isLargeEnabled;
        this.setProperty("largeFileCacheEnabled", String.valueOf(this.isLargeFileCacheEnabled));
    }

    public boolean getLargeFileCacheEnabled() {
        return this.isLargeFileCacheEnabled;
    }

    public void setWebAppRootPath(String rootFolder) {
        this.rootFolder = rootFolder;
        this.setProperty("webAppRootPath", rootFolder);
    }

    public String getWebAppRootPath() {
        return this.rootFolder;
    }

    public void initialize() throws LifecycleException {
        super.initialize();
        this.grizzlyMonitor = new GrizzlyConfig(this.webContainer, this.domain, this.getPort());
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setTruststore(String truststore) {
        this.setProperty("truststore", truststore);
    }

    public String getTruststore() {
        return (String)this.getProperty("truststore");
    }

    public void setTruststoreType(String type) {
        this.setProperty("truststoreType", type);
    }

    public String getTruststoreType() {
        return (String)this.getProperty("truststoreType");
    }

    public void setKeystoreType(String type) {
        this.setProperty("keystoreType", type);
    }

    public String getKeystoreType() {
        return (String)this.getProperty("keystoreType");
    }

    public String getCrlFile() {
        return this.crlFile;
    }

    public void setCrlFile(String crlFile) {
        this.crlFile = crlFile;
        this.setProperty("crlFile", crlFile);
    }

    public String getTrustAlgorithm() {
        return this.trustAlgorithm;
    }

    public void setTrustAlgorithm(String trustAlgorithm) {
        this.trustAlgorithm = trustAlgorithm;
        this.setProperty("truststoreAlgorithm", trustAlgorithm);
    }

    public String getTrustMaxCertLength() {
        return this.trustMaxCertLength;
    }

    public void setTrustMaxCertLength(String trustMaxCertLength) {
        this.trustMaxCertLength = trustMaxCertLength;
        this.setProperty("trustMaxCertLength", trustMaxCertLength);
    }

    public MapperListener getMapperListener() {
        return this.mapperListener;
    }

    public void configure(HttpListener httpListener, boolean isSecure, HttpService httpService) {
        String redirectPort;
        boolean blockingEnabled;
        this.configureConnectionPool(httpService.getConnectionPool());
        this.setDomain(this.webContainer.getServerContext().getDefaultDomainName());
        this.configureSSL(httpListener);
        this.configureKeepAlive(httpService.getKeepAlive());
        this.configureHttpProtocol(httpService.getHttpProtocol());
        this.configureRequestProcessing(httpService.getRequestProcessing());
        this.configureFileCache(httpService.getHttpFileCache());
        this.setDefaultHost(httpListener.getDefaultVirtualServer());
        this.setXpoweredBy(Boolean.valueOf(httpListener.getXpoweredBy()));
        this.setWebAppRootPath(this.webContainer.getModulesRoot().getAbsolutePath());
        String serverName = httpListener.getServerName();
        if (serverName != null && serverName.length() > 0) {
            if (serverName.startsWith("http://")) {
                serverName = serverName.substring("http://".length());
            } else if (serverName.startsWith("https://")) {
                serverName = serverName.substring("https://".length());
            }
            int index = serverName.indexOf(58);
            if (index != -1) {
                this.setProxyName(serverName.substring(0, index).trim());
                String serverPort = serverName.substring(index + 1).trim();
                if (serverPort.length() > 0) {
                    try {
                        this.setProxyPort(Integer.parseInt(serverPort));
                    }
                    catch (NumberFormatException nfe) {
                        _logger.log(Level.SEVERE, "pewebcontainer.invalid_proxy_port", new Object[]{serverPort, httpListener.getId()});
                    }
                }
            } else {
                this.setProxyName(serverName);
            }
        }
        if (blockingEnabled = Boolean.valueOf(httpListener.getBlockingEnabled()).booleanValue()) {
            this.setBlocking(blockingEnabled);
        }
        if ((redirectPort = httpListener.getRedirectPort()) != null && !redirectPort.equals("")) {
            try {
                this.setRedirectPort(Integer.parseInt(redirectPort));
            }
            catch (NumberFormatException nfe) {
                _logger.log(Level.WARNING, "pewebcontainer.invalid_redirect_port", new Object[]{redirectPort, httpListener.getId(), Integer.toString(this.getRedirectPort())});
            }
        } else {
            this.setRedirectPort(-1);
        }
        String acceptorThreads = httpListener.getAcceptorThreads();
        if (acceptorThreads != null) {
            try {
                this.setSelectorReadThreadsCount(Integer.parseInt(acceptorThreads));
            }
            catch (NumberFormatException nfe) {
                _logger.log(Level.WARNING, "pewebcontainer.invalid_acceptor_threads", new Object[]{acceptorThreads, httpListener.getId(), Integer.toString(this.getMaxProcessors())});
            }
        }
        if (isSecure) {
            this.configureKeysAndCerts();
        }
        this.webContainer.configureHttpServiceProperties(httpService, this);
        this.configureHttpListenerProperties(httpListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureJKProperties() {
        File propertiesFile;
        String propertiesURL = System.getProperty("com.sun.enterprise.web.connector.enableJK.propertyFile");
        if (propertiesURL == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("com.sun.enterprise.web.connector.enableJK.propertyFile not defined");
            }
            return;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Loading glassfish-jk.properties from " + propertiesURL);
        }
        if (!(propertiesFile = new File(propertiesURL)).exists()) {
            String msg = _rb.getString("pewebcontainer.missingJKProperties");
            msg = MessageFormat.format(msg, propertiesURL);
            _logger.log(Level.WARNING, msg);
            return;
        }
        Properties properties = null;
        InputStream is = null;
        try {
            FileInputStream fis = new FileInputStream(propertiesFile);
            is = new BufferedInputStream(fis);
            properties = new Properties();
            properties.load(is);
        }
        catch (Exception ex) {
            String msg = _rb.getString("pewebcontainer.configureJK");
            msg = MessageFormat.format(msg, this.getPort());
            _logger.log(Level.SEVERE, msg, ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = properties.getProperty(name);
            if (value == null) continue;
            IntrospectionUtils.setProperty((Object)((Object)this), (String)name, (String)value);
        }
    }

    public void configureConnectionPool(ConnectionPool cp) {
        String msg;
        if (cp == null) {
            return;
        }
        try {
            int queueSizeInBytes = Integer.parseInt(cp.getQueueSizeInBytes());
            if (queueSizeInBytes <= -1) {
                _logger.log(Level.WARNING, "pewebcontainer.invalidQueueSizeInBytes", new Object[]{cp.getQueueSizeInBytes(), Integer.toString(this.getQueueSizeInBytes())});
            } else {
                this.setQueueSizeInBytes(queueSizeInBytes);
            }
        }
        catch (NumberFormatException ex) {
            msg = _rb.getString("pewebcontainer.invalidQueueSizeInBytes");
            msg = MessageFormat.format(msg, ConfigBeansUtilities.getDefaultQueueSizeInBytes(), Integer.toString(this.getQueueSizeInBytes()));
            _logger.log(Level.WARNING, msg, ex);
        }
        try {
            int ssBackLog = Integer.parseInt(cp.getMaxPendingCount());
            if (ssBackLog <= 0) {
                _logger.log(Level.WARNING, "pewebcontainer.invalidMaxPendingCount", new Object[]{cp.getMaxPendingCount(), Integer.toString(this.getSocketServerBacklog())});
            } else {
                this.setSocketServerBacklog(ssBackLog);
            }
        }
        catch (NumberFormatException ex) {
            msg = _rb.getString("pewebcontainer.invalidMaxPendingCount");
            msg = MessageFormat.format(msg, cp.getMaxPendingCount(), Integer.toString(this.getSocketServerBacklog()));
            _logger.log(Level.WARNING, msg, ex);
        }
        try {
            int bufferSize = Integer.parseInt(cp.getReceiveBufferSizeInBytes());
            if (bufferSize <= 0) {
                _logger.log(Level.WARNING, "pewebcontainer.invalidBufferSize", new Object[]{cp.getReceiveBufferSizeInBytes(), Integer.toString(this.getBufferSize())});
            } else {
                this.setBufferSize(bufferSize);
            }
        }
        catch (NumberFormatException ex) {
            msg = _rb.getString("pewebcontainer.invalidBufferSize");
            msg = MessageFormat.format(msg, cp.getReceiveBufferSizeInBytes(), Integer.toString(this.getBufferSize()));
            _logger.log(Level.WARNING, msg, ex);
        }
        try {
            int maxHttpHeaderSize = Integer.parseInt(cp.getSendBufferSizeInBytes());
            if (maxHttpHeaderSize <= 0) {
                _logger.log(Level.WARNING, "pewebcontainer.invalidMaxHttpHeaderSize", new Object[]{cp.getSendBufferSizeInBytes(), Integer.toString(this.getMaxHttpHeaderSize())});
            } else {
                this.setMaxHttpHeaderSize(maxHttpHeaderSize);
            }
        }
        catch (NumberFormatException ex) {
            msg = _rb.getString("pewebcontainer.invalidMaxHttpHeaderSize");
            msg = MessageFormat.format(msg, cp.getSendBufferSizeInBytes(), Integer.toString(this.getMaxHttpHeaderSize()));
            _logger.log(Level.WARNING, msg, ex);
        }
    }

    public void configureHttpProtocol(HttpProtocol httpProtocol) {
        if (httpProtocol == null) {
            return;
        }
        this.setEnableLookups(Boolean.parseBoolean(httpProtocol.getDnsLookupEnabled()));
    }

    public void configureFileCache(HttpFileCache httpFileCache) {
        if (httpFileCache == null) {
            return;
        }
        this.setLargeFileCacheEnabled(ConfigBeansUtilities.toBoolean((String)httpFileCache.getFileCachingEnabled()));
        if (httpFileCache.getMaxAgeInSeconds() != null) {
            this.setSecondsMaxAge(Integer.parseInt(httpFileCache.getMaxAgeInSeconds()));
        }
        if (httpFileCache.getMaxFilesCount() != null) {
            this.setMaxCacheEntries(Integer.parseInt(httpFileCache.getMaxFilesCount()));
        }
        if (httpFileCache.getSmallFileSizeLimitInBytes() != null) {
            this.setMinEntrySize(Integer.parseInt(httpFileCache.getSmallFileSizeLimitInBytes()));
        }
        if (httpFileCache.getMediumFileSizeLimitInBytes() != null) {
            this.setMaxEntrySize(Integer.parseInt(httpFileCache.getMediumFileSizeLimitInBytes()));
        }
        if (httpFileCache.getMediumFileSpaceInBytes() != null) {
            this.setMaxLargeCacheSize(Integer.parseInt(httpFileCache.getMediumFileSpaceInBytes()));
        }
        if (httpFileCache.getSmallFileSpaceInBytes() != null) {
            this.setMaxSmallCacheSize(Integer.parseInt(httpFileCache.getSmallFileSpaceInBytes()));
        }
    }

    public void configureRequestProcessing(RequestProcessing rp) {
        if (rp == null) {
            return;
        }
        try {
            this.setMaxProcessors(Integer.parseInt(rp.getThreadCount()));
            this.setMinProcessors(Integer.parseInt(rp.getInitialThreadCount()));
            this.setProcessorWorkerThreadsTimeout(Integer.parseInt(rp.getRequestTimeoutInSeconds()));
            this.setProcessorWorkerThreadsIncrement(Integer.parseInt(rp.getThreadIncrement()));
            this.setMaxHttpHeaderSize(Integer.parseInt(rp.getHeaderBufferLengthInBytes()));
        }
        catch (NumberFormatException ex) {
            _logger.log(Level.WARNING, " Invalid request-processing attribute", ex);
        }
    }

    public void configureKeepAlive(KeepAlive keepAlive) {
        int timeoutInSeconds = 60;
        int maxConnections = 256;
        int threadCount = 1;
        if (keepAlive != null) {
            String msg;
            try {
                timeoutInSeconds = Integer.parseInt(keepAlive.getTimeoutInSeconds());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveTimeout");
                msg = MessageFormat.format(msg, keepAlive.getTimeoutInSeconds(), Integer.toString(timeoutInSeconds));
                _logger.log(Level.WARNING, msg, ex);
            }
            try {
                maxConnections = Integer.parseInt(keepAlive.getMaxConnections());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveMaxConnections");
                msg = MessageFormat.format(msg, keepAlive.getMaxConnections(), Integer.toString(maxConnections));
                _logger.log(Level.WARNING, msg, ex);
            }
            try {
                threadCount = Integer.parseInt(keepAlive.getThreadCount());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveThreadCount");
                msg = MessageFormat.format(msg, keepAlive.getThreadCount(), Integer.toString(threadCount));
                _logger.log(Level.WARNING, msg, ex);
            }
        }
        this.setKeepAliveTimeoutInSeconds(timeoutInSeconds);
        this.setMaxKeepAliveRequests(maxConnections);
        this.setKeepAliveThreadCount(threadCount);
    }

    public boolean configureHttpListenerProperty(String propName, String propValue) throws NumberFormatException {
        if ("bufferSize".equals(propName)) {
            this.setBufferSize(Integer.parseInt(propValue));
            return true;
        }
        if ("recycle-objects".equals(propName)) {
            this.setRecycleObjects(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("reader-threads".equals(propName)) {
            this.setMaxReadWorkerThreads(Integer.parseInt(propValue));
            return true;
        }
        if ("acceptor-queue-length".equals(propName)) {
            this.setMinAcceptQueueLength(Integer.parseInt(propValue));
            return true;
        }
        if ("reader-queue-length".equals(propName)) {
            this.setMinReadQueueLength(Integer.parseInt(propValue));
            return true;
        }
        if ("use-nio-direct-bytebuffer".equals(propName)) {
            this.setUseDirectByteBuffer(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("maxKeepAliveRequests".equals(propName)) {
            this.setMaxKeepAliveRequests(Integer.parseInt(propValue));
            return true;
        }
        if ("reader-selectors".equals(propName)) {
            this.setSelectorReadThreadsCount(Integer.parseInt(propValue));
            return true;
        }
        if ("authPassthroughEnabled".equals(propName)) {
            this.setAuthPassthroughEnabled(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("maxPostSize".equals(propName)) {
            this.setMaxPostSize(Integer.parseInt(propValue));
            return true;
        }
        if ("compression".equals(propName)) {
            this.setProperty("compression", propValue);
            return true;
        }
        if ("compressableMimeType".equals(propName)) {
            this.setProperty("compressableMimeType", propValue);
            return true;
        }
        if ("noCompressionUserAgents".equals(propName)) {
            this.setProperty("noCompressionUserAgents", propValue);
            return true;
        }
        if ("compressionMinSize".equals(propName)) {
            this.setProperty("compressionMinSize", propValue);
            return true;
        }
        if ("restrictedUserAgents".equals(propName)) {
            this.setProperty("restrictedUserAgents", propValue);
            return true;
        }
        if ("blocking".equals(propName)) {
            this.setBlocking(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("selectorThreadImpl".equals(propName)) {
            this.setSelectorThreadImpl(propValue);
            return true;
        }
        if ("cometSupport".equals(propName)) {
            this.setProperty(propName, ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("rcmSupport".equals(propName)) {
            this.setProperty(propName, ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("connectionUploadTimeout".equals(propName)) {
            this.setConnectionUploadTimeout(Integer.parseInt(propValue));
            return true;
        }
        if ("disableUploadTimeout".equals(propName)) {
            this.setDisableUploadTimeout(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("proxiedProtocols".equals(propName)) {
            this.setProperty(propName, propValue);
            return true;
        }
        if ("proxyHandler".equals(propName)) {
            this.setProxyHandler(propValue);
            return true;
        }
        if ("uriEncoding".equals(propName)) {
            this.setURIEncoding(propValue);
            return true;
        }
        if ("chunkingDisabled".equals(propName) || "chunking-disabled".equals(propName)) {
            this.setChunkingDisabled(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("crlFile".equals(propName)) {
            this.setCrlFile(propValue);
            return true;
        }
        if ("trustAlgorithm".equals(propName)) {
            this.setTrustAlgorithm(propValue);
            return true;
        }
        if ("trustMaxCertLength".equals(propName)) {
            this.setTrustMaxCertLength(propValue);
            return true;
        }
        return false;
    }

    public void setProxyHandler(String className) {
        Object handler = null;
        try {
            Class<?> handlerClass = Class.forName(className);
            handler = handlerClass.newInstance();
        }
        catch (Exception e) {
            String msg = _rb.getString("pewebcontainer.proxyHandlerClassLoadError");
            msg = MessageFormat.format(msg, className);
            _logger.log(Level.SEVERE, msg, e);
        }
        if (handler != null) {
            if (!(handler instanceof ProxyHandler)) {
                _logger.log(Level.SEVERE, "pewebcontainer.proxyHandlerClassInvalid", className);
            } else {
                this.setProxyHandler(handler);
            }
        }
    }

    public void requestStartEvent(HttpServletRequest request, HttpServletResponse response) {
        if (this.requestProbeProvider != null) {
            this.requestProbeProvider.requestStartEvent(request, response);
        }
    }

    public void requestEndEvent(HttpServletRequest request, HttpServletResponse response, int statusCode) {
        if (this.requestProbeProvider != null) {
            this.requestProbeProvider.requestEndEvent(request, response, statusCode);
        }
    }

    private void configureSSL(HttpListener httpListener) {
        String ciphers;
        Ssl sslConfig = httpListener.getSsl();
        if (sslConfig == null) {
            return;
        }
        if (Boolean.valueOf(sslConfig.getClientAuthEnabled()).booleanValue()) {
            this.setClientAuth(true);
        }
        StringBuffer sslProtocolsBuf = new StringBuffer();
        boolean needComma = false;
        if (Boolean.valueOf(sslConfig.getSsl2Enabled()).booleanValue()) {
            sslProtocolsBuf.append("SSLv2");
            needComma = true;
        }
        if (Boolean.valueOf(sslConfig.getSsl3Enabled()).booleanValue()) {
            if (needComma) {
                sslProtocolsBuf.append(", ");
            } else {
                needComma = true;
            }
            sslProtocolsBuf.append("SSLv3");
        }
        if (Boolean.valueOf(sslConfig.getTlsEnabled()).booleanValue()) {
            if (needComma) {
                sslProtocolsBuf.append(", ");
            }
            sslProtocolsBuf.append("TLSv1");
        }
        if (Boolean.valueOf(sslConfig.getSsl3Enabled()).booleanValue() || Boolean.valueOf(sslConfig.getTlsEnabled()).booleanValue()) {
            sslProtocolsBuf.append(", SSLv2Hello");
        }
        if (sslProtocolsBuf.length() == 0) {
            _logger.log(Level.WARNING, "pewebcontainer.all_ssl_protocols_disabled", httpListener.getId());
        } else {
            this.setSslProtocols(sslProtocolsBuf.toString());
        }
        String certNickname = sslConfig.getCertNickname();
        if (certNickname != null && certNickname.length() > 0) {
            this.setKeyAlias(sslConfig.getCertNickname());
        }
        if ((ciphers = sslConfig.getSsl3TlsCiphers()) != null) {
            String jsseCiphers = this.getJSSECiphers(ciphers);
            if (jsseCiphers == null) {
                _logger.log(Level.WARNING, "pewebcontainer.all_ciphers_disabled", httpListener.getId());
            } else {
                this.setCiphers(jsseCiphers);
            }
        }
    }

    private void configureKeysAndCerts() {
        String prop = System.getProperty("javax.net.ssl.keyStore");
        if (prop != null) {
            this.setKeystoreFile(prop);
            this.setKeystoreType("JKS");
        }
        if ((prop = System.getProperty("javax.net.ssl.trustStore")) != null) {
            this.setTruststore(prop);
            this.setTruststoreType("JKS");
        }
    }

    private void configureHttpListenerProperties(HttpListener httpListener) {
        for (Property httpListenerProp : httpListener.getProperty()) {
            String propValue;
            String propName = httpListenerProp.getName();
            if (this.configureHttpListenerProperty(propName, propValue = httpListenerProp.getValue())) continue;
            _logger.log(Level.WARNING, "pewebcontainer.invalid_http_listener_property", propName);
        }
    }

    private String getJSSECiphers(String ciphers) {
        String cipher = null;
        StringBuffer enabledCiphers = null;
        boolean first = true;
        int index = ciphers.indexOf(44);
        if (index != -1) {
            int fromIndex = 0;
            while (index != -1) {
                cipher = ciphers.substring(fromIndex, index).trim();
                if (cipher.length() > 0 && !cipher.startsWith("-")) {
                    String jsseCipher;
                    if (cipher.startsWith("+")) {
                        cipher = cipher.substring(1);
                    }
                    if ((jsseCipher = this.getJSSECipher(cipher)) == null) {
                        _logger.log(Level.WARNING, "pewebcontainer.unrecognized_cipher", cipher);
                    } else {
                        if (enabledCiphers == null) {
                            enabledCiphers = new StringBuffer();
                        }
                        if (!first) {
                            enabledCiphers.append(", ");
                        } else {
                            first = false;
                        }
                        enabledCiphers.append(jsseCipher);
                    }
                }
                fromIndex = index + 1;
                index = ciphers.indexOf(44, fromIndex);
            }
            cipher = ciphers.substring(fromIndex);
        } else {
            cipher = ciphers;
        }
        if (cipher != null && (cipher = cipher.trim()).length() > 0 && !cipher.startsWith("-")) {
            String jsseCipher;
            if (cipher.startsWith("+")) {
                cipher = cipher.substring(1);
            }
            if ((jsseCipher = this.getJSSECipher(cipher)) == null) {
                _logger.log(Level.WARNING, "pewebcontainer.unrecognized_cipher", cipher);
            } else {
                if (enabledCiphers == null) {
                    enabledCiphers = new StringBuffer();
                }
                if (!first) {
                    enabledCiphers.append(", ");
                } else {
                    first = false;
                }
                enabledCiphers.append(jsseCipher);
            }
        }
        return enabledCiphers == null ? null : enabledCiphers.toString();
    }

    private String getJSSECipher(String cipher) {
        String jsseCipher = null;
        CipherInfo ci = CipherInfo.getCipherInfo((String)cipher);
        if (ci != null) {
            jsseCipher = ci.getCipherName();
        }
        return jsseCipher;
    }
}

