/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.loader.util;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.web.WebApplication;
import com.sun.enterprise.web.WebContainer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Container;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.EngineRef;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASClassLoaderUtil {
    private static final Logger _logger = Logger.getAnonymousLogger();
    private static String modulesClassPath = null;

    public static String getWebModuleClassPath(Habitat habitat, String moduleId, String deploymentLibs) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ASClassLoaderUtil.getWebModuleClassPath for module Id : " + moduleId);
        }
        StringBuilder classpath = new StringBuilder(ASClassLoaderUtil.getModulesClasspath(habitat));
        ClassLoaderHierarchy clh = (ClassLoaderHierarchy)habitat.getByContract(ClassLoaderHierarchy.class);
        String commonClassPath = clh.getCommonClassPath();
        if (commonClassPath != null && commonClassPath.length() > 0) {
            classpath.append(commonClassPath).append(File.pathSeparator);
        }
        ASClassLoaderUtil.addLibrariesForWebModule(classpath, moduleId, deploymentLibs);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Final classpath: " + classpath.toString());
        }
        return classpath.toString();
    }

    private static void addLibrariesForWebModule(StringBuilder sb, String moduleId, String deploymentLibs) {
        if (moduleId != null) {
            URL[] libs;
            String specifiedLibraries = ASClassLoaderUtil.getLibrariesForModule(WebContainer.class, moduleId);
            if (specifiedLibraries == null && deploymentLibs != null) {
                specifiedLibraries = deploymentLibs;
            }
            if ((libs = ASClassLoaderUtil.getLibraries(specifiedLibraries)) != null) {
                for (URL u : libs) {
                    sb.append(u.getPath());
                    sb.append(File.pathSeparator);
                }
            }
        }
    }

    private static <T extends Container> String getLibrariesForModule(Class<T> type, String moduleId) {
        ApplicationInfo app = ((ApplicationRegistry)Globals.get(ApplicationRegistry.class)).get(moduleId);
        if (app == null) {
            return null;
        }
        Collection refs = app.getEngineRefsForContainer(type);
        if (refs != null) {
            StringBuffer result = new StringBuffer();
            for (EngineRef ref : refs) {
                String lib;
                WebApplication webApp = (WebApplication)ref.getApplicationContainer();
                if (result.length() > 0) {
                    result.append(",");
                }
                if ((lib = webApp.getLibraries()) == null) continue;
                result.append(lib);
            }
            return result.toString();
        }
        _logger.log(Level.SEVERE, "No web module loaded for this application " + moduleId);
        return null;
    }

    private static URL[] getLibraries(String librariesStr) {
        if (librariesStr == null) {
            return null;
        }
        String[] librariesStrArray = librariesStr.split(",");
        if (librariesStrArray == null) {
            return null;
        }
        URL[] urls = new URL[librariesStrArray.length];
        String appLibsDir = System.getProperty("com.sun.aas.instanceRoot") + File.separator + "lib" + File.separator + "applibs";
        int i = 0;
        for (String libraryStr : librariesStrArray) {
            try {
                File f = new File(libraryStr);
                if (!f.isAbsolute()) {
                    f = new File(appLibsDir, libraryStr);
                }
                URL url = f.toURI().toURL();
                urls[i++] = url;
            }
            catch (MalformedURLException malEx) {
                _logger.log(Level.WARNING, "loader.cannot_convert_classpath_into_url", libraryStr);
                _logger.log(Level.WARNING, "loader.exception", malEx);
            }
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String getModulesClasspath(Habitat habitat) {
        Class<ASClassLoaderUtil> clazz = ASClassLoaderUtil.class;
        synchronized (ASClassLoaderUtil.class) {
            if (modulesClassPath == null) {
                StringBuilder tmpString = new StringBuilder();
                ModulesRegistry mr = (ModulesRegistry)habitat.getComponent(ModulesRegistry.class);
                if (mr != null) {
                    for (Module module : mr.getModules()) {
                        for (URI uri : module.getModuleDefinition().getLocations()) {
                            tmpString.append(uri.getPath());
                            tmpString.append(File.pathSeparator);
                        }
                    }
                }
                modulesClassPath = tmpString.toString();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return modulesClassPath;
        }
    }
}

