/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.WebArchivist;
import com.sun.enterprise.security.web.SingleSignOn;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.PEAccessLogValve;
import com.sun.enterprise.web.SSOFactory;
import com.sun.enterprise.web.VirtualServerPipeline;
import com.sun.enterprise.web.WebDeployer;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.pluggable.WebContainerFeatureFactory;
import com.sun.enterprise.web.stats.PWCRequestStatsImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.logger.FileLogger;
import org.apache.catalina.valves.RemoteAddrValve;
import org.apache.catalina.valves.RemoteHostValve;
import org.glassfish.api.admin.config.Property;
import org.glassfish.internal.api.Globals;
import org.glassfish.web.loader.WebappClassLoader;
import org.glassfish.web.valve.GlassFishValve;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualServer
extends StandardHost {
    public static final String ADMIN_VS = "__asadmin";
    private static final String STATE = "state";
    private static final String SSO_MAX_IDLE = "sso-max-inactive-seconds";
    private static final String SSO_REAP_INTERVAL = "sso-reap-interval-seconds";
    private static final String SSO_COOKIE_SECURE = "ssoCookieSecure";
    private static final String DISABLED = "disabled";
    private static final String OFF = "off";
    private static final String ON = "on";
    private VirtualServerPipeline vsPipeline;
    private Pipeline origPipeline = this.pipeline;
    private String _id = null;
    protected static final Logger _logger = LogDomains.getLogger(VirtualServer.class, (String)"javax.enterprise.system.container.web");
    protected static final ResourceBundle rb = _logger.getResourceBundle();
    protected boolean _debug = false;
    private static final String _info = "com.sun.enterprise.web.VirtualServer/1.0";
    private com.sun.enterprise.config.serverbeans.VirtualServer vsBean;
    private MimeMap mimeMap;
    private boolean allowLinking = false;
    private String defaultContextXmlLocation;
    private String defaultWebXmlLocation;
    private String[] cacheControls;
    private boolean isActive;
    private PWCRequestStatsImpl pwcRequestStatsImpl;
    private String authRealmName;
    private PEAccessLogValve accessLogValve;
    private String ssoCookieSecure = null;
    private String defaultContextPath = null;

    public VirtualServer() {
        this.vsPipeline = new VirtualServerPipeline(this);
        this.accessLogValve = new PEAccessLogValve();
        this.accessLogValve.setContainer((Container)this);
        this._debug = _logger.isLoggable(Level.FINE);
    }

    public String getID() {
        return this._id;
    }

    public void setID(String id) {
        this._id = id;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
        if (isActive) {
            this.vsPipeline.setIsDisabled(false);
            this.vsPipeline.setIsOff(false);
            if (this.pipeline == this.vsPipeline && !this.vsPipeline.hasRedirects()) {
                this.setPipeline(this.origPipeline);
            }
        }
    }

    public String getDefaultContextXmlLocation() {
        return this.defaultContextXmlLocation;
    }

    public void setDefaultContextXmlLocation(String defaultContextXmlLocation) {
        this.defaultContextXmlLocation = defaultContextXmlLocation;
    }

    public String getDefaultWebXmlLocation() {
        return this.defaultWebXmlLocation;
    }

    public void setDefaultWebXmlLocation(String defaultWebXmlLocation) {
        this.defaultWebXmlLocation = defaultWebXmlLocation;
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public com.sun.enterprise.config.serverbeans.VirtualServer getBean() {
        return this.vsBean;
    }

    public void setBean(com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        this.vsBean = vsBean;
    }

    public MimeMap getMimeMap() {
        return this.mimeMap;
    }

    public void setMimeMap(MimeMap mimeMap) {
        this.mimeMap = mimeMap;
    }

    public String[] getCacheControls() {
        return this.cacheControls;
    }

    public void setCacheControls(String[] cacheControls) {
        this.cacheControls = cacheControls;
    }

    public String getInfo() {
        return _info;
    }

    public void setDefaultContextPath(String defaultContextPath) {
        this.defaultContextPath = defaultContextPath;
    }

    public Container findChild(String contextRoot) {
        if (this.defaultContextPath != null && "/".equals(contextRoot)) {
            return super.findChild(this.defaultContextPath);
        }
        return super.findChild(contextRoot);
    }

    public void configureSingleSignOnCookieSecure(Cookie ssoCookie, HttpServletRequest hreq) {
        super.configureSingleSignOnCookieSecure(ssoCookie, hreq);
        if (this.ssoCookieSecure != null && !this.ssoCookieSecure.equals("dynamic")) {
            ssoCookie.setSecure(Boolean.parseBoolean(this.ssoCookieSecure));
        }
    }

    public synchronized void stop() throws LifecycleException {
        super.stop();
    }

    public synchronized void addValve(GlassFishValve valve) {
        super.addValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.addValve(valve);
        } else {
            this.vsPipeline.addValve(valve);
        }
    }

    public synchronized void addValve(Valve valve) {
        super.addValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.addValve(valve);
        } else {
            this.vsPipeline.addValve(valve);
        }
    }

    public synchronized void removeValve(GlassFishValve valve) {
        super.removeValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.removeValve(valve);
        } else {
            this.vsPipeline.removeValve(valve);
        }
    }

    protected String getDefaultContextPath(Domain domain, WebDeployer webDeployer) {
        String contextRoot = null;
        String wmID = this.getDefaultWebModuleID();
        if (wmID != null) {
            Applications appsBean = domain.getApplications();
            WebModuleConfig wmInfo = this.findWebModuleInJ2eeApp(appsBean, wmID);
            if (wmInfo == null) {
                contextRoot = ConfigBeansUtilities.getContextRoot((String)wmID);
            } else {
                WebModule wm = wmInfo.getBean();
                contextRoot = wm.getContextRoot();
            }
            if (contextRoot == null) {
                Object[] params = new Object[]{wmID, this.getID()};
                _logger.log(Level.SEVERE, "vs.defaultWebModuleNotFound", params);
            }
        }
        return contextRoot;
    }

    protected WebModuleConfig getDefaultWebModule(Domain domain, WebArchivist webArchivist) {
        String contextRoot = null;
        WebModuleConfig wmInfo = null;
        String wmID = this.getDefaultWebModuleID();
        if (wmID != null) {
            Applications appsBean = domain.getApplications();
            wmInfo = this.findWebModuleInJ2eeApp(appsBean, wmID);
            if (wmInfo == null) {
                contextRoot = ConfigBeansUtilities.getContextRoot((String)wmID);
                String location = ConfigBeansUtilities.getLocation((String)wmID);
                if (contextRoot != null && location != null) {
                    File docroot = new File(location);
                    WebBundleDescriptor wbd = webArchivist.getDefaultBundleDescriptor();
                    wmInfo = new WebModuleConfig();
                    wbd.setName("__default-web-module");
                    wbd.setContextRoot(contextRoot);
                    wmInfo.setLocation(docroot);
                    wmInfo.setDescriptor(wbd);
                    wmInfo.setParentLoader(EmbeddedWebContainer.class.getClassLoader());
                    wmInfo.setAppClassLoader((ClassLoader)new WebappClassLoader(wmInfo.getParentLoader()));
                }
            }
            if (wmInfo == null) {
                Object[] params = new Object[]{wmID, this.getID()};
                _logger.log(Level.SEVERE, "vs.defaultWebModuleNotFound", params);
            }
        }
        return wmInfo;
    }

    protected WebModuleConfig createSystemDefaultWebModuleIfNecessary(WebArchivist webArchivist) {
        WebModuleConfig wmInfo = null;
        String docroot = this.getAppBase();
        if (this.getDefaultWebModuleID() == null && this.findChild("") == null && docroot != null) {
            WebBundleDescriptor wbd = webArchivist.getDefaultBundleDescriptor();
            wmInfo = new WebModuleConfig();
            wbd.setModuleID("__default-web-module");
            wbd.setContextRoot("");
            wmInfo.setLocation(new File(docroot));
            wmInfo.setDescriptor(wbd);
            wmInfo.setParentLoader(EmbeddedWebContainer.class.getClassLoader());
            wmInfo.setAppClassLoader((ClassLoader)new WebappClassLoader(wmInfo.getParentLoader()));
            if (wbd.getApplication() == null) {
                Application application = new Application(Globals.getDefaultHabitat());
                application.setVirtual(true);
                application.setName("__default-web-module");
                wbd.setApplication(application);
            }
        }
        return wmInfo;
    }

    protected WebModuleConfig loadWebModuleConfig(WebModule wm) {
        WebModuleConfig wmInfo = new WebModuleConfig();
        wmInfo.setBean(wm);
        String wmID = wm.getName();
        String location = wm.getLocation();
        return wmInfo;
    }

    private boolean isActive(WebModule wm) {
        return this.isActive(wm, true);
    }

    protected boolean isActive(WebModule wm, boolean matchVSID) {
        String vsID = this.getID();
        boolean active = vsID != null && vsID.length() > 0;
        if (active &= wm != null) {
            List vsList;
            active &= Boolean.valueOf(wm.getEnabled()).booleanValue();
            String vsIDs = this.getVirtualServers(wm.getName());
            if (this.getID().equals(ADMIN_VS) && matchVSID && (vsIDs == null || vsIDs.length() == 0)) {
                return false;
            }
            active = matchVSID && vsIDs != null && vsIDs.length() > 0 ? ((vsList = StringUtils.parseStringList((String)vsIDs, (String)" ,")) != null ? (active &= vsList.contains(vsID.trim())) : (active &= true)) : (active &= true);
        }
        return active;
    }

    protected String getDefaultWebModuleID() {
        String wmID = null;
        if (this.vsBean != null) {
            wmID = this.vsBean.getDefaultWebModule();
            if (wmID != null && wmID.equals("")) {
                wmID = null;
            }
            if (wmID != null && this._debug) {
                Object[] params = new Object[]{wmID, this._id};
                _logger.log(Level.FINE, "vs.defaultWebModule", params);
            }
        } else {
            _logger.log(Level.SEVERE, "vs.configError", this._id);
        }
        return wmID;
    }

    protected WebModuleConfig findWebModuleInJ2eeApp(Applications appsBean, String id) {
        WebModuleConfig wmInfo = null;
        return wmInfo;
    }

    private String getVirtualServers(String appName) {
        String ret = null;
        Server server = (Server)Globals.getDefaultHabitat().getComponent(Server.class);
        for (ApplicationRef appRef : server.getApplicationRef()) {
            if (!appRef.getRef().equals(appName)) continue;
            return appRef.getVirtualServers();
        }
        return ret;
    }

    public void clearAliases() {
        this.aliases = new String[0];
    }

    private void setIsDisabled(boolean isDisabled) {
        this.vsPipeline.setIsDisabled(isDisabled);
        this.vsPipeline.setIsOff(false);
        if (isDisabled && this.pipeline != this.vsPipeline) {
            this.setPipeline((Pipeline)this.vsPipeline);
        }
    }

    private void setIsOff(boolean isOff) {
        this.vsPipeline.setIsOff(isOff);
        this.vsPipeline.setIsDisabled(false);
        if (isOff && this.pipeline != this.vsPipeline) {
            this.setPipeline((Pipeline)this.vsPipeline);
        }
    }

    List<Property> getProperties() {
        if (this.vsBean != null) {
            return this.vsBean.getProperty();
        }
        return null;
    }

    public void setPWCRequestStatsImpl(PWCRequestStatsImpl pwcRequestStatsImpl) {
        this.pwcRequestStatsImpl = pwcRequestStatsImpl;
    }

    public PWCRequestStatsImpl getPWCRequestStatsImpl() {
        return this.pwcRequestStatsImpl;
    }

    public void configure(String vsID, com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String vsDocroot, String vsLogFile, MimeMap vsMimeMap, String logServiceFile) {
        this.setDebug(this.debug);
        this.setAppBase(vsDocroot);
        this.setName(vsID);
        this.setID(vsID);
        this.setBean(vsBean);
        this.setMimeMap(vsMimeMap);
        String defaultContextXmlLocation = "config/context.xml";
        String defaultWebXmlLocation = "config/default-web.xml";
        boolean allowLinking = false;
        String state = null;
        if (vsBean != null) {
            state = vsBean.getState();
            Property prop = vsBean.getProperty("default-web-xml");
            if (prop != null) {
                defaultWebXmlLocation = prop.getValue();
            }
            if ((prop = vsBean.getProperty("allowLinking")) != null) {
                allowLinking = Boolean.parseBoolean(prop.getValue());
            }
            if ((prop = vsBean.getProperty("contextXmlDefault")) != null) {
                defaultContextXmlLocation = prop.getValue();
            }
        }
        this.setDefaultWebXmlLocation(defaultWebXmlLocation);
        this.setDefaultContextXmlLocation(defaultContextXmlLocation);
        if (state == null) {
            state = ON;
        }
        if (DISABLED.equalsIgnoreCase(state)) {
            this.setIsActive(false);
        } else {
            this.setIsActive(Boolean.parseBoolean(state));
        }
        this.setAllowLinking(allowLinking);
        if (vsLogFile != null && !vsLogFile.equals(logServiceFile)) {
            this.setLogFile(vsLogFile);
        }
    }

    protected void configureCatalinaProperties() {
        List props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                _logger.log(Level.WARNING, "webcontainer.nullWebModuleProperty", this.getName());
            }
            if (propName.startsWith("valve_")) {
                this.addValve(propValue);
                continue;
            }
            if (propName.startsWith("listener_")) {
                this.addListener(propValue);
                continue;
            }
            if (!propName.equals("securePagesWithPragma")) continue;
            this.setSecurePagesWithPragma(Boolean.valueOf(propValue));
        }
    }

    void setLogFile(String logFile) {
        String logPrefix = logFile;
        String logDir = null;
        String logSuffix = null;
        if (logPrefix == null || logPrefix.equals("")) {
            return;
        }
        int index = logPrefix.lastIndexOf(File.separatorChar);
        if (index != -1) {
            logDir = logPrefix.substring(0, index);
            logPrefix = logPrefix.substring(index + 1);
        }
        if ((index = logPrefix.indexOf(46)) != -1) {
            logSuffix = logPrefix.substring(index);
            logPrefix = logPrefix.substring(0, index);
        }
        logPrefix = logPrefix + "_";
        FileLogger contextLogger = new FileLogger();
        if (logDir != null) {
            contextLogger.setDirectory(logDir);
        }
        contextLogger.setPrefix(logPrefix);
        if (logSuffix != null) {
            contextLogger.setSuffix(logSuffix);
        }
        contextLogger.setTimestamp(true);
        this.setLogger((org.apache.catalina.Logger)contextLogger);
    }

    void configureAliases() {
        List hosts = StringUtils.parseStringList((String)this.vsBean.getHosts(), (String)",");
        for (int i = 0; i < hosts.size(); ++i) {
            String alias = hosts.get(i).toString();
            if (alias.equalsIgnoreCase("localhost.localdomain")) continue;
            this.addAlias(alias);
        }
    }

    void configureAuthRealm(SecurityService securityService) {
        List properties = this.vsBean.getProperty();
        if (properties != null && properties.size() > 0) {
            for (Property p : properties) {
                if (p == null || !"authRealm".equals(p.getName())) continue;
                this.authRealmName = p.getValue();
                if (this.authRealmName == null) break;
                AuthRealm realm = null;
                List rs = securityService.getAuthRealm();
                if (rs != null && rs.size() > 0) {
                    for (AuthRealm r : rs) {
                        if (r == null || !r.getName().equals(this.authRealmName)) continue;
                        realm = r;
                        break;
                    }
                }
                if (realm != null) break;
                _logger.log(Level.SEVERE, "vs.invalidAuthRealm", new Object[]{this.getID(), this.authRealmName});
                break;
            }
        }
    }

    String getAuthRealmName() {
        return this.authRealmName;
    }

    protected void addValve(String valveName) {
        Object valve = this.loadInstance(valveName);
        if (valve instanceof Valve) {
            this.addValve((Valve)valve);
        } else if (valve instanceof GlassFishValve) {
            this.addValve((GlassFishValve)valve);
        } else {
            _logger.log(Level.WARNING, "Object of type classname " + valveName + " not an instance of Valve or GlassFishValve");
        }
    }

    protected void addListener(String listenerName) {
        Object listener = this.loadInstance(listenerName);
        if (listener == null) {
            return;
        }
        if (listener instanceof ContainerListener) {
            this.addContainerListener((ContainerListener)listener);
        } else if (listener instanceof LifecycleListener) {
            this.addLifecycleListener((LifecycleListener)listener);
        } else {
            _logger.log(Level.SEVERE, "webcontainer.invalidListener" + listenerName);
        }
    }

    private Object loadInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.newInstance();
        }
        catch (Throwable ex) {
            _logger.log(Level.SEVERE, "webcontainer.unableToLoadExtension", ex);
            return null;
        }
    }

    void configureErrorPage() {
        ErrorPage errorPage = null;
        if (this.vsBean == null) {
            return;
        }
        List props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                _logger.log(Level.WARNING, "webcontainer.nullVirtualServerProperty", this.getID());
                continue;
            }
            if (!propName.startsWith("send-error_")) continue;
            String path = null;
            String reason = null;
            String status = null;
            String[] errorParams = propValue.split(" ");
            for (int j = 0; j < errorParams.length; ++j) {
                if (errorParams[j].startsWith("path=")) {
                    if (path != null) {
                        _logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, "path"});
                    }
                    path = errorParams[j].substring("path=".length());
                }
                if (errorParams[j].startsWith("reason=")) {
                    if (reason != null) {
                        _logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, "reason"});
                    }
                    reason = errorParams[j].substring("reason=".length());
                }
                if (!errorParams[j].startsWith("code=")) continue;
                if (status != null) {
                    _logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, "code"});
                }
                status = errorParams[j].substring("code=".length());
            }
            if (path == null || path.length() == 0) {
                _logger.log(Level.WARNING, "webcontainer.sendErrorMissingPath", propValue);
            }
            errorPage = new ErrorPage();
            errorPage.setLocation(path);
            errorPage.setErrorCode(status);
            errorPage.setReason(reason);
            this.addErrorPage(errorPage);
        }
    }

    void configureRedirect() {
        this.vsPipeline.clearRedirects();
        if (this.vsBean == null) {
            return;
        }
        List props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                _logger.log(Level.WARNING, "webcontainer.nullVirtualServerProperty", this.getID());
                continue;
            }
            if (!propName.startsWith("redirect_")) continue;
            String from = null;
            String url = null;
            String urlPrefix = null;
            String escape = null;
            String[] redirectParams = propValue.split(" ");
            for (int j = 0; j < redirectParams.length; ++j) {
                if (redirectParams[j].startsWith("from=")) {
                    if (from != null) {
                        _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "from"});
                    }
                    from = redirectParams[j].substring("from=".length());
                }
                if (redirectParams[j].startsWith("url=")) {
                    if (url != null) {
                        _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "url"});
                    }
                    url = redirectParams[j].substring("url=".length());
                }
                if (redirectParams[j].startsWith("url-prefix=")) {
                    if (urlPrefix != null) {
                        _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "url-prefix"});
                    }
                    urlPrefix = redirectParams[j].substring("url-prefix=".length());
                }
                if (!redirectParams[j].startsWith("escape=")) continue;
                if (escape != null) {
                    _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "escape"});
                }
                escape = redirectParams[j].substring("escape=".length());
            }
            if (from == null || from.length() == 0) {
                _logger.log(Level.WARNING, "webcontainer.redirectMissingFrom", propValue);
            }
            if (!(url != null && url.length() != 0 || urlPrefix != null && urlPrefix.length() != 0)) {
                _logger.log(Level.WARNING, "webcontainer.redirectMissingUrlOrUrlPrefix", propValue);
            }
            if (url != null && url.length() > 0 && urlPrefix != null && urlPrefix.length() > 0) {
                _logger.log(Level.WARNING, "webcontainer.redirectBothUrlAndUrlPrefix", propValue);
            }
            boolean escapeURI = true;
            if (escape != null) {
                if ("yes".equalsIgnoreCase(escape)) {
                    escapeURI = true;
                } else if ("no".equalsIgnoreCase(escape)) {
                    escapeURI = false;
                } else {
                    _logger.log(Level.WARNING, "webcontainer.redirectInvalidEscape", propValue);
                }
            }
            this.vsPipeline.addRedirect(from, url, urlPrefix, escapeURI);
        }
        if (this.vsPipeline.hasRedirects()) {
            if (this.pipeline != this.vsPipeline) {
                this.setPipeline((Pipeline)this.vsPipeline);
            }
        } else if (this.isActive && this.pipeline != this.origPipeline) {
            this.setPipeline(this.origPipeline);
        }
    }

    void configureSingleSignOn(boolean globalSSOEnabled, WebContainerFeatureFactory webContainerFeatureFactory) {
        if (this.vsBean == null) {
            return;
        }
        if (!this.isSSOEnabled(globalSSOEnabled)) {
            if (_logger.isLoggable(Level.FINE)) {
                Object[] params = new Object[]{this.getID()};
                _logger.log(Level.FINE, "webcontainer.ssodisabled", params);
            }
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                this.removeValve(valves[i]);
                break;
            }
        } else {
            try {
                Property expireTime;
                SSOFactory ssoFactory = webContainerFeatureFactory.getSSOFactory();
                SingleSignOn sso = ssoFactory.createSingleSignOnValve(this.getName());
                Property idle = this.vsBean.getProperty(SSO_MAX_IDLE);
                if (idle != null && idle.getValue() != null) {
                    _logger.fine("SSO entry max idle time set to: " + idle.getValue());
                    int i = Integer.parseInt(idle.getValue());
                    sso.setMaxInactive(i);
                }
                if ((expireTime = this.vsBean.getProperty(SSO_REAP_INTERVAL)) != null && expireTime.getValue() != null) {
                    _logger.fine("SSO expire thread interval set to : " + expireTime.getValue());
                    int i = Integer.parseInt(expireTime.getValue());
                    sso.setReapInterval(i);
                }
                GlassFishValve[] valves = this.getValves();
                for (int i = 0; valves != null && i < valves.length; ++i) {
                    if (!(valves[i] instanceof SingleSignOn)) continue;
                    this.removeValve(valves[i]);
                    break;
                }
                this.addValve((GlassFishValve)sso);
                this.configureSingleSignOnCookieSecure();
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "webcontainer.ssobadconfig", e);
                _logger.log(Level.WARNING, "webcontainer.ssodisabled", this.getID());
            }
        }
    }

    void configureState() {
        String stateValue = ON;
        if (this.vsBean != null) {
            stateValue = this.vsBean.getState();
        }
        if (!stateValue.equalsIgnoreCase(ON) && this.getName().equalsIgnoreCase(ADMIN_VS)) {
            throw new IllegalArgumentException("virtual-server __asadmin state property cannot be modified");
        }
        if (stateValue.equalsIgnoreCase(DISABLED)) {
            this.setIsDisabled(true);
        } else if (!ConfigBeansUtilities.toBoolean((String)stateValue)) {
            this.setIsOff(true);
        } else {
            this.setIsActive(true);
        }
    }

    void configureRemoteAddressFilterValve() {
        RemoteAddrValve remoteAddrValve = null;
        if (this.vsBean == null) {
            return;
        }
        Property allow = this.vsBean.getProperty("allowRemoteAddress");
        Property deny = this.vsBean.getProperty("denyRemoteAddress");
        if (allow != null && allow.getValue() != null || deny != null && deny.getValue() != null) {
            remoteAddrValve = new RemoteAddrValve();
        }
        if (allow != null && allow.getValue() != null) {
            _logger.fine("Allowing access to " + this.getID() + " from " + allow.getValue());
            remoteAddrValve.setAllow(allow.getValue());
        }
        if (deny != null && deny.getValue() != null) {
            _logger.fine("Denying access to " + this.getID() + " from " + deny.getValue());
            remoteAddrValve.setDeny(deny.getValue());
        }
        if (remoteAddrValve != null) {
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteAddrValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve((GlassFishValve)remoteAddrValve);
        }
    }

    void configureRemoteHostFilterValve(HttpProtocol httpProtocol) {
        RemoteHostValve remoteHostValve = null;
        if (this.vsBean == null) {
            return;
        }
        Property allow = this.vsBean.getProperty("allowRemoteHost");
        Property deny = this.vsBean.getProperty("denyRemoteHost");
        if (allow != null && allow.getValue() != null || deny != null && deny.getValue() != null) {
            remoteHostValve = new RemoteHostValve();
        }
        if (allow != null && allow.getValue() != null) {
            _logger.fine("Allowing access to " + this.getID() + " from " + allow.getValue());
            if (httpProtocol == null || !Boolean.valueOf(httpProtocol.getDnsLookupEnabled()).booleanValue()) {
                _logger.log(Level.WARNING, "webcontainer.allowRemoteHost.dnsLookupDisabled", this.getID());
            }
            remoteHostValve.setAllow(allow.getValue());
        }
        if (deny != null && deny.getValue() != null) {
            _logger.fine("Denying access to " + this.getID() + " from " + deny.getValue());
            if (httpProtocol == null || !Boolean.valueOf(httpProtocol.getDnsLookupEnabled()).booleanValue()) {
                _logger.log(Level.WARNING, "webcontainer.denyRemoteHost.dnsLookupDisabled", this.getID());
            }
            remoteHostValve.setDeny(deny.getValue());
        }
        if (remoteHostValve != null) {
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteHostValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve((GlassFishValve)remoteHostValve);
        }
    }

    void reconfigureAccessLog(String globalAccessLogBufferSize, String globalAccessLogWriteInterval, Habitat habitat, Domain domain, boolean globalAccessLoggingEnabled) {
        try {
            boolean start;
            if (this.accessLogValve.isStarted()) {
                this.accessLogValve.stop();
            }
            if ((start = this.accessLogValve.updateVirtualServerProperties(this.vsBean.getId(), this.vsBean, domain, habitat, globalAccessLogBufferSize, globalAccessLogWriteInterval)) && this.isAccessLoggingEnabled(globalAccessLoggingEnabled)) {
                this.enableAccessLogging();
            } else {
                this.disableAccessLogging();
            }
        }
        catch (LifecycleException le) {
            _logger.log(Level.SEVERE, "pewebcontainer.accesslog.reconfigure", le);
        }
    }

    void reconfigureAccessLog(HttpService httpService, WebContainerFeatureFactory webcontainerFeatureFactory) {
        try {
            boolean restart = false;
            if (this.accessLogValve.isStarted()) {
                this.accessLogValve.stop();
                restart = true;
            }
            this.accessLogValve.updateAccessLogAttributes(httpService, webcontainerFeatureFactory);
            if (restart) {
                this.accessLogValve.start();
            }
        }
        catch (LifecycleException le) {
            _logger.log(Level.SEVERE, "pewebcontainer.accesslog.reconfigure", le);
        }
    }

    PEAccessLogValve getAccessLogValve() {
        return this.accessLogValve;
    }

    void enableAccessLogging() {
        if (!this.isAccessLogValveActivated()) {
            this.addValve((GlassFishValve)this.accessLogValve);
        } else {
            try {
                if (this.accessLogValve.isStarted()) {
                    this.accessLogValve.stop();
                }
                this.accessLogValve.start();
            }
            catch (LifecycleException le) {
                _logger.log(Level.SEVERE, "pewebcontainer.accesslog.reconfigure", le);
            }
        }
    }

    void disableAccessLogging() {
        this.removeValve((GlassFishValve)this.accessLogValve);
    }

    private boolean isAccessLogValveActivated() {
        GlassFishValve[] valves;
        Pipeline p = this.getPipeline();
        if (p != null && (valves = p.getValves()) != null) {
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof PEAccessLogValve)) continue;
                return true;
            }
        }
        return false;
    }

    void configureCacheControl(String cacheControl) {
        List values;
        if (cacheControl != null && (values = StringUtils.parseStringList((String)cacheControl, (String)",")) != null && !values.isEmpty()) {
            String[] cacheControls = new String[values.size()];
            this.setCacheControls(values.toArray(cacheControls));
        }
    }

    private boolean isSSOEnabled(boolean globalSSOEnabled) {
        if (this.vsBean == null) {
            return false;
        }
        Property ssoProperty = this.vsBean.getProperty("sso-enabled");
        if (ssoProperty == null || ssoProperty.getValue() == null) {
            return globalSSOEnabled;
        }
        return ConfigBeansUtilities.toBoolean((String)ssoProperty.getValue());
    }

    boolean isAccessLoggingEnabled(boolean globalAccessLoggingEnabled) {
        if (this.vsBean == null) {
            return false;
        }
        Property prop = this.vsBean.getProperty("accessLoggingEnabled");
        if (prop == null || prop.getValue() == null) {
            return globalAccessLoggingEnabled;
        }
        return ConfigBeansUtilities.toBoolean((String)prop.getValue());
    }

    private void configureSingleSignOnCookieSecure() {
        if (this.vsBean == null) {
            return;
        }
        Property prop = this.vsBean.getProperty(SSO_COOKIE_SECURE);
        if (prop != null) {
            String propValue = prop.getValue();
            if (propValue == null || !propValue.equalsIgnoreCase("true") && !propValue.equalsIgnoreCase("false") && !propValue.equalsIgnoreCase("dynamic")) {
                _logger.warning("Illegal value for ssoCookieSecure property: " + propValue);
            } else {
                this.ssoCookieSecure = propValue;
            }
        }
    }
}

