/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.taglibs.cache;

public class CacheEntry {
    public static final int NO_TIMEOUT = -1;
    String content;
    volatile long expireTime;

    public CacheEntry(String response, int timeout) {
        this.content = response;
        this.computeExpireTime(timeout);
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public String getContent() {
        return this.content;
    }

    public void computeExpireTime(int timeout) {
        this.expireTime = timeout == -1 ? (long)timeout : System.currentTimeMillis() + (long)(timeout * 1000);
    }

    public boolean isValid() {
        return this.expireTime > System.currentTimeMillis() || this.expireTime == -1L;
    }

    public void clear() {
        this.content = null;
        this.expireTime = 0L;
    }
}

