/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.taglibs.cache;

import com.sun.appserv.util.cache.Cache;
import com.sun.enterprise.web.logging.pwc.LogDomains;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class CacheUtil {
    private static ResourceBundle _rb = LogDomains.getLogger(CacheUtil.class, "javax.enterprise.system.container.web.pwc").getResourceBundle();
    private static final String PAGE_SCOPE = "page";
    private static final String REQUEST_SCOPE = "request";
    private static final String SESSION_SCOPE = "session";
    private static final String APPLICATION_SCOPE = "application";

    public static Cache getCache(PageContext pc, int scope) {
        return (Cache)pc.getAttribute("com.sun.appserv.web.taglibs.cache.tag_cache", scope);
    }

    public static String generateKey(String key, PageContext pc) {
        HttpServletRequest req = (HttpServletRequest)pc.getRequest();
        String suffix = key;
        if (suffix == null) {
            String saved = (String)req.getAttribute("com.sun.appserv.web.taglibs.cache.tag_counter");
            suffix = saved == null ? "1" : Integer.toString(Integer.parseInt(saved) + 1);
            req.setAttribute("com.sun.appserv.web.taglibs.cache.tag_counter", (Object)suffix);
        }
        return req.getServletPath() + '_' + suffix;
    }

    public static int convertScope(String scope) {
        int ret;
        if (REQUEST_SCOPE.equalsIgnoreCase(scope)) {
            ret = 2;
        } else if (SESSION_SCOPE.equalsIgnoreCase(scope)) {
            ret = 3;
        } else if (APPLICATION_SCOPE.equalsIgnoreCase(scope)) {
            ret = 4;
        } else {
            String msg = _rb.getString("taglibs.cache.illegalScope");
            msg = MessageFormat.format(msg, scope);
            throw new IllegalArgumentException(msg);
        }
        return ret;
    }
}

