/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.ContextParameter;
import com.sun.enterprise.deployment.web.EnvironmentEntry;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.logging.LogDomains;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.web.plugin.common.ContextParam;
import org.glassfish.web.plugin.common.EnvEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebApplication
implements ApplicationContainer<WebBundleDescriptor> {
    final Logger logger = LogDomains.getLogger(WebApplication.class, (String)"javax.enterprise.system.container.web");
    private final WebContainer container;
    private final WebModuleConfig wmInfo;
    Properties props = null;
    private Set<WebModule> webModules = new HashSet<WebModule>();
    private final org.glassfish.web.plugin.common.WebModuleConfig appConfigCustomizations;

    public WebApplication(WebContainer container, WebModuleConfig config, Properties props, ApplicationConfigInfo appConfigInfo) {
        this.container = container;
        this.wmInfo = config;
        this.props = props;
        this.appConfigCustomizations = this.extractCustomizations(appConfigInfo);
    }

    public boolean start(ApplicationContext appContext) throws Exception {
        this.webModules.clear();
        if (appContext != null) {
            this.wmInfo.setAppClassLoader(appContext.getClassLoader());
            if (appContext instanceof DeploymentContext) {
                this.wmInfo.setDeploymentContext((DeploymentContext)appContext);
            }
            this.applyApplicationConfig(appContext);
        }
        List<Result<WebModule>> results = this.container.loadWebModule(this.wmInfo, "null", this.props);
        this.props = null;
        if (results == null) {
            this.logger.log(Level.SEVERE, "Unknown error, loadWebModule returned null, file a bug");
            return false;
        }
        boolean isFailure = false;
        StringBuilder sb = null;
        for (Result<WebModule> result : results) {
            if (result.isFailure()) {
                if (sb == null) {
                    sb = new StringBuilder(result.exception().toString());
                } else {
                    sb.append(result.exception().toString());
                }
                this.logger.log(Level.WARNING, result.exception().toString(), result.exception());
                isFailure = true;
                continue;
            }
            this.webModules.add((WebModule)((Object)result.result()));
        }
        if (isFailure) {
            this.webModules.clear();
            throw new Exception(sb.toString());
        }
        this.logger.info("Loading application " + this.wmInfo.getDescriptor().getName() + " at " + this.wmInfo.getDescriptor().getContextRoot());
        return true;
    }

    public boolean stop(ApplicationContext stopContext) {
        this.props = null;
        if (Boolean.parseBoolean(stopContext.getAppProps().getProperty("keepSessions"))) {
            this.props = new Properties();
        }
        this.container.unloadWebModule(this.getDescriptor().getContextRoot(), null, null, this.props);
        return true;
    }

    public boolean suspend() {
        return this.container.suspendWebModule(this.wmInfo.getDescriptor().getContextRoot(), "null", null);
    }

    public boolean resume() throws Exception {
        return this.start(null);
    }

    public ClassLoader getClassLoader() {
        return this.wmInfo.getAppClassLoader();
    }

    WebContainer getContainer() {
        return this.container;
    }

    public Set<WebModule> getWebModules() {
        return this.webModules;
    }

    public WebBundleDescriptor getDescriptor() {
        return this.wmInfo.getDescriptor();
    }

    private org.glassfish.web.plugin.common.WebModuleConfig extractCustomizations(ApplicationConfigInfo appConfigInfo) {
        return (org.glassfish.web.plugin.common.WebModuleConfig)appConfigInfo.get(this.trimmedModuleName(this.wmInfo.getName()), "web");
    }

    private String trimmedModuleName(String moduleName) {
        int hash = moduleName.indexOf(35);
        if (hash == -1) {
            return moduleName;
        }
        return moduleName.substring(hash + 1);
    }

    private void applyApplicationConfig(ApplicationContext appContext) {
        WebBundleDescriptor descriptor = this.wmInfo.getDescriptor();
        try {
            if (this.appConfigCustomizations != null) {
                EnvEntryCustomizer envEntryCustomizer = new EnvEntryCustomizer(descriptor.getEnvironmentEntrySet(), this.appConfigCustomizations.getEnvEntry());
                ContextParamCustomizer contextParamCustomizer = new ContextParamCustomizer(descriptor.getContextParametersSet(), this.appConfigCustomizations.getContextParam());
                envEntryCustomizer.applyCustomizations();
                contextParamCustomizer.applyCustomizations();
            }
        }
        catch (ClassCastException ex) {
            this.logger.log(Level.WARNING, "", ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnvEntryCustomizer
    extends Customizer<EnvironmentEntry, EnvEntry> {
        private EnvEntryCustomizer(Set<EnvironmentEntry> descriptorItems, List<EnvEntry> customizations) {
            super(descriptorItems, customizations, "env-entry");
        }

        @Override
        protected boolean isIgnoreDescriptorItem(EnvEntry customization) {
            return Boolean.parseBoolean(customization.getIgnoreDescriptorItem());
        }

        @Override
        protected void setDescriptorItemValue(EnvironmentEntry descriptorItem, EnvEntry customization) {
            customization.validateValue();
            descriptorItem.setValue(customization.getEnvEntryValue());
            descriptorItem.setType(customization.getEnvEntryType());
        }

        @Override
        protected EnvironmentEntry newDescriptorItem(EnvEntry customization) {
            customization.validateValue();
            EnvironmentProperty newItem = new EnvironmentProperty(customization.getEnvEntryName(), customization.getEnvEntryValue(), customization.getDescription(), customization.getEnvEntryType());
            newItem.setValue(customization.getEnvEntryValue());
            return newItem;
        }

        @Override
        protected String getName(EnvironmentEntry descriptorItem) {
            return descriptorItem.getName();
        }

        @Override
        protected String getCustomizationName(EnvEntry customization) {
            return customization.getEnvEntryName();
        }

        @Override
        protected String getValue(EnvironmentEntry descriptorItem) {
            return descriptorItem.getValue();
        }

        @Override
        protected String toString(EnvEntry customization) {
            return "EnvEntry: name=" + customization.getEnvEntryName() + ", type=" + customization.getEnvEntryType() + ", value=" + customization.getEnvEntryValue() + ", desc=" + customization.getDescription();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContextParamCustomizer
    extends Customizer<ContextParameter, ContextParam> {
        private ContextParamCustomizer(Set<ContextParameter> descriptorItems, List<ContextParam> customizations) {
            super(descriptorItems, customizations, "context-param");
        }

        @Override
        protected boolean isIgnoreDescriptorItem(ContextParam customization) {
            return Boolean.parseBoolean(customization.getIgnoreDescriptorItem());
        }

        @Override
        protected void setDescriptorItemValue(ContextParameter descriptorItem, ContextParam customization) {
            descriptorItem.setValue(customization.getParamValue());
        }

        @Override
        protected ContextParameter newDescriptorItem(ContextParam customization) {
            EnvironmentProperty newItem = new EnvironmentProperty(customization.getParamName(), customization.getParamValue(), "");
            return newItem;
        }

        @Override
        protected String getName(ContextParameter descriptorItem) {
            return descriptorItem.getName();
        }

        @Override
        protected String getCustomizationName(ContextParam customization) {
            return customization.getParamName();
        }

        @Override
        protected String getValue(ContextParameter descriptorItem) {
            return descriptorItem.getValue();
        }

        @Override
        protected String toString(ContextParam customization) {
            return "Context-param: name=" + customization.getParamName() + ", value=" + customization.getParamValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Customizer<T, U> {
        protected Set<T> descriptorItems;
        protected List<U> customizations;
        private String descriptorItemName;

        private Customizer(Set<T> descriptorItems, List<U> customizations, String descriptorItemName) {
            this.descriptorItems = descriptorItems;
            this.customizations = customizations;
            this.descriptorItemName = descriptorItemName;
        }

        protected abstract boolean isIgnoreDescriptorItem(U var1);

        protected abstract T newDescriptorItem(U var1);

        protected abstract void setDescriptorItemValue(T var1, U var2);

        protected abstract String getName(T var1);

        protected abstract String getValue(T var1);

        protected abstract String getCustomizationName(U var1);

        protected abstract String toString(U var1);

        protected void removeDescriptorItem(T descriptorItem) {
            this.descriptorItems.remove(descriptorItem);
        }

        protected T addDescriptorItem(U customization) {
            T newItem = this.newDescriptorItem(customization);
            this.descriptorItems.add(newItem);
            return newItem;
        }

        void applyCustomizations() {
            boolean isFiner = WebApplication.this.logger.isLoggable(Level.FINER);
            block4: for (U customization : this.customizations) {
                Iterator<T> it = this.descriptorItems.iterator();
                while (it.hasNext()) {
                    String customizationItemName;
                    T descriptorItem = it.next();
                    String dItemName = this.getName(descriptorItem);
                    if (!dItemName.equals(customizationItemName = this.getCustomizationName(customization))) continue;
                    if (this.isIgnoreDescriptorItem(customization)) {
                        it.remove();
                        if (!isFiner) break block4;
                        WebApplication.this.logger.finer("App config customization specified to ignore descriptor's " + this.descriptorItemName + this.getName(descriptorItem) + " so it will not be present for the application");
                        break block4;
                    }
                    String oldValue = this.getValue(descriptorItem);
                    try {
                        this.setDescriptorItemValue(descriptorItem, customization);
                        if (!isFiner) break block4;
                        WebApplication.this.logger.finer("Overriding descriptor " + this.descriptorItemName + " " + this.getName(descriptorItem) + "=" + oldValue + " with " + this.toString(customization));
                    }
                    catch (Exception e) {
                        WebApplication.this.logger.warning(this.toString(customization) + " " + e.getLocalizedMessage());
                    }
                    break block4;
                }
                try {
                    T newItem = this.addDescriptorItem(customization);
                    if (!isFiner) continue;
                    WebApplication.this.logger.finer("Creating new " + this.descriptorItemName + this.getName(newItem) + "=" + this.getValue(newItem));
                }
                catch (Exception e) {
                    WebApplication.this.logger.warning(this.toString(customization) + " " + e.getLocalizedMessage());
                }
            }
        }
    }
}

