/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.web.VirtualServer;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.core.StandardPipeline;

public class VirtualServerPipeline
extends StandardPipeline {
    private static final Logger logger = LogDomains.getLogger(VirtualServerPipeline.class, (String)"javax.enterprise.system.container.web");
    private static final ResourceBundle rb = logger.getResourceBundle();
    private VirtualServer vs;
    private boolean isOff;
    private boolean isDisabled;
    private ArrayList<RedirectParameters> redirects;
    private ConcurrentLinkedQueue<CharChunk> locations;

    public VirtualServerPipeline(VirtualServer vs) {
        super((Container)vs);
        this.vs = vs;
        this.locations = new ConcurrentLinkedQueue();
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.isOff) {
            String msg = rb.getString("virtualServerValve.vsOff");
            msg = MessageFormat.format(msg, this.vs.getName());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(msg);
            }
            ((HttpServletResponse)response.getResponse()).sendError(404, msg);
        } else if (this.isDisabled) {
            String msg = rb.getString("virtualServerValve.vsDisabled");
            msg = MessageFormat.format(msg, this.vs.getName());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(msg);
            }
            ((HttpServletResponse)response.getResponse()).sendError(403, msg);
        } else {
            boolean redirect = false;
            if (this.redirects != null) {
                redirect = this.redirectIfNecessary(request, response);
            }
            if (!redirect) {
                super.invoke(request, response);
            }
        }
    }

    void setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    void setIsOff(boolean isOff) {
        this.isOff = isOff;
    }

    void addRedirect(String from, String url, String urlPrefix, boolean escape) {
        if (this.redirects == null) {
            this.redirects = new ArrayList();
        }
        this.redirects.add(new RedirectParameters(from, url, urlPrefix, escape));
    }

    boolean hasRedirects() {
        return this.redirects != null && this.redirects.size() > 0;
    }

    void clearRedirects() {
        if (this.redirects != null) {
            this.redirects.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean redirectIfNecessary(Request request, Response response) throws IOException {
        if (this.redirects == null) {
            return false;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)request.getResponse();
        String requestURI = hreq.getRequestURI();
        RedirectParameters redirectMatch = null;
        int size = this.redirects.size();
        for (int i = 0; i < size; ++i) {
            RedirectParameters elem = this.redirects.get(i);
            String elemFromWithTrailingSlash = elem.from;
            if (!elemFromWithTrailingSlash.endsWith("/")) {
                elemFromWithTrailingSlash = elemFromWithTrailingSlash + "/";
            }
            if (!requestURI.equals(elem.from) && !requestURI.startsWith(elemFromWithTrailingSlash)) continue;
            if (redirectMatch != null) {
                if (elem.from.length() <= redirectMatch.from.length()) continue;
                redirectMatch = elem;
                continue;
            }
            redirectMatch = elem;
        }
        if (redirectMatch != null) {
            String location = null;
            String uriSuffix = requestURI.substring(redirectMatch.from.length());
            if ("/".equals(redirectMatch.from)) {
                uriSuffix = "/" + uriSuffix;
                if (redirectMatch.urlPrefixPath != null && uriSuffix.startsWith(redirectMatch.urlPrefixPath)) {
                    return false;
                }
            }
            if ("".equals(redirectMatch.from) && !"/".equals(requestURI)) {
                return false;
            }
            location = redirectMatch.urlPrefix != null ? redirectMatch.urlPrefix + uriSuffix : redirectMatch.url;
            String queryString = hreq.getQueryString();
            if (queryString != null) {
                location = location + "?" + queryString;
            }
            CharChunk locationCC = null;
            if (redirectMatch.isEscape) {
                try {
                    URL url = new URL(location);
                    locationCC = this.locations.poll();
                    if (locationCC == null) {
                        locationCC = new CharChunk();
                    }
                    locationCC.append(url.getProtocol());
                    locationCC.append("://");
                    locationCC.append(url.getHost());
                    if (url.getPort() != -1) {
                        locationCC.append(":");
                        locationCC.append(String.valueOf(url.getPort()));
                    }
                    locationCC.append(response.encode(url.getPath()));
                    if (queryString != null) {
                        locationCC.append("?");
                        locationCC.append(url.getQuery());
                    }
                    location = locationCC.toString();
                }
                catch (MalformedURLException mue) {
                    if (redirectMatch.validURI) {
                        logger.log(Level.WARNING, "virtualServerPipeline.invalidRedirectLocation", location);
                    } else if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "virtualServerPipeline.invalidRedirectLocation", location);
                    }
                }
                finally {
                    if (locationCC != null) {
                        locationCC.recycle();
                        this.locations.offer(locationCC);
                    }
                }
            }
            hres.sendRedirect(location);
            return true;
        }
        return false;
    }

    static class RedirectParameters {
        private String from;
        private String url;
        private String urlPrefix;
        private String urlPrefixPath;
        private boolean validURI;
        private boolean isEscape;

        RedirectParameters(String from, String url, String urlPrefix, boolean isEscape) {
            this.from = from;
            this.url = url;
            this.urlPrefix = urlPrefix;
            this.isEscape = isEscape;
            this.validURI = true;
            try {
                URL u = new URL(urlPrefix);
                this.urlPrefixPath = u.getPath();
            }
            catch (MalformedURLException e) {
                this.urlPrefixPath = urlPrefix;
                this.validURI = false;
            }
        }
    }
}

