/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.common.DefaultResourcePrincipal;
import com.sun.enterprise.deployment.runtime.common.ResourceRef;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.web.ContextParameter;
import com.sun.enterprise.web.TomcatDeploymentConfig;
import com.sun.enterprise.web.WebModule;
import com.sun.logging.LogDomains;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.authenticator.DigestAuthenticator;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.startup.ContextConfig;
import org.glassfish.web.valve.GlassFishValve;
import org.jvnet.hk2.component.Habitat;

public class WebModuleContextConfig
extends ContextConfig {
    private static final String DEFAULT_DIGEST_ALGORITHM = "default-digest-algorithm";
    private static final Logger logger = LogDomains.getLogger(WebModuleContextConfig.class, (String)"javax.enterprise.system.container.web");
    protected static final ResourceBundle rb = logger.getResourceBundle();
    public static final int CHILDREN = 0;
    public static final int SERVLET_MAPPINGS = 1;
    public static final int LOCAL_EJBS = 2;
    public static final int EJBS = 3;
    public static final int ENVIRONMENTS = 4;
    public static final int ERROR_PAGES = 5;
    public static final int FILTER_DEFS = 6;
    public static final int FILTER_MAPS = 7;
    public static final int APPLICATION_LISTENERS = 8;
    public static final int RESOURCES = 9;
    public static final int APPLICATION_PARAMETERS = 10;
    public static final int MESSAGE_DESTINATIONS = 11;
    public static final int MESSAGE_DESTINATION_REFS = 12;
    public static final int MIME_MAPPINGS = 13;
    protected Habitat habitat;
    protected File file;
    private WebBundleDescriptor webBundleDescriptor;
    private Collection<ResourceReferenceDescriptor> resRefs = new HashSet<ResourceReferenceDescriptor>();
    private Collection<EnvironmentProperty> envProps = new HashSet<EnvironmentProperty>();

    public void setDescriptor(WebBundleDescriptor wbd) {
        this.webBundleDescriptor = wbd;
    }

    public WebBundleDescriptor getDescriptor() {
        return this.webBundleDescriptor;
    }

    public void setHabitat(Habitat habitat) {
        this.habitat = habitat;
    }

    public void lifecycleEvent(LifecycleEvent event) throws LifecycleException {
        this.context = (Context)event.getLifecycle();
        if (event.getType().equals("start")) {
            this.configureResource();
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        } else if (event.getType().equals("init")) {
            super.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void configureResource() throws LifecycleException {
        List appParams;
        List list = appParams = this.context.findApplicationParameters();
        synchronized (list) {
            for (ApplicationParameter appParam : appParams) {
                EnvironmentProperty contextParam = new EnvironmentProperty(appParam.getName(), appParam.getValue(), appParam.getDescription());
                this.webBundleDescriptor.addContextParameter((ContextParameter)contextParam);
            }
        }
        ContextEnvironment[] envs = this.context.findEnvironments();
        for (int i = 0; i < envs.length; ++i) {
            EnvironmentProperty envEntry = new EnvironmentProperty(envs[i].getName(), envs[i].getValue(), envs[i].getDescription(), envs[i].getType());
            if (envs[i].getValue() != null) {
                envEntry.setValue(envs[i].getValue());
            }
            this.webBundleDescriptor.addEnvironmentProperty(envEntry);
            this.envProps.add(envEntry);
        }
        ContextResource[] resources = this.context.findResources();
        SunWebApp iasBean = this.webBundleDescriptor.getSunDescriptor();
        ResourceRef[] rr = iasBean.getResourceRef();
        for (int i = 0; i < resources.length; ++i) {
            ResourceReferenceDescriptor resourceReference = new ResourceReferenceDescriptor(resources[i].getName(), resources[i].getDescription(), resources[i].getType());
            resourceReference.setJndiName(resources[i].getName());
            if (rr != null) {
                for (int j = 0; j < rr.length; ++j) {
                    if (!resources[i].getName().equals(rr[j].getResRefName())) continue;
                    resourceReference.setJndiName(rr[i].getJndiName());
                    DefaultResourcePrincipal drp = rr[i].getDefaultResourcePrincipal();
                    if (drp == null) continue;
                    ResourcePrincipal rp = new ResourcePrincipal(drp.getName(), drp.getPassword());
                    resourceReference.setResourcePrincipal(rp);
                }
            }
            resourceReference.setAuthorization(resources[i].getAuth());
            this.webBundleDescriptor.addResourceReferenceDescriptor(resourceReference);
            this.resRefs.add(resourceReference);
        }
    }

    protected synchronized void start() throws LifecycleException {
        this.context.setConfigured(false);
        ComponentEnvManager namingMgr = (ComponentEnvManager)this.habitat.getComponent(ComponentEnvManager.class);
        if (namingMgr != null) {
            try {
                boolean webBundleContainsEjbs;
                boolean bl = webBundleContainsEjbs = this.webBundleDescriptor.getExtensionsDescriptors(EjbBundleDescriptor.class).size() > 0;
                if (webBundleContainsEjbs) {
                    namingMgr.addToComponentNamespace((JndiNameEnvironment)this.webBundleDescriptor, this.envProps, this.resRefs);
                } else {
                    namingMgr.bindToComponentNamespace((JndiNameEnvironment)this.webBundleDescriptor);
                }
                String componentId = namingMgr.getComponentEnvId((JndiNameEnvironment)this.webBundleDescriptor);
                ((WebModule)this.context).setComponentId(componentId);
            }
            catch (NamingException ne) {
                throw new LifecycleException((Throwable)ne);
            }
        }
        TomcatDeploymentConfig.configureWebModule((WebModule)this.context, this.webBundleDescriptor);
        this.authenticatorConfig();
        this.managerConfig();
        this.context.setConfigured(true);
    }

    protected synchronized void authenticatorConfig() throws LifecycleException {
        Pipeline pipeline;
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = new LoginConfig("NONE", null, null, null);
            this.context.setLoginConfig(loginConfig);
        }
        if (this.context instanceof Authenticator) {
            return;
        }
        if (this.context instanceof ContainerBase) {
            Pipeline pipeline2 = ((ContainerBase)this.context).getPipeline();
            if (pipeline2 != null) {
                GlassFishValve basic = pipeline2.getBasic();
                if (basic != null && basic instanceof Authenticator) {
                    return;
                }
                GlassFishValve[] valves = pipeline2.getValves();
                for (int i = 0; i < valves.length; ++i) {
                    if (!(valves[i] instanceof Authenticator)) continue;
                    return;
                }
            }
        } else {
            return;
        }
        Realm rlm = this.context.getRealm();
        if (rlm == null) {
            String realmName;
            String string = realmName = this.context.getLoginConfig() != null ? this.context.getLoginConfig().getRealmName() : null;
            if (realmName != null && !realmName.isEmpty()) {
                String msg = rb.getString("webModuleContextConfig.missingRealm");
                throw new LifecycleException(MessageFormat.format(msg, realmName));
            }
            return;
        }
        rlm.setRealmName(loginConfig.getRealmName(), loginConfig.getAuthMethod());
        GlassFishValve authenticator = null;
        if (this.customAuthenticators != null) {
            authenticator = (GlassFishValve)this.customAuthenticators.get(loginConfig.getAuthMethod());
        }
        if (authenticator == null) {
            String authenticatorName = null;
            String authMethod = loginConfig.getAuthMethod();
            if (authMethod == null) {
                authMethod = "NONE";
            }
            if ((authenticatorName = authenticators.getProperty(authMethod)) == null) {
                String msg = rb.getString("webModuleContextConfig.authenticatorMissing");
                throw new LifecycleException(MessageFormat.format(msg, loginConfig.getAuthMethod()));
            }
            try {
                Class<?> authenticatorClass = Class.forName(authenticatorName);
                authenticator = (GlassFishValve)authenticatorClass.newInstance();
            }
            catch (Exception e) {
                String msg = rb.getString("webModuleContextConfig.authenticatorInstantiate");
                throw new LifecycleException(MessageFormat.format(msg, authenticatorName), (Throwable)e);
            }
        }
        if (authenticator != null && this.context instanceof ContainerBase && (pipeline = ((ContainerBase)this.context).getPipeline()) != null) {
            ((ContainerBase)this.context).addValve(authenticator);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "webModuleContextConfig.authenticatorConfigured", loginConfig.getAuthMethod());
            }
        }
        if (authenticator instanceof DigestAuthenticator) {
            Config config = (Config)this.habitat.getComponent(Config.class, "default-instance-name");
            SecurityService securityService = config.getSecurityService();
            String digestAlgorithm = null;
            if (securityService != null) {
                digestAlgorithm = securityService.getPropertyValue(DEFAULT_DIGEST_ALGORITHM);
            }
            if (digestAlgorithm != null) {
                DigestAuthenticator cfr_ignored_0 = (DigestAuthenticator)authenticator;
                DigestAuthenticator.setAlgorithm((String)digestAlgorithm);
            }
        }
    }

    protected void defaultConfig() {
    }

    protected synchronized void stop() {
        super.stop();
        try {
            ComponentEnvManager namingMgr = (ComponentEnvManager)this.habitat.getComponent(ComponentEnvManager.class);
            if (namingMgr != null) {
                namingMgr.unbindFromComponentNamespace((JndiNameEnvironment)this.webBundleDescriptor);
            }
        }
        catch (NamingException ex) {
            String msg = rb.getString("webModuleContextConfig.unbindNamespaceError");
            msg = MessageFormat.format(msg, this.context.getName());
            logger.log(Level.WARNING, msg, ex);
        }
    }
}

