/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.logger;

import com.sun.enterprise.web.logger.FileLoggerHandler;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Formatter;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class FileLoggerHandlerFactory
implements PostConstruct {
    @Inject(optional=true)
    private Formatter logFormatter;
    private static ConcurrentMap<String, FileLoggerHandler> map = new ConcurrentHashMap<String, FileLoggerHandler>();

    public void postConstruct() {
    }

    public synchronized FileLoggerHandler getHandler(String logFile) {
        FileLoggerHandler handler = (FileLoggerHandler)map.get(logFile);
        if (handler == null) {
            handler = new FileLoggerHandler(logFile);
            if (this.logFormatter != null) {
                handler.setFormatter(this.logFormatter);
            }
            map.put(logFile, handler);
        }
        return handler;
    }

    public synchronized void removeHandler(String logFile) {
        map.remove(logFile);
    }
}

