/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.session;

import org.apache.catalina.core.SessionCookieConfigImpl;
import org.apache.catalina.core.StandardContext;

public final class WebSessionCookieConfig
extends SessionCookieConfigImpl {
    private CookieSecureType secureCookieType = CookieSecureType.DYNAMIC;

    public WebSessionCookieConfig(StandardContext context) {
        super(context);
    }

    public void setSecure(boolean secure) {
        super.setSecure(secure);
        this.secureCookieType = secure ? CookieSecureType.TRUE : CookieSecureType.DYNAMIC;
    }

    public void setSecure(String secure) {
        boolean isTrue = Boolean.parseBoolean(secure);
        super.setSecure(isTrue);
        this.secureCookieType = isTrue ? CookieSecureType.TRUE : ("false".equalsIgnoreCase(secure) ? CookieSecureType.FALSE : CookieSecureType.DYNAMIC);
    }

    public CookieSecureType getSecure() {
        return this.secureCookieType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CookieSecureType {
        TRUE,
        FALSE,
        DYNAMIC;

    }
}

