/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web;

import com.sun.enterprise.util.net.JarURIPattern;
import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.web.TldProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="librariesTld")
@Scoped(value=Singleton.class)
public class LibrariesTldProvider
implements TldProvider,
PostConstruct {
    @Inject
    private ServerEnvironment serverEnvironment;
    private Map<URI, List<String>> tldMap = new HashMap<URI, List<String>>();

    public String getName() {
        return "librariesTld";
    }

    public Map<URI, List<String>> getTldMap() {
        return this.cloneTldMap();
    }

    public Map<URI, List<String>> getTldListenerMap() {
        return this.cloneTldMap();
    }

    private Map<URI, List<String>> cloneTldMap() {
        return (Map)((HashMap)this.tldMap).clone();
    }

    public void postConstruct() {
        File[] domainLibJars = this.serverEnvironment.getLibPath().listFiles(new FileFilter(){

            public boolean accept(File path) {
                return path.isFile() && path.getName().endsWith(".jar");
            }
        });
        if (domainLibJars != null && domainLibJars.length > 0) {
            ArrayList<URI> uris = new ArrayList<URI>();
            for (File f : domainLibJars) {
                uris.add(f.toURI());
            }
            Pattern pattern = Pattern.compile("META-INF/.*\\.tld");
            for (URI uri : uris) {
                List entries = JarURIPattern.getJarEntries((URI)uri, (Pattern)pattern);
                if (entries == null || entries.size() <= 0) continue;
                this.tldMap.put(uri, entries);
            }
        }
    }
}

