/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web;

import com.sun.enterprise.security.web.SingleSignOnMBean;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.authenticator.SingleSignOnEntry;

public class GlassFishSingleSignOn
extends SingleSignOn
implements SessionListener,
Runnable,
SingleSignOnMBean {
    private static final Logger logger = LogDomains.getLogger(GlassFishSingleSignOn.class, (String)"javax.enterprise.system.container.web");
    private Thread thread = null;
    private boolean threadDone = false;
    private int ssoReapInterval = 60;
    private int ssoMaxInactive = 300;
    private AtomicInteger hitCount = new AtomicInteger(0);
    private AtomicInteger missCount = new AtomicInteger(0);

    public int getReapInterval() {
        return this.ssoReapInterval;
    }

    public void setReapInterval(int t) {
        this.ssoReapInterval = t;
    }

    public int getMaxInactive() {
        return this.ssoMaxInactive;
    }

    public void setMaxInactive(int t) {
        this.ssoMaxInactive = t;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        super.start();
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.threadStop();
        super.stop();
    }

    public void sessionEvent(SessionEvent event) {
        String ssoId;
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Process session destroyed on " + session);
        }
        if ((ssoId = session.getSsoId()) == null) {
            return;
        }
        if (session.hasExpired()) {
            this.removeSession(ssoId, session);
        } else {
            this.deregister(ssoId);
        }
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry entry;
        Cookie[] cookies;
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        request.removeNote("org.apache.catalina.request.SSOID");
        request.removeNote("org.apache.catalina.request.SSOVersion");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Process request for '" + hreq.getRequestURI() + "'");
        }
        if (hreq.getUserPrincipal() != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" Principal '" + hreq.getUserPrincipal().getName() + "' has already been authenticated");
            }
            return 1;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" Checking for SSO cookie");
        }
        if ((cookies = hreq.getCookies()) == null) {
            return 1;
        }
        Cookie cookie = null;
        Cookie versionCookie = null;
        for (Cookie c : cookies) {
            if ("JSESSIONIDSSO".equals(c.getName())) {
                cookie = c;
            } else if ("JSESSIONIDSSOVERSION".equals(c.getName())) {
                versionCookie = c;
            }
            if (cookie != null && versionCookie != null) break;
        }
        if (cookie == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" SSO cookie is not present");
            }
            return 1;
        }
        Realm realm = request.getContext().getRealm();
        if (realm == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" No realm configured for this application, SSO does not apply.");
            }
            return 1;
        }
        String realmName = realm.getRealmName();
        if (realmName == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" No realm configured for this application, SSO does not apply.");
            }
            return 1;
        }
        if (this.debug >= 1 && logger.isLoggable(Level.FINE)) {
            logger.fine("This application uses realm '" + realmName + "'");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" Checking for cached principal for " + cookie.getValue());
        }
        long version = 0L;
        if (this.isVersioningSupported() && versionCookie != null) {
            version = Long.parseLong(versionCookie.getValue());
        }
        if ((entry = this.lookup(cookie.getValue(), version)) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" Found cached principal '" + entry.getPrincipal().getName() + "' with auth type '" + entry.getAuthType() + "' in realm '" + entry.getRealmName() + "'");
            }
            if (entry.getRealmName().equals(realmName)) {
                request.setNote("org.apache.catalina.request.SSOID", (Object)cookie.getValue());
                ((HttpRequest)request).setAuthType(entry.getAuthType());
                ((HttpRequest)request).setUserPrincipal(entry.getPrincipal());
                entry.setLastAccessTime(System.currentTimeMillis());
                if (this.isVersioningSupported()) {
                    long ver = entry.incrementAndGetVersion();
                    request.setNote("org.apache.catalina.request.SSOVersion", (Object)ver);
                }
                this.hitCount.incrementAndGet();
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(" Ignoring SSO entry which does not match application realm '" + realmName + "'");
                }
                this.missCount.incrementAndGet();
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" No cached principal found, erasing SSO cookie");
            }
            cookie.setMaxAge(0);
            hres.addCookie(cookie);
            this.missCount.incrementAndGet();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Deregistering sso id '" + ssoId + "'");
        }
        SingleSignOnEntry sso = null;
        Map map = this.cache;
        synchronized (map) {
            sso = (SingleSignOnEntry)this.cache.remove(ssoId);
        }
        if (sso == null) {
            return;
        }
        sso.expireSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpires() {
        if (this.ssoMaxInactive < 0) {
            return;
        }
        long tooOld = System.currentTimeMillis() - (long)this.ssoMaxInactive * 1000L;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SSO expiration started. Current entries: " + this.cache.size());
        }
        ArrayList<String> removals = new ArrayList<String>(this.cache.size() / 2);
        try {
            Map map = this.cache;
            synchronized (map) {
                for (String key : this.cache.keySet()) {
                    SingleSignOnEntry sso = (SingleSignOnEntry)this.cache.get(key);
                    if (!sso.isEmpty() || sso.getLastAccessTime() >= tooOld) continue;
                    removals.add(key);
                }
            }
            int removalCount = removals.size();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SSO cache will expire " + removalCount + " entries.");
            }
            for (int i = 0; i < removalCount; ++i) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("SSO expiration removing entry: " + (String)removals.get(i));
                }
                this.deregister((String)removals.get(i));
            }
        }
        catch (Throwable e) {
            logger.warning("Caught exception during SingleSignOn expiration: " + e);
        }
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.ssoReapInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        String threadName = "SingleSignOnExpiration";
        this.thread = new Thread((Runnable)this, threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processExpires();
        }
    }

    protected void removeSession(String ssoId, Session session) {
        SingleSignOnEntry entry;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Removing session " + session.toString() + " from sso id " + ssoId);
        }
        if ((entry = this.lookup(ssoId)) == null) {
            return;
        }
        entry.removeSession(session);
        if (entry.isEmpty()) {
            this.deregister(ssoId);
        }
    }

    public int getActiveSessionCount() {
        return this.cache.size();
    }

    public int getHitCount() {
        return this.hitCount.intValue();
    }

    public int getMissCount() {
        return this.missCount.intValue();
    }
}

