/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.web.WebComponentInvocation;
import com.sun.enterprise.web.WebModule;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;

public final class WebContainerListener
implements ContainerListener {
    private static final Logger _logger = LogDomains.getLogger(WebContainerListener.class, (String)"javax.enterprise.system.container.web");
    private static final ResourceBundle rb = _logger.getResourceBundle();
    private static HashSet<String> beforeEvents = new HashSet();
    private static HashSet<String> afterEvents = new HashSet();
    private InvocationManager invocationMgr;
    private InjectionManager injectionMgr;

    public WebContainerListener(InvocationManager invocationMgr, InjectionManager injectionMgr) {
        this.invocationMgr = invocationMgr;
        this.injectionMgr = injectionMgr;
    }

    public void containerEvent(ContainerEvent event) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "ContainerEvent: " + event.getType() + "," + event.getContainer() + "," + event.getData());
        }
        String type = event.getType();
        try {
            WebModule wm = (WebModule)event.getContainer();
            if (beforeEvents.contains(type)) {
                this.preInvoke(wm);
            } else if (afterEvents.contains(type)) {
                if (type.equals("afterFilterDestroyed") || type.equals("afterContextDestroyed")) {
                    this.preDestroy(event);
                }
                this.postInvoke(wm);
            } else if ("predestroy".equals(type)) {
                this.preInvoke(wm);
                this.preDestroy(event);
                this.postInvoke(wm);
            }
        }
        catch (Throwable t) {
            String msg = rb.getString("containerListener.exceptionDuringHandleEvent");
            msg = MessageFormat.format(msg, type, event.getContainer());
            _logger.log(Level.SEVERE, msg, t);
        }
    }

    private void preInvoke(WebModule ctx) {
        WebModule wm = ctx;
        WebComponentInvocation inv = new WebComponentInvocation(wm);
        this.invocationMgr.preInvoke((ComponentInvocation)inv);
    }

    private void postInvoke(WebModule ctx) {
        WebModule wm = ctx;
        WebComponentInvocation inv = new WebComponentInvocation(wm);
        this.invocationMgr.postInvoke((ComponentInvocation)inv);
    }

    private void preDestroy(ContainerEvent event) {
        try {
            this.injectionMgr.destroyManagedObject(event.getData());
        }
        catch (Throwable t) {
            String msg = rb.getString("containerListener.exceptionDuringDestroyManagedObject");
            msg = MessageFormat.format(msg, event.getData(), event.getContainer());
            _logger.log(Level.SEVERE, msg, t);
        }
    }

    static {
        beforeEvents.add("beforeContextInitialized");
        beforeEvents.add("beforeContextDestroyed");
        beforeEvents.add("beforeContextAttributeAdded");
        beforeEvents.add("beforeContextAttributeRemoved");
        beforeEvents.add("beforeContextAttributeReplaced");
        beforeEvents.add("beforeRequestInitialized");
        beforeEvents.add("beforeRequestDestroyed");
        beforeEvents.add("beforeSessionCreated");
        beforeEvents.add("beforeSessionDestroyed");
        beforeEvents.add("beforeSessionAttributeAdded");
        beforeEvents.add("beforeSessionAttributeRemoved");
        beforeEvents.add("beforeSessionAttributeReplaced");
        beforeEvents.add("beforeSessionValueUnbound");
        beforeEvents.add("beforeFilterInitialized");
        beforeEvents.add("beforeFilterDestroyed");
        afterEvents.add("afterContextInitialized");
        afterEvents.add("afterContextDestroyed");
        afterEvents.add("afterContextAttributeAdded");
        afterEvents.add("afterContextAttributeRemoved");
        afterEvents.add("afterContextAttributeReplaced");
        afterEvents.add("afterRequestInitialized");
        afterEvents.add("afterRequestDestroyed");
        afterEvents.add("afterSessionCreated");
        afterEvents.add("afterSessionDestroyed");
        afterEvents.add("afterSessionAttributeAdded");
        afterEvents.add("afterSessionAttributeRemoved");
        afterEvents.add("afterSessionAttributeReplaced");
        afterEvents.add("afterSessionValueUnbound");
        afterEvents.add("afterFilterInitialized");
        afterEvents.add("afterFilterDestroyed");
    }
}

