/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import com.sun.appserv.util.cache.BaseCache;
import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.catalina.Container;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.web.ha.session.management.BaseHASession;
import org.glassfish.web.ha.session.management.HAStoreBase;
import org.glassfish.web.ha.session.management.ReplicationManagerBase;
import org.glassfish.web.ha.session.management.SimpleMetadata;
import org.glassfish.web.ha.session.management.SimpleMetadataFactory;

public class ReplicationStore
extends HAStoreBase {
    protected static final Logger _logger = LogDomains.getLogger(ReplicationStore.class, (String)"javax.enterprise.system.container.web");

    public ReplicationStore(ServerConfigLookup serverConfigLookup, JavaEEIOUtils ioUtils) {
        super(serverConfigLookup, ioUtils);
    }

    public String getApplicationId() {
        if (this.applicationId != null) {
            return this.applicationId;
        }
        this.applicationId = "WEB:" + super.getApplicationId();
        return this.applicationId;
    }

    public void valveSave(Session session) throws IOException {
        this.doValveSave(session);
    }

    public void doValveSave(Session session) throws IOException {
        if (!((StandardSession)session).getIsValid()) {
            return;
        }
        byte[] sessionState = this.getByteArray(session, this.isReplicationCompressionEnabled());
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>doValveSave replicator: " + replicator);
            _logger.fine("ReplicationStore>>doValveSave version:" + session.getVersion());
        }
        SimpleMetadata simpleMetadata = SimpleMetadataFactory.createSimpleMetadata(session.getVersion(), session.getLastAccessedTime(), session.getMaxInactiveInterval(), sessionState);
        try {
            replicator.save((Serializable)((Object)session.getIdInternal()), (Serializable)simpleMetadata, true);
            _logger.info("Save succeeded.");
        }
        catch (BackingStoreException ex) {
            IOException ex1 = (IOException)new IOException("Error during save: " + ex.getMessage()).initCause(ex);
            throw ex1;
        }
    }

    public void cleanup() {
    }

    public BaseCache getSessions() {
        return null;
    }

    public void setSessions(BaseCache sesstable) {
    }

    public void save(Session session) throws IOException {
        this.doSave(session);
    }

    protected boolean isReplicationCompressionEnabled() {
        return false;
    }

    public void doSave(Session session) throws IOException {
        byte[] sessionState = this.getByteArray(session, this.isReplicationCompressionEnabled());
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore backingStore = mgr.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>save: backing store : " + backingStore);
        }
        SimpleMetadata simpleMetadata = SimpleMetadataFactory.createSimpleMetadata(session.getVersion(), session.getLastAccessedTime(), session.getMaxInactiveInterval(), sessionState);
        try {
            backingStore.save((Serializable)((Object)session.getIdInternal()), (Serializable)simpleMetadata, true);
        }
        catch (BackingStoreException ex) {
            IOException ex1 = (IOException)new IOException("Error during save: " + ex.getMessage()).initCause(ex);
            throw ex1;
        }
    }

    public synchronized void clear() throws IOException {
    }

    public void doRemove(String id) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>doRemove");
        }
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>doRemove: replicator: " + replicator);
        }
        try {
            replicator.remove((Serializable)((Object)id));
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    public synchronized void removeSynchronized(String id) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>removeSynchronized");
        }
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>removeSynchronized: replicator: " + replicator);
        }
        try {
            replicator.remove((Serializable)((Object)id));
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    public void processExpires() {
        this.removeExpiredSessions();
    }

    public int removeExpiredSessions() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN ReplicationStore>>removeExpiredSessions");
        }
        int result = 0;
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        if (mgr == null) {
            return result;
        }
        BackingStore backingStore = mgr.getBackingStore();
        try {
            result = backingStore.removeExpired(30000L);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>removeExpiredSessions():number of expired sessions = " + result);
        }
        return result;
    }

    public Session load(String id) throws ClassNotFoundException, IOException {
        return this.load(id, null);
    }

    public Session load(String id, String version) throws ClassNotFoundException, IOException {
        try {
            return this.loadFromBackingStore(id, version);
        }
        catch (BackingStoreException ex) {
            IOException ex1 = (IOException)new IOException("Error during load: " + ex.getMessage()).initCause(ex);
            throw ex1;
        }
    }

    public Session loadFromBackingStore(String id, String version) throws IOException, ClassNotFoundException, BackingStoreException {
        SimpleMetadata metaData = (SimpleMetadata)this.getBackingStore().load((Serializable)((Object)id), version);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>loadFromBackingStore:id=" + id + ", metaData=" + metaData);
        }
        Session session = this.getSession(metaData);
        return session;
    }

    BackingStore getBackingStore() {
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getBackingStore();
        return replicator;
    }

    public void updateLastAccessTime(Session session) throws IOException {
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>updateLastAccessTime: replicator: " + replicator);
        }
        try {
            SimpleMetadata smd = SimpleMetadataFactory.createSimpleMetadata(session.getVersion(), ((BaseHASession)session).getLastAccessedTimeInternal());
            replicator.save((Serializable)((Object)session.getIdInternal()), (Serializable)smd, true);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    public String[] keys() throws IOException {
        return new String[0];
    }

    public int getSize() throws IOException {
        int result = 0;
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>getSize: replicator: " + replicator);
        }
        try {
            result = replicator.size();
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        return result;
    }

    private Session getSession(SimpleMetadata metaData) throws IOException {
        if (metaData == null || metaData.getState() == null) {
            return null;
        }
        return this.getSession(metaData.getState(), metaData.getVersion(), metaData.getClass().getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(byte[] state, long version, ClassLoader classLoader) throws IOException {
        Session _session;
        block15: {
            _session = null;
            FilterInputStream is = null;
            BufferedInputStream bis = null;
            ByteArrayInputStream bais = null;
            Object loader = null;
            ObjectInputStream ois = null;
            Container container = this.manager.getContainer();
            Object pal = null;
            try {
                bais = new ByteArrayInputStream(state);
                bis = new BufferedInputStream(bais);
                is = this.isReplicationCompressionEnabled() ? new GZIPInputStream(bis) : bis;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("loaded session from replicationstore, length = " + state.length);
                }
                try {
                    ois = this.ioUtils.createObjectInputStream((InputStream)is, true, classLoader);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (ois == null) {
                    ois = new ObjectInputStream(is);
                }
                if (ois == null) break block15;
                try {
                    _session = this.readSession(this.manager, ois);
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                            bis = null;
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (ClassNotFoundException e) {
                IOException ex1 = (IOException)new IOException("Error during deserialization: " + e.getMessage()).initCause(e);
                throw ex1;
            }
            catch (IOException e) {
                throw e;
            }
        }
        _session.setNew(false);
        return _session;
    }
}

