/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.glassfish.ha.store.api.Storeable;

public class SimpleMetadata
implements Storeable {
    private long version = -1L;
    private long lastAccessTime;
    private long maxInactiveInterval;
    private byte[] state;

    public SimpleMetadata() {
    }

    public SimpleMetadata(long version, long lastAccesstime, long maxInactiveInterval, byte[] state) {
        this.version = version;
        this.lastAccessTime = lastAccesstime;
        this.maxInactiveInterval = maxInactiveInterval;
        this.state = state;
    }

    public SimpleMetadata(long version, long lastAccesstime) {
        this.version = version;
        this.lastAccessTime = this.lastAccessTime;
    }

    public long getVersion() {
        return this.version;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public byte[] getState() {
        return this.state;
    }

    public long _storeable_getVersion() {
        return this.version;
    }

    public void _storeable_setVersion(long version) {
        this.version = version;
    }

    public long _storeable_getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void _storeable_setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public long _storeable_getMaxIdleTime() {
        return this.maxInactiveInterval;
    }

    public void _storeable_setMaxIdleTime(long maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public String[] _storeable_getAttributeNames() {
        return new String[0];
    }

    public boolean[] _storeable_getDirtyStatus() {
        return new boolean[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _storeable_writeState(OutputStream os) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(os);
        try {
            oos.writeLong(this.version);
            oos.writeLong(this.lastAccessTime);
            oos.writeLong(this.maxInactiveInterval);
            oos.writeInt(this.state == null ? 0 : this.state.length);
            if (this.state != null) {
                oos.write(this.state);
            }
        }
        finally {
            try {
                oos.flush();
                oos.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _storeable_readState(InputStream is) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            long tempVersion = ois.readLong();
            if (tempVersion > this.version) {
                this.version = tempVersion;
                this.lastAccessTime = ois.readLong();
                this.maxInactiveInterval = ois.readLong();
                int len = ois.readInt();
                if (len > 0) {
                    this.state = new byte[len];
                    ois.read(this.state);
                }
            }
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception exception) {}
        }
    }
}

