/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Manager;
import org.apache.catalina.util.Enumerator;
import org.glassfish.web.ha.session.management.BaseHASession;
import org.glassfish.web.ha.session.management.HASession;
import org.glassfish.web.ha.session.management.SessionAttributeState;

public class ModifiedAttributeHASession
extends BaseHASession
implements HttpSession,
HASession,
Serializable {
    private static final Logger _logger = LogDomains.getLogger(ModifiedAttributeHASession.class, (String)"javax.enterprise.system.container.web");
    private transient HashMap _attributeStates = new HashMap();
    private transient boolean _dirtyFlag = false;

    public ModifiedAttributeHASession(Manager manager) {
        super(manager);
    }

    public ArrayList getDeletedAttributes() {
        ArrayList<String> resultList = new ArrayList<String>();
        Set entries = this._attributeStates.entrySet();
        for (Map.Entry entry : entries) {
            SessionAttributeState nextAttrState = (SessionAttributeState)entry.getValue();
            String nextAttrName = (String)entry.getKey();
            if (!nextAttrState.isDeleted() || !nextAttrState.isPersistent()) continue;
            resultList.add(nextAttrName);
        }
        return resultList;
    }

    public ArrayList getModifiedAttributes() {
        ArrayList<String> resultList = new ArrayList<String>();
        Set entries = this._attributeStates.entrySet();
        for (Map.Entry entry : entries) {
            SessionAttributeState nextAttrState = (SessionAttributeState)entry.getValue();
            String nextAttrName = (String)entry.getKey();
            if (!nextAttrState.isDirty() || !nextAttrState.isPersistent() || nextAttrState.isDeleted()) continue;
            resultList.add(nextAttrName);
        }
        return resultList;
    }

    public ArrayList getAddedAttributes() {
        ArrayList<String> resultList = new ArrayList<String>();
        Set entries = this._attributeStates.entrySet();
        for (Map.Entry entry : entries) {
            SessionAttributeState nextAttrState = (SessionAttributeState)entry.getValue();
            String nextAttrName = (String)entry.getKey();
            if (nextAttrState.isPersistent() || nextAttrState.isDirty()) continue;
            resultList.add(nextAttrName);
        }
        return resultList;
    }

    public ArrayList getAddedAttributesPrevious() {
        ArrayList<String> resultList = new ArrayList<String>();
        Set entries = this._attributeStates.entrySet();
        for (Map.Entry entry : entries) {
            SessionAttributeState nextAttrState = (SessionAttributeState)entry.getValue();
            String nextAttrName = (String)entry.getKey();
            if (nextAttrState.isPersistent()) continue;
            resultList.add(nextAttrName);
        }
        return resultList;
    }

    void clearAttributeStates() {
        if (this._attributeStates == null) {
            this._attributeStates = new HashMap();
        }
        this._attributeStates.clear();
    }

    public void privateResetAttributeState() {
        this.resetAttributeState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetAttributeState() {
        this.clearAttributeStates();
        Map map = this.attributes;
        synchronized (map) {
            Enumeration attrNames = this.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                String nextAttrName = (String)attrNames.nextElement();
                SessionAttributeState nextAttrState = SessionAttributeState.createPersistentAttribute();
                this._attributeStates.put(nextAttrName, nextAttrState);
            }
            this.setDirty(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        Map map = this.attributes;
        synchronized (map) {
            super.setAttribute(name, value);
            SessionAttributeState attributeState = this.getAttributeState(name);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ModifiedAttributeHASession>>setAttribute name=" + name + " attributeState=" + attributeState);
            }
            if (value == null) {
                if (attributeState != null) {
                    if (attributeState.isPersistent()) {
                        attributeState.setDeleted(true);
                    } else {
                        this.removeAttributeState(name);
                    }
                }
            } else if (attributeState == null) {
                SessionAttributeState newAttrState = new SessionAttributeState();
                this._attributeStates.put(name, newAttrState);
            } else if (attributeState.isDeleted()) {
                attributeState.setDeleted(false);
            } else if (attributeState.isPersistent()) {
                attributeState.setDirty(true);
            }
            this.setDirty(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Map map = this.attributes;
        synchronized (map) {
            super.removeAttribute(name);
            SessionAttributeState attributeState = this.getAttributeState(name);
            if (attributeState != null) {
                if (attributeState.isPersistent()) {
                    attributeState.setDeleted(true);
                } else {
                    this.removeAttributeState(name);
                }
            }
            this.setDirty(true);
        }
    }

    SessionAttributeState getAttributeState(String attributeName) {
        return (SessionAttributeState)this._attributeStates.get(attributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttributeStatePersistent(String attributeName, boolean persistent) {
        Map map = this.attributes;
        synchronized (map) {
            SessionAttributeState attrState = (SessionAttributeState)this._attributeStates.get(attributeName);
            if (attrState == null) {
                attrState = new SessionAttributeState();
                attrState.setPersistent(persistent);
                this._attributeStates.put(attributeName, attrState);
            } else {
                attrState.setPersistent(persistent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttributeStateDirty(String attributeName, boolean dirty) {
        Map map = this.attributes;
        synchronized (map) {
            SessionAttributeState attrState = (SessionAttributeState)this._attributeStates.get(attributeName);
            if (attrState == null) {
                attrState = new SessionAttributeState();
                attrState.setDirty(dirty);
                this._attributeStates.put(attributeName, attrState);
            } else {
                attrState.setDirty(dirty);
            }
        }
    }

    void removeAttributeState(String attributeName) {
        this._attributeStates.remove(attributeName);
    }

    public boolean isDirty() {
        return this._dirtyFlag;
    }

    public void setDirty(boolean isDirty) {
        this._dirtyFlag = isDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration privateGetAttributeList() {
        Map map = this.attributes;
        synchronized (map) {
            return new Enumerator(new ArrayList(this.attributes.keySet()));
        }
    }
}

