/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.authenticator;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.web.ha.authenticator.HASessionData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HASingleSignOnEntryMetadata
implements Serializable {
    protected String id = null;
    protected String authType = null;
    protected byte[] principalBytes = null;
    protected Set<HASessionData> sessionDataSet = new HashSet<HASessionData>();
    protected String username = null;
    protected String realmName = null;
    protected long lastAccessTime;
    protected long maxIdleTime;
    protected long version;

    public HASingleSignOnEntryMetadata() {
    }

    public HASingleSignOnEntryMetadata(String id, byte[] principalBytes, String authType, String username, String realmName, long lastAccessTime, long maxIdleTime, long version) {
        this.id = id;
        this.principalBytes = principalBytes != null ? (byte[])principalBytes.clone() : null;
        this.authType = authType;
        this.username = username;
        this.realmName = realmName;
        this.lastAccessTime = lastAccessTime;
        this.maxIdleTime = maxIdleTime;
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public byte[] getPrincipalBytes() {
        return this.principalBytes;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public Set<HASessionData> getHASessionDataSet() {
        return this.sessionDataSet;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public long getVersion() {
        return this.version;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    boolean addHASessionData(HASessionData sessionData) {
        return this.sessionDataSet.add(sessionData);
    }

    boolean removeHASessionData(HASessionData sessionData) {
        return this.sessionDataSet.remove(sessionData);
    }

    public String toString() {
        return "HASingleSignOnEntryMetadata{id='" + this.id + '\'' + ", authType='" + this.authType + '\'' + ", sessionDataSet.size=" + this.sessionDataSet.size() + ", username='" + this.username + '\'' + ", realmName='" + this.realmName + '\'' + ", lastAccessTime=" + this.lastAccessTime + ", maxIdleTime=" + this.maxIdleTime + ", version=" + this.version + '}';
    }
}

