/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.deployment.EjbDescriptor;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.Extension;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.glassfish.weld.BeanDeploymentArchiveImpl;
import org.glassfish.weld.WeldUtils;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentImpl
implements Deployment {
    private List<BeanDeploymentArchive> jarBDAs;
    private List<BeanDeploymentArchive> warBDAs;
    private List<BeanDeploymentArchive> libJarBDAs = null;
    private List<BeanDeploymentArchive> beanDeploymentArchives = null;
    private DeploymentContext context;
    private Map<String, BeanDeploymentArchive> idToBeanDeploymentArchive;
    private SimpleServiceRegistry simpleServiceRegistry = null;
    private Logger logger = Logger.getLogger(DeploymentImpl.class.getName());

    public DeploymentImpl(ReadableArchive archive, Collection<EjbDescriptor> ejbs, DeploymentContext context) {
        this.logger.log(Level.FINE, "Creating deployment for archive:" + archive.getName());
        this.beanDeploymentArchives = new ArrayList<BeanDeploymentArchive>();
        this.context = context;
        this.idToBeanDeploymentArchive = new HashMap<String, BeanDeploymentArchive>();
        if (this.libJarBDAs == null) {
            this.libJarBDAs = this.scanForLibJars(archive, ejbs, context);
            if (this.libJarBDAs != null && this.libJarBDAs.size() > 0) {
                return;
            }
        }
        BeanDeploymentArchiveImpl bda = new BeanDeploymentArchiveImpl(archive, ejbs, context);
        this.beanDeploymentArchives.add(bda);
        if (bda.getBDAType().equals((Object)WeldUtils.BDAType.WAR)) {
            if (this.warBDAs == null) {
                this.warBDAs = new ArrayList<BeanDeploymentArchive>();
            }
            this.warBDAs.add(bda);
        } else if (bda.getBDAType().equals((Object)WeldUtils.BDAType.JAR)) {
            if (this.jarBDAs == null) {
                this.jarBDAs = new ArrayList<BeanDeploymentArchive>();
            }
            this.jarBDAs.add(bda);
        }
        this.idToBeanDeploymentArchive.put(bda.getId(), bda);
    }

    public void scanArchive(ReadableArchive archive, Collection<EjbDescriptor> ejbs, DeploymentContext context) {
        if (this.libJarBDAs == null) {
            this.libJarBDAs = this.scanForLibJars(archive, ejbs, context);
            if (this.libJarBDAs != null && this.libJarBDAs.size() > 0) {
                return;
            }
        }
        BeanDeploymentArchiveImpl bda = new BeanDeploymentArchiveImpl(archive, ejbs, context);
        this.context = context;
        if (this.idToBeanDeploymentArchive == null) {
            this.idToBeanDeploymentArchive = new HashMap<String, BeanDeploymentArchive>();
        }
        this.beanDeploymentArchives.add(bda);
        if (bda.getBDAType().equals((Object)WeldUtils.BDAType.WAR)) {
            if (this.warBDAs == null) {
                this.warBDAs = new ArrayList<BeanDeploymentArchive>();
            }
            this.warBDAs.add(bda);
        } else if (bda.getBDAType().equals((Object)WeldUtils.BDAType.JAR)) {
            if (this.jarBDAs == null) {
                this.jarBDAs = new ArrayList<BeanDeploymentArchive>();
            }
            this.jarBDAs.add(bda);
        }
        this.idToBeanDeploymentArchive.put(bda.getId(), bda);
    }

    public void buildDeploymentGraph() {
        boolean modifiedArchive;
        if (this.jarBDAs != null) {
            ListIterator<BeanDeploymentArchive> jarIter = this.jarBDAs.listIterator();
            while (jarIter.hasNext()) {
                modifiedArchive = false;
                BeanDeploymentArchive jarBDA = jarIter.next();
                ListIterator<BeanDeploymentArchive> jarIter1 = this.jarBDAs.listIterator();
                while (jarIter1.hasNext()) {
                    BeanDeploymentArchive jarBDA1 = jarIter1.next();
                    if (jarBDA1.getId().equals(jarBDA.getId())) continue;
                    jarBDA.getBeanDeploymentArchives().add(jarBDA1);
                    modifiedArchive = true;
                }
                if (this.libJarBDAs != null) {
                    ListIterator<BeanDeploymentArchive> libJarIter = this.libJarBDAs.listIterator();
                    while (libJarIter.hasNext()) {
                        BeanDeploymentArchive libJarBDA = libJarIter.next();
                        jarBDA.getBeanDeploymentArchives().add(libJarBDA);
                        modifiedArchive = true;
                    }
                }
                if (!modifiedArchive) continue;
                int idx = this.getBeanDeploymentArchives().indexOf(jarBDA);
                if (idx >= 0) {
                    this.getBeanDeploymentArchives().remove(idx);
                    this.getBeanDeploymentArchives().add(jarBDA);
                }
                modifiedArchive = false;
            }
        }
        if (this.warBDAs != null) {
            ListIterator<BeanDeploymentArchive> warIter = this.warBDAs.listIterator();
            modifiedArchive = false;
            while (warIter.hasNext()) {
                BeanDeploymentArchive warBDA = warIter.next();
                if (this.jarBDAs != null) {
                    ListIterator<BeanDeploymentArchive> jarIter = this.jarBDAs.listIterator();
                    while (jarIter.hasNext()) {
                        BeanDeploymentArchive jarBDA = jarIter.next();
                        warBDA.getBeanDeploymentArchives().add(jarBDA);
                        modifiedArchive = true;
                    }
                }
                if (this.libJarBDAs != null) {
                    ListIterator<BeanDeploymentArchive> libJarIter = this.libJarBDAs.listIterator();
                    while (libJarIter.hasNext()) {
                        BeanDeploymentArchive libJarBDA = libJarIter.next();
                        warBDA.getBeanDeploymentArchives().add(libJarBDA);
                        modifiedArchive = true;
                    }
                }
                if (!modifiedArchive) continue;
                int idx = this.getBeanDeploymentArchives().indexOf(warBDA);
                if (idx >= 0) {
                    this.getBeanDeploymentArchives().remove(idx);
                    this.getBeanDeploymentArchives().add(warBDA);
                }
                modifiedArchive = false;
            }
        }
    }

    public List<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return this.getBeanDeploymentArchives(true);
    }

    public List<BeanDeploymentArchive> getBeanDeploymentArchives(boolean printDebug) {
        if (printDebug) {
            this.logger.log(Level.FINE, "DeploymentImpl::getBDAs. Returning \n" + this.beanDeploymentArchives);
        }
        if (!this.beanDeploymentArchives.isEmpty()) {
            return this.beanDeploymentArchives;
        }
        return Collections.emptyList();
    }

    public BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass) {
        this.logger.log(Level.FINE, "DeploymentImpl::loadBDA:" + beanClass);
        List<BeanDeploymentArchive> beanDeploymentArchives = this.getBeanDeploymentArchives(false);
        ListIterator<BeanDeploymentArchive> lIter = beanDeploymentArchives.listIterator();
        while (lIter.hasNext()) {
            BeanDeploymentArchive bda = lIter.next();
            this.logger.log(Level.FINE, "checking for " + beanClass + " in root BDA" + bda.getId());
            if (((BeanDeploymentArchiveImpl)bda).getModuleBeanClasses().contains(beanClass.getName())) {
                this.logger.log(Level.FINE, "DeploymentImpl(as part of loadBDA)::An existing BDA has this class " + beanClass.getName() + " and so adding this class as a bean class it to " + "existing bda: " + bda);
                this.logger.log(Level.FINE, "Deployment(as part of loadBDA): and returning " + bda);
                return bda;
            }
            if (bda.getBeanDeploymentArchives().size() <= 0) continue;
            for (BeanDeploymentArchive subBda : bda.getBeanDeploymentArchives()) {
                Collection<String> s = ((BeanDeploymentArchiveImpl)subBda).getModuleBeanClasses();
                this.logger.log(Level.FINE, "checking for " + beanClass + " in subBDA" + subBda.getId());
                boolean match = s.contains(beanClass.getName());
                if (!match) continue;
                this.logger.log(Level.FINE, "DeploymentImpl(as part of loadBDA)::An existing BDA has this class " + beanClass.getName() + " and so adding this " + "class as a bean class to existing bda:" + subBda);
                this.logger.log(Level.FINE, "Deployment(as part of loadBDA): and returning " + subBda);
                return subBda;
            }
        }
        this.logger.log(Level.FINE, "+++++ DeploymentImpl(as part of loadBDA):: beanClass " + beanClass + " not found in the BDAs of this deployment. " + "Hence creating a new BDA");
        ArrayList beanClasses = new ArrayList();
        ArrayList<URL> beanXMLUrls = new ArrayList<URL>();
        HashSet<EjbDescriptor> ejbs = new HashSet<EjbDescriptor>();
        beanClasses.add(beanClass);
        BeanDeploymentArchiveImpl newBda = new BeanDeploymentArchiveImpl(beanClass.getName(), beanClasses, beanXMLUrls, ejbs, this.context);
        this.logger.log(Level.FINE, "DeploymentImpl(as part of loadBDA):: new BDA " + newBda + "created. Now adding this new BDA to " + "all root BDAs of this deployment");
        lIter = beanDeploymentArchives.listIterator();
        while (lIter.hasNext()) {
            BeanDeploymentArchive bda = lIter.next();
            bda.getBeanDeploymentArchives().add(newBda);
        }
        this.logger.log(Level.FINE, "DeploymentImpl(as part of loadBDA):: for beanClass " + beanClass + " finally returning the " + "newly created BDA " + newBda);
        return newBda;
    }

    public ServiceRegistry getServices() {
        if (this.simpleServiceRegistry == null) {
            this.simpleServiceRegistry = new SimpleServiceRegistry();
        }
        return this.simpleServiceRegistry;
    }

    public Iterable<Metadata<Extension>> getExtensions() {
        return ((WeldBootstrap)this.context.getTransientAppMetaData("org.glassfish.weld.WeldBootstrap", WeldBootstrap.class)).loadExtensions(Thread.currentThread().getContextClassLoader());
    }

    public String toString() {
        String val = null;
        Collection beanDeploymentArchives = this.getBeanDeploymentArchives();
        ListIterator lIter = beanDeploymentArchives.listIterator();
        while (lIter.hasNext()) {
            BeanDeploymentArchive bda = (BeanDeploymentArchive)lIter.next();
            val = val + bda.toString();
        }
        return val;
    }

    public BeanDeploymentArchive getBeanDeploymentArchiveForArchive(String archiveId) {
        return this.idToBeanDeploymentArchive.get(archiveId);
    }

    public void cleanup() {
        if (this.jarBDAs != null) {
            this.jarBDAs.clear();
        }
        if (this.warBDAs != null) {
            this.warBDAs.clear();
        }
        if (this.libJarBDAs != null) {
            this.libJarBDAs.clear();
        }
        if (this.idToBeanDeploymentArchive != null) {
            this.idToBeanDeploymentArchive.clear();
        }
    }

    private List<BeanDeploymentArchive> scanForLibJars(ReadableArchive archive, Collection<EjbDescriptor> ejbs, DeploymentContext context) {
        String libDir;
        ArrayList<ReadableArchive> libJars = null;
        ApplicationHolder holder = (ApplicationHolder)context.getModuleMetaData(ApplicationHolder.class);
        if (holder != null && holder.app != null && (libDir = holder.app.getLibraryDirectory()) != null && !libDir.isEmpty()) {
            Enumeration entries = archive.entries(libDir);
            while (entries.hasMoreElements()) {
                String entryName = (String)entries.nextElement();
                if (!entryName.endsWith(".jar") || entryName.indexOf(47, libDir.length() + 1) != -1) continue;
                try {
                    ReadableArchive jarInLib = archive.getSubArchive(entryName);
                    if (jarInLib.exists("META-INF/beans.xml")) {
                        if (libJars == null) {
                            libJars = new ArrayList<ReadableArchive>();
                        }
                        libJars.add(jarInLib);
                        continue;
                    }
                    if (!jarInLib.exists(WeldUtils.META_INF_SERVICES_EXTENSION)) continue;
                    if (libJars == null) {
                        libJars = new ArrayList();
                    }
                    libJars.add(jarInLib);
                }
                catch (IOException e) {
                    this.logger.log(Level.FINE, "Exception thrown while scanning for library jars", e);
                }
            }
        }
        if (libJars != null) {
            libDir = holder.app.getLibraryDirectory();
            ListIterator libJarIterator = libJars.listIterator();
            while (libJarIterator.hasNext()) {
                ReadableArchive libJarArchive = (ReadableArchive)libJarIterator.next();
                BeanDeploymentArchiveImpl bda = new BeanDeploymentArchiveImpl(libJarArchive, ejbs, context, libDir + '/' + libJarArchive.getName());
                this.beanDeploymentArchives.add(bda);
                if (this.libJarBDAs == null) {
                    this.libJarBDAs = new ArrayList<BeanDeploymentArchive>();
                }
                this.libJarBDAs.add(bda);
                this.idToBeanDeploymentArchive.put(bda.getId(), bda);
            }
            this.ensureEarLibJarVisibility(this.libJarBDAs);
        }
        return this.libJarBDAs;
    }

    private void ensureEarLibJarVisibility(List<BeanDeploymentArchive> earLibBDAs) {
        for (int i = 0; i < earLibBDAs.size(); ++i) {
            BeanDeploymentArchive firstBDA = earLibBDAs.get(i);
            boolean modified = false;
            for (int j = 0; j < earLibBDAs.size(); ++j) {
                BeanDeploymentArchive otherBDA = earLibBDAs.get(j);
                if (firstBDA.getId().equals(otherBDA.getId())) continue;
                this.logger.log(Level.FINE, "DeploymentImpl::ensureEarLibJarVisibility - " + firstBDA.getId() + " being associated with " + otherBDA.getId());
                firstBDA.getBeanDeploymentArchives().add(otherBDA);
                modified = true;
            }
            if (!modified) continue;
            int idx = this.beanDeploymentArchives.indexOf(firstBDA);
            this.logger.log(Level.FINE, "DeploymentImpl::ensureEarLibJarVisibility - updating " + firstBDA.getId());
            if (idx < 0) continue;
            this.beanDeploymentArchives.set(idx, firstBDA);
        }
    }
}

