/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionTarget;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.weld.WeldUtils;
import org.glassfish.weld.ejb.EjbDescriptorImpl;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.ejb.spi.EjbDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeploymentArchiveImpl
implements BeanDeploymentArchive {
    private Logger logger = Logger.getLogger(BeanDeploymentArchiveImpl.class.getName());
    private ReadableArchive archive;
    private String id;
    private List<Class<?>> moduleClasses = null;
    private List<Class<?>> beanClasses = null;
    private Set<URL> wUrls = null;
    private final Collection<EjbDescriptor<?>> ejbDescImpls;
    private List<BeanDeploymentArchive> beanDeploymentArchives;
    private SimpleServiceRegistry simpleServiceRegistry = null;
    private WeldUtils.BDAType bdaType = WeldUtils.BDAType.UNKNOWN;
    private DeploymentContext context;
    private final Map<AnnotatedType<?>, InjectionTarget<?>> itMap = new HashMap();
    private ClassLoader moduleClassLoaderForBDA = null;
    private String friendlyId = "";

    public BeanDeploymentArchiveImpl(ReadableArchive archive, Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs, DeploymentContext ctx) {
        this(archive, ejbs, ctx, null);
    }

    public BeanDeploymentArchiveImpl(ReadableArchive archive, Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs, DeploymentContext ctx, String bdaID) {
        this.beanClasses = new ArrayList();
        this.moduleClasses = new ArrayList();
        this.wUrls = new CopyOnWriteArraySet<URL>();
        this.archive = archive;
        this.id = bdaID == null ? archive.getName() : bdaID;
        this.friendlyId = this.id;
        this.ejbDescImpls = new HashSet();
        this.beanDeploymentArchives = new ArrayList<BeanDeploymentArchive>();
        this.context = ctx;
        this.populate(ejbs);
        this.populateEJBsForThisBDA(ejbs);
        try {
            this.archive.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.archive = null;
        this.moduleClassLoaderForBDA = Thread.currentThread().getContextClassLoader();
    }

    private void populateEJBsForThisBDA(Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs) {
        for (com.sun.enterprise.deployment.EjbDescriptor next : ejbs) {
            for (Class<?> c : this.moduleClasses) {
                if (!c.getName().equals(next.getEjbClassName())) continue;
                EjbDescriptorImpl wbEjbDesc = new EjbDescriptorImpl(next);
                this.ejbDescImpls.add(wbEjbDesc);
            }
        }
    }

    public BeanDeploymentArchiveImpl(String id, List<Class<?>> wClasses, Set<URL> wUrls, Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs, DeploymentContext ctx) {
        this.id = id;
        this.moduleClasses = wClasses;
        this.beanClasses = new ArrayList(wClasses);
        this.wUrls = wUrls;
        this.ejbDescImpls = new HashSet();
        this.beanDeploymentArchives = new ArrayList<BeanDeploymentArchive>();
        this.context = ctx;
        this.populateEJBsForThisBDA(ejbs);
        this.moduleClassLoaderForBDA = Thread.currentThread().getContextClassLoader();
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return this.beanDeploymentArchives;
    }

    public Collection<String> getBeanClasses() {
        ArrayList<String> s = new ArrayList<String>();
        Iterator<Class<?>> iterator = this.beanClasses.iterator();
        while (iterator.hasNext()) {
            String classname = iterator.next().getName();
            s.add(classname);
        }
        this.logger.log(Level.FINER, "set TCL for " + this.id + " to " + this.moduleClassLoaderForBDA);
        Thread.currentThread().setContextClassLoader(this.moduleClassLoaderForBDA);
        return s;
    }

    public Collection<Class<?>> getBeanClassObjects() {
        return this.beanClasses;
    }

    public Collection<String> getModuleBeanClasses() {
        ArrayList<String> s = new ArrayList<String>();
        Iterator<Class<?>> iterator = this.moduleClasses.iterator();
        while (iterator.hasNext()) {
            String classname = iterator.next().getName();
            s.add(classname);
        }
        return s;
    }

    public void addBeanClass(String beanClassName) {
        boolean added = false;
        for (Class<?> c : this.moduleClasses) {
            if (!c.getName().equals(beanClassName)) continue;
            this.logger.log(Level.FINE, "BeanDeploymentArchiveImpl::addBeanClass - adding " + c + "to " + this.beanClasses);
            this.beanClasses.add(c);
            added = true;
        }
        if (!added) {
            this.logger.log(Level.FINE, "Error!!!! " + beanClassName + " not added to beanClasses");
        }
    }

    public BeansXml getBeansXml() {
        WeldBootstrap wb = (WeldBootstrap)this.context.getTransientAppMetaData("org.glassfish.weld.WeldBootstrap", WeldBootstrap.class);
        return wb.parse(this.wUrls);
    }

    public Collection<EjbDescriptor<?>> getEjbs() {
        return this.ejbDescImpls;
    }

    public EjbDescriptor getEjbDescriptor(String ejbName) {
        EjbDescriptor<?> match = null;
        for (EjbDescriptor<?> next : this.ejbDescImpls) {
            if (!next.getEjbName().equals(ejbName)) continue;
            match = next;
            break;
        }
        return match;
    }

    public ServiceRegistry getServices() {
        if (this.simpleServiceRegistry == null) {
            this.simpleServiceRegistry = new SimpleServiceRegistry();
        }
        return this.simpleServiceRegistry;
    }

    public String getId() {
        return this.id;
    }

    public String getFriendlyId() {
        return this.friendlyId;
    }

    public String toString() {
        String beanClassesString = this.getBeanClasses().size() > 0 ? this.getBeanClasses().toString() : "";
        String val = "|ID: " + this.getId() + ", bdaType= " + (Object)((Object)this.bdaType) + ", accessibleBDAs #:" + this.getBeanDeploymentArchives().size() + ", " + this.formatAccessibleBDAs(this) + ", Bean Classes #: " + this.getBeanClasses().size() + "," + beanClassesString + ", ejbs=" + this.getEjbs() + "\n";
        Collection<BeanDeploymentArchive> bdas = this.getBeanDeploymentArchives();
        for (BeanDeploymentArchive bda : bdas) {
            WeldUtils.BDAType embedBDAType = WeldUtils.BDAType.UNKNOWN;
            if (bda instanceof BeanDeploymentArchiveImpl) {
                embedBDAType = ((BeanDeploymentArchiveImpl)bda).getBDAType();
            }
            String embedBDABeanClasses = bda.getBeanClasses().size() > 0 ? bda.getBeanClasses().toString() : "";
            val = val + "|---->ID: " + bda.getId() + ", bdaType= " + embedBDAType.toString() + ", accessibleBDAs #:" + bda.getBeanDeploymentArchives().size() + ", " + this.formatAccessibleBDAs(bda) + ", Bean Classes #: " + bda.getBeanClasses().size() + "," + embedBDABeanClasses + ", ejbs=" + bda.getEjbs() + "\n";
        }
        return val;
    }

    private String formatAccessibleBDAs(BeanDeploymentArchive bda) {
        StringBuffer sb = new StringBuffer("[");
        for (BeanDeploymentArchive accessibleBDA : bda.getBeanDeploymentArchives()) {
            if (!(accessibleBDA instanceof BeanDeploymentArchiveImpl)) continue;
            sb.append(((BeanDeploymentArchiveImpl)accessibleBDA).getFriendlyId() + ",");
        }
        sb.append("]");
        return sb.toString();
    }

    public WeldUtils.BDAType getBDAType() {
        return this.bdaType;
    }

    private void populate(Collection<com.sun.enterprise.deployment.EjbDescriptor> ejbs) {
        try {
            Enumeration entries;
            if (this.archive.exists("WEB-INF/beans.xml")) {
                this.logger.log(Level.FINE, "-processing " + this.archive.getURI() + " as it has WEB-INF/beans.xml");
                this.bdaType = WeldUtils.BDAType.WAR;
                entries = this.archive.entries();
                while (entries.hasMoreElements()) {
                    String entry = (String)entries.nextElement();
                    if (entry.endsWith(".class")) {
                        entry = entry.substring("WEB-INF/classes".length() + 1);
                        String className = BeanDeploymentArchiveImpl.filenameToClassname(entry);
                        this.beanClasses.add(this.getClassLoader().loadClass(className));
                        this.moduleClasses.add(this.getClassLoader().loadClass(className));
                        continue;
                    }
                    if (!entry.endsWith("beans.xml")) continue;
                    URI uri = this.archive.getURI();
                    File file = new File(uri.getPath() + entry);
                    URL beansXmlUrl = file.toURI().toURL();
                    this.wUrls.add(beansXmlUrl);
                }
                this.archive.close();
            }
            if (this.archive.exists("WEB-INF/lib")) {
                this.logger.log(Level.FINE, "-processing WEB-INF/lib in " + this.archive.getURI());
                this.bdaType = WeldUtils.BDAType.WAR;
                entries = this.archive.entries("WEB-INF/lib");
                ArrayList<ReadableArchive> weblibJarsThatAreBeanArchives = new ArrayList<ReadableArchive>();
                while (entries.hasMoreElements()) {
                    String entry = (String)entries.nextElement();
                    if (!entry.endsWith(".jar") || entry.indexOf(47, "WEB-INF/lib".length() + 1) != -1) continue;
                    ReadableArchive weblibJarArchive = this.archive.getSubArchive(entry);
                    if (weblibJarArchive.exists("META-INF/beans.xml")) {
                        this.logger.log(Level.FINE, "-WEB-INF/lib: considering " + entry + " as a bean archive and hence added another BDA for it");
                        weblibJarsThatAreBeanArchives.add(weblibJarArchive);
                        continue;
                    }
                    if (weblibJarArchive.exists(WeldUtils.META_INF_SERVICES_EXTENSION)) {
                        this.logger.log(Level.FINE, "-WEB-INF/lib: considering " + entry + " as an extension and creating another BDA for it");
                        weblibJarsThatAreBeanArchives.add(weblibJarArchive);
                        continue;
                    }
                    this.logger.log(Level.FINE, "-WEB-INF/lib: skipping " + this.archive.getName() + " as it doesn't have beans.xml or an extension");
                }
                ArrayList<BeanDeploymentArchiveImpl> webLibBDAs = new ArrayList<BeanDeploymentArchiveImpl>();
                if (weblibJarsThatAreBeanArchives.size() > 0) {
                    ListIterator libJarIterator = weblibJarsThatAreBeanArchives.listIterator();
                    while (libJarIterator.hasNext()) {
                        ReadableArchive libJarArchive = (ReadableArchive)libJarIterator.next();
                        BeanDeploymentArchiveImpl wlbda = new BeanDeploymentArchiveImpl(libJarArchive, ejbs, this.context, "WEB-INF/lib/" + libJarArchive.getName());
                        this.beanDeploymentArchives.add(wlbda);
                        webLibBDAs.add(wlbda);
                    }
                }
                this.ensureWebLibJarVisibility(webLibBDAs);
            }
            if (this.archive.getName().endsWith(".rar") || this.archive.getName().endsWith("_rar")) {
                this.collectRarInfo(this.archive);
            }
            if (this.archive.exists("META-INF/beans.xml")) {
                this.logger.log(Level.FINE, "-JAR processing: " + this.archive.getURI() + " as a Bean archive jar since it has META-INF/beans.xml");
                this.bdaType = WeldUtils.BDAType.JAR;
                this.collectJarInfo(this.archive, true);
            }
            if (this.archive.exists(WeldUtils.META_INF_SERVICES_EXTENSION)) {
                this.logger.log(Level.FINE, "-JAR processing: " + this.archive.getURI() + " as an extensions jar since it has META-INF/services extension");
                this.bdaType = WeldUtils.BDAType.UNKNOWN;
                this.collectJarInfo(this.archive, false);
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (ClassNotFoundException cne) {
            this.logger.log(Level.SEVERE, cne.getLocalizedMessage(), cne);
        }
    }

    private void ensureWebLibJarVisibility(List<BeanDeploymentArchiveImpl> webLibBDAs) {
        int i;
        for (i = 0; i < webLibBDAs.size(); ++i) {
            BeanDeploymentArchiveImpl firstBDA = webLibBDAs.get(i);
            boolean modified = false;
            for (int j = 0; j < webLibBDAs.size(); ++j) {
                BeanDeploymentArchiveImpl otherBDA = webLibBDAs.get(j);
                if (firstBDA.getId().equals(otherBDA.getId())) continue;
                this.logger.log(Level.FINE, "BDAImpl::ensureWebLibJarVisibility - " + firstBDA.getFriendlyId() + " being associated with " + otherBDA.getFriendlyId());
                firstBDA.getBeanDeploymentArchives().add(otherBDA);
                modified = true;
            }
            if (!modified) continue;
            int idx = this.beanDeploymentArchives.indexOf(firstBDA);
            this.logger.log(Level.FINE, "BDAImpl::ensureWebLibJarVisibility - updating " + firstBDA.getFriendlyId());
            if (idx < 0) continue;
            this.beanDeploymentArchives.set(idx, firstBDA);
        }
        for (i = 0; i < webLibBDAs.size(); ++i) {
            BeanDeploymentArchiveImpl subBDA = webLibBDAs.get(i);
            subBDA.getBeanDeploymentArchives().add(this);
            this.logger.log(Level.FINE, "BDAImpl::ensureWebLibJarVisibility - updating " + subBDA.getId() + " to include " + this.getId());
            int idx = this.beanDeploymentArchives.indexOf(subBDA);
            if (idx < 0) continue;
            this.beanDeploymentArchives.set(idx, subBDA);
        }
    }

    private void collectJarInfo(ReadableArchive archive, boolean isBeanArchive) throws IOException, ClassNotFoundException {
        this.logger.log(Level.FINE, "-collecting jar info for " + archive.getURI());
        Enumeration entries = archive.entries();
        while (entries.hasMoreElements()) {
            String entry = (String)entries.nextElement();
            this.handleEntry(entry, isBeanArchive);
        }
    }

    private void handleEntry(String entry, boolean isBeanArchive) throws ClassNotFoundException {
        if (entry.endsWith(".class")) {
            String className = BeanDeploymentArchiveImpl.filenameToClassname(entry);
            if (isBeanArchive) {
                this.beanClasses.add(this.getClassLoader().loadClass(className));
            }
            this.moduleClasses.add(this.getClassLoader().loadClass(className));
        } else if (entry.endsWith("beans.xml")) {
            URL beansXmlUrl = Thread.currentThread().getContextClassLoader().getResource(entry);
            this.wUrls.add(beansXmlUrl);
        }
    }

    private void collectRarInfo(ReadableArchive archive) throws IOException, ClassNotFoundException {
        this.logger.log(Level.FINE, "-collecting rar info for " + archive.getURI());
        Enumeration entries = archive.entries();
        while (entries.hasMoreElements()) {
            String entry = (String)entries.nextElement();
            if (entry.endsWith(".jar")) {
                ReadableArchive jarArchive = archive.getSubArchive(entry);
                this.collectJarInfo(jarArchive, true);
                continue;
            }
            this.handleEntry(entry, true);
        }
    }

    private static String filenameToClassname(String filename) {
        String className = null;
        className = filename.indexOf(File.separatorChar) >= 0 ? filename.replace(File.separatorChar, '.') : filename.replace('/', '.');
        className = className.substring(0, className.length() - 6);
        return className;
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl;
        if (this.context.getClassLoader() != null) {
            cl = this.context.getClassLoader();
        } else if (Thread.currentThread().getContextClassLoader() != null) {
            this.logger.log(Level.FINE, "Using TCL");
            cl = Thread.currentThread().getContextClassLoader();
        } else {
            this.logger.log(Level.FINE, "TCL is null. Using DeploymentImpl's classloader");
            cl = BeanDeploymentArchiveImpl.class.getClassLoader();
        }
        this.moduleClassLoaderForBDA = cl;
        return cl;
    }

    public InjectionTarget<?> getInjectionTarget(AnnotatedType<?> annotatedType) {
        return this.itMap.get(annotatedType);
    }

    void putInjectionTarget(AnnotatedType<?> annotatedType, InjectionTarget<?> it) {
        this.itMap.put(annotatedType, it);
    }
}

