/*
 * Decompiled with CFR 0.152.
 */
package org.glassmaker.spring.web;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.ServletContext;
import org.glassmaker.spring.web.TemplateMerger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="freemarkerMerger")
public class FreemarkerMerger
implements TemplateMerger,
InitializingBean {
    @Autowired
    private ServletContext context;
    @Value(value="${freemarkerpath:/WEB-INF/cards}")
    private String freemarkerpath;
    @Value(value="${cardextension:.card}")
    private String cardextension;
    private Configuration cfg;

    public void afterPropertiesSet() throws Exception {
        this.cfg = new Configuration();
        this.cfg.setOutputEncoding("UTF-8");
        this.cfg.setServletContextForTemplateLoading((Object)this.context, this.freemarkerpath);
    }

    @Override
    public String merge(String templateName, Map<String, ?> data) throws Exception {
        Template template = this.cfg.getTemplate(templateName + this.cardextension, "UTF-8");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bos, Charset.forName("UTF-8"));
        template.process(data, (Writer)out);
        return bos.toString("UTF-8");
    }

    public String getFreemarkerpath() {
        return this.freemarkerpath;
    }

    public void setFreemarkerpath(String freemarkerpath) {
        this.freemarkerpath = freemarkerpath;
    }

    public String getCardextension() {
        return this.cardextension;
    }

    public void setCardextension(String cardextension) {
        this.cardextension = cardextension;
    }

    public ServletContext getContext() {
        return this.context;
    }

    public void setContext(ServletContext context) {
        this.context = context;
    }
}

